import axios from '@/libs/api.request'

export const login = ({ userName, password, code }) => {
  const data = JSON.stringify({
    username: userName,
    password: password,
    code: code
  })
  // return axios.request({
  //   url: '/api/uc/sc/loginService/userLogin',
  //   data: data,
  //   method: 'post'
  // })
  return axios.request({
    url: '/api/uc/sc/loginService/userLogin_encrypt',
    data: data,
    method: 'post'
  })
}

export const getUserInfo = () => {
  return axios.request({
    url: '/api/ac/sc/systemUserService/info',
    method: 'post',
    data: { a: 1 }
  })
}

export const logout = () => {
  return axios.request({
    url: '/manager/ajaxlogout',
    method: 'get'
  })
}

export const getUnreadCount = () => {
  return axios.request({
    url: 'mock/message/count',
    method: 'get'
  })
}

export const getMessage = () => {
  return axios.request({
    url: 'mock/message/init',
    method: 'get'
  })
}

export const getContentByMsgId = msg_id => {
  return axios.request({
    url: 'message/content',
    method: 'get',
    params: {
      msg_id
    }
  })
}

export const hasRead = msg_id => {
  return axios.request({
    url: 'message/has_read',
    method: 'post',
    data: {
      msg_id
    }
  })
}

export const removeReaded = msg_id => {
  return axios.request({
    url: 'message/remove_readed',
    method: 'post',
    data: {
      msg_id
    }
  })
}

export const restoreTrash = msg_id => {
  return axios.request({
    url: 'message/restore',
    method: 'post',
    data: {
      msg_id
    }
  })
}

export const updatePwd = (param) => {
  return axios.request({
    url: '/api/ac/sc/systemUserService/updatePwd',
    method: 'post',
    data: param
  })
}
export const getWeChatLoginQrCode = (param) => {
  return axios.request({
    url: '/api/uc/csc/weChatService/getWeChatLoginQrCode',
    method: 'post',
    data: param
  })
}
export const getWeChatUserInfo = (param) => {
  return axios.request({
    url: '/api/uc/csc/weChatService/getWeChatUserInfo',
    method: 'post',
    data: param
  })
}
export const scanQrCode = (param) => {
  return axios.request({
    url: '/api/uc/csc/weChatService/scanQrCode',
    method: 'post',
    data: param
  })
}
