import axios from '@/libs/api.request'

export const upBase64 = (base64) => {
  return axios.request({
    url: 'https://txy.juyouhx.com/Api/Api/upBase64ToOss',
    data: { base64: base64 },
    method: 'post',
    php: true
  })
}

// 获取全国省市信息，传参为省列表，传省级code查询对应市级
export const getCityList = (data) => {
  return axios.request({
    url: '/api/as/sc/city/arealist',
    data: data,
    method: 'post'
  })
}

// 上传图片到民政生产服务器
export const uploadPic = (data) => {
  return axios.request({
    // url: 'http://10.40.20.11:5000/api/uc/csc/auditOrderService/uploadPic',
    url: '/api/uc/mzsc/uploadService/uploadPic',
    data: data,
    method: 'post'
  })
}

export const imgComparison = (img1, img2) => {
  return axios.request({
    url: '/api/uc/csc/faceCompareService/createFaceCompare',
    data: { type: 2, value1: img1, value2: img2 },
    method: 'post'
  })
}

export const formBuild = () => {
  return axios.request({
    url: '/api/cln/csc/autoItemForm/testform',
    method: 'get'
  })
}
export const createUpLoadFiles = (url, data) => {
  return axios.request({
    url: url,
    data: data,
    method: 'post'
  })
}
export const getSign = (data) => {
  // console.log(data)
  return axios.request({
    url: '/api/ac/csc/auditHadoopUploadFilesService/getSign',
    data: data,
    method: 'post'
  })
}
export const updateUserGPY = (data) => {
  return axios.request({
    url: '/api/ac/sc/systemUserService/updateUserGPY',
    data: data,
    method: 'post'
  })
}
// 一级残疾人身份验证接口
export const disabilityInfoVerify = (data) => {
  return axios.request({
    url: '/api/uc/csc/auditOrder3rdService/disabilityInfoVerify',
    data: data,
    method: 'post'
  })
}
// 重复申请验证接口
export const repetitionApply = (data) => {
  return axios.request({
    url: '/api/uc/csc/auditOrder3rdService/repetitionApply',
    data: data,
    method: 'post'
  })
}

// 获取用户基本信息
export const getUserInfoByLoginName = (data) => {
  return axios.request({
    url: '/api/ac/sc/systemUserService/getUserInfoByLoginName',
    data: data,
    method: 'post'
  })
}

// 初始化账号基本信息
export const updateResetAccount = (data) => {
  return axios.request({
    url: '/api/ac/sc/systemUserService/updateResetAccount',
    data: data,
    method: 'post'
  })
}
// 字典表接口
export const getDictList = (data) => {
  return axios.request({
    url: '/api/as/sc/dict/getDictList',
    method: 'post',
    data: data
  })
}
// 压缩图片
export function compressImg (file) {
  // var src = ''
  // var files = ''
  var fileSize = parseFloat(parseInt(file['size']) / 1024 / 1024).toFixed(2)
  var read = new FileReader()
  read.readAsDataURL(file)
  return new Promise(function (resolve, reject) {
    read.onload = function (e) {
      var img = new Image()
      img.src = e.target.result
      img.onload = function () {
        // 默认按比例压缩
        var w = this.width
        var h = this.height
        // 生成canvas
        var canvas = document.createElement('canvas')
        var ctx = canvas.getContext('2d')
        var base64 = ''
        // 创建属性节点
        canvas.setAttribute('width', w)
        canvas.setAttribute('height', h)
        ctx.drawImage(this, 0, 0, w, h)
        if (fileSize < 1) {
          // 如果图片小于一兆 那么不执行压缩操作
          base64 = canvas.toDataURL(file['type'], 1)
          console.log(base64)
        } else if (fileSize > 1 && fileSize < 5) {
          // 如果图片大于1M并且小于2M 那么压缩0.5
          base64 = canvas.toDataURL(file['type'], 0.5)
          console.log(base64, '压缩0.5')
        } else {
          console.log('图片大于2M')
          // 如果图片超过2m 那么压缩0.2
          base64 = canvas.toDataURL(file['type'], 0.2)
          console.log(base64, '压缩0.2')
        }
        // 回调函数返回file的值（将base64编码转成file）
        // files = dataURLtoFile(base64) // 如果后台接收类型为base64的话这一步可以省略
        resolve(base64)
      }
    }
  })
}
// 身份证校验方法
export function testid (id) {
  // 1 "验证通过!", 0 //校验不通过 // id为身份证号码
  var format = /^(([1][1-5])|([2][1-3])|([3][1-7])|([4][1-6])|([5][0-4])|([6][1-5])|([7][1])|([8][1-2]))\d{4}(([1][9]\d{2})|([2]\d{3}))(([0][1-9])|([1][0-2]))(([0][1-9])|([1-2][0-9])|([3][0-1]))\d{3}[0-9xX]$/
  // 号码规则校验
  if (!format.test(id)) {
    // this.$Modal.error({
    //   title: '错误提醒',
    //   content: '<p>身份证号码不合规</p>',
    //   onOk: () => {
    //     console.log('关闭失败框')
    //   }
    // })
    return false
    // return { 'status': 0, 'msg': '身份证号码不合规' }
  }
  // 区位码校验
  // 出生年月日校验  前正则限制起始年份为1900;
  var year = id.substr(6, 4) // 身份证年
  var month = id.substr(10, 2) // 身份证月
  var date = id.substr(12, 2) // 身份证日
  var time = Date.parse(month + '-' + date + '-' + year) // 身份证日期时间戳date
  var now_time = Date.parse(new Date()) // 当前时间戳
  var dates = (new Date(year, month, 0)).getDate() // 身份证当月天数
  if (time > now_time || date > dates) {
    // this.$Modal.error({
    //   title: '错误提醒',
    //   content: '<p>出生日期不合规</p>',
    //   onOk: () => {
    //     console.log('关闭失败框')
    //   }
    // })
    return false
    // return { 'status': 0, 'msg': '出生日期不合规' }
  }
  // 校验码判断
  var c = [7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2] // 系数
  var b = ['1', '0', 'X', '9', '8', '7', '6', '5', '4', '3', '2'] // 校验码对照表
  var id_array = id.split('')
  var sum = 0
  for (var k = 0; k < 17; k++) {
    sum += parseInt(id_array[k]) * parseInt(c[k])
  }
  if (id_array[17].toUpperCase() !== b[sum % 11].toUpperCase()) {
    // this.$Modal.error({
    //   title: '错误提醒',
    //   content: '<p>身份证校验码不合规</p>',
    //   onOk: () => {
    //     console.log('关闭失败框')
    //   }
    // })
    return false
    // return { 'status': 0, 'msg': '身份证校验码不合规' }
  }
  return true
  // return { 'status': 1, 'msg': '校验通过' }
}
export function getInfoFromId (id, type) {
  if (id.length !== 18) {
    throw new Error('身份证号码长度不正确')
  }
  if (type === '1') {
    // 1：男，2：女
    const sex = (id[16] % 2 === 0) ? '2' : '1'
    return sex
  } else if (type === '2') {
    const birthdate = id.substring(6, 14)
    const year = parseInt(birthdate.substring(0, 4), 10)
    const month = parseInt(birthdate.substring(4, 6), 10)
    const day = parseInt(birthdate.substring(6, 8), 10)
    const birthdate1 = `${year}-${month.toString().padStart(2, '0')}-${day.toString().padStart(2, '0')}`
    return birthdate1
  }
}
