import axios from '../../libs/api.request'

/*
 系统管理-菜单管理
 */
// 菜单列表
export const getMenuList = (data) => {
  return axios.request({
    url: '/api/ac/sc/menuService/getMenuList',
    // data: data,
    method: 'get'
  })
}
// 上级菜单列表
export const getSuperMenuList = (data) => {
  return axios.request({
    url: '/api/as/sc/menu/getOneList',
    // data: data,
    method: 'get'
  })
}
// 菜单列表-删除
export const deleteMenu = (data) => {
  return axios.request({
    url: '/api/ac/sc/menuService/deleteMenu',
    data: data,
    method: 'post'
  })
}
// 机构操作-根据id获取菜单信息
export const getMenuById = (data) => {
  return axios.request({
    url: '/api/as/sc/menu/getById',
    data: data,
    method: 'post'
  })
}
// 机构操作-保存
export const updateMenu = (data) => {
  return axios.request({
    url: '/api/ac/sc/menuService/updateMenu',
    data: data,
    method: 'post'
  })
}
// 机构操作-分配接口-模块编码
export const getDictInfoList = (data) => {
  return axios.request({
    url: '/api/as/sc/dict/getDictInfoList',
    data: data,
    method: 'post'
  })
}
// 机构操作-分配接口-接口列表
export const getForMenuList = (data) => {
  return axios.request({
    url: '/api/as/sc/menu/getForMenuList',
    data: data,
    method: 'post'
  })
}
// 机构操作-获取当前菜单的接口
export const getInForMenu = (data) => {
  return axios.request({
    url: '/api/ac/sc/menuService/getInForMenu',
    data: data,
    method: 'post'
  })
}
/*
 系统管理-机构管理
 */
// 机构列表
export const getCompanyList = (data) => {
  return axios.request({
    url: '/api/ac/sc/office/getList',
    // data: data,
    method: 'get'
  })
}
// 机构列表-删除
export const deleteOffice = (data) => {
  return axios.request({
    url: '/api/ac/sc/office/deleteOffice',
    data: data,
    method: 'post'
  })
}
// 机构操作-归属区域列表
export const getAreaList = (data) => {
  return axios.request({
    url: '/api/as/sc/area/getList',
    // data: data,
    method: 'get'
  })
}
// 机构操作-根据id获取机构信息
export const getById = (data, url) => {
  url = url || '/api/as/sc/office/getById'
  return axios.request({
    url: url,
    data: data,
    method: 'post'
  })
}
// 机构操作-保存
export const saveOffice = (data) => {
  return axios.request({
    url: '/api/ac/sc/office/saveOffice',
    data: data,
    method: 'post'
  })
}
// 机构操作-保存 民政new
export const saveOfficeMZnew = (data) => {
  return axios.request({
    url: '/api/ac/csc/auditCustomerService/getOffice',
    data: data,
    method: 'post'
  })
}
// 查询角色组列表
export const findRolegroupList = (data) => {
  return axios.request({
    url: '/api/ac/csc/auditCustomerService/findRolegroupList',
    data: data,
    method: 'post'
  })
}
// 机构操作-角色列表
export const getCompanyRoleList = (data) => {
  return axios.request({
    url: '/api/as/sc/role/getForUserList',
    data: data,
    method: 'post'
  })
}
/*
 系统管理-用户管理
 */
// 机构列表
export const getForUserList = (data) => {
  return axios.request({
    url: '/api/as/sc/role/getForUserList',
    data: data,
    method: 'post'
  })
}
// 树状图
export const getList = (data) => {
  return axios.request({
    url: '/api/ac/sc/office/getList',
    data: data,
    method: 'post'
  })
}
// 列表数据
export const getUserList = (data) => {
  return axios.request({
    url: '/api/ac/sc/systemUserService/getUserList',
    data: data,
    method: 'post'
  })
}
// 添加用户
export const addUser = (data) => {
  return axios.request({
    url: '/api/ac/sc/systemUserService/addUser',
    data: data,
    method: 'post'
  })
}
// 修改用户
export const userIdGetAdminUserInfo = (data) => {
  return axios.request({
    url: '/api/ac/sc/systemUserService/getById',
    data: data,
    method: 'post'
  })
}
/*
 系统管理-角色管理
 */
// 角色列表
export const getRoleList = (data) => {
  return axios.request({
    url: '/api/as/sc/role/getList',
    data: data,
    method: 'post'
  })
}
// 添加角色
export const saveRole = (data) => {
  return axios.request({
    url: '/api/ac/sc/roleService/save',
    data: data,
    method: 'post'
  })
}
// 刪除角色
export const deleteRole = (data) => {
  return axios.request({
    url: '/api/ac/sc/roleService/deleteRole',
    data: data,
    method: 'post'
  })
}
// 根据id获取信息
export const getRoleByID = (data) => {
  return axios.request({
    url: '/api/ac/sc/roleService/getById',
    data: data,
    method: 'post'
  })
}
export const userForRoleList = (data) => {
  return axios.request({
    url: '/api/as/sc/role/userForRoleList',
    data: data,
    method: 'post'
  })
}
export const getForRoleList = (data) => {
  return axios.request({
    url: '/api/as/sc/office/getForRoleList',
    data: data,
    method: 'post'
  })
}
export const getRoleUserList = (data) => {
  return axios.request({
    url: '/api/as/sc/role/getUserList',
    data: data,
    method: 'post'
  })
}
export const getOneList = (data) => {
  return axios.request({
    url: '/api/as/sc/menu/getOneList',
    data: data,
    method: 'post'
  })
}

export const getMenuForRoleList = (data) => {
  return axios.request({
    url: '/api/ac/sc/roleService/getMenuForRoleList',
    data: data,
    method: 'post'
  })
}

export const setAllotUser = (data) => {
  return axios.request({
    url: '/api/ac/sc/roleService/setAllotUser',
    data: data,
    method: 'post'
  })
}

export const setMenuForRole = (data) => {
  return axios.request({
    url: '/api/ac/sc/roleService/setMenuForRole',
    data: data,
    method: 'post'
  })
}
export const delUserFromRole = (data) => {
  return axios.request({
    url: '/api/as/sc/role/delUserFromRole',
    data: data,
    method: 'post'
  })
}

export const updatePwd = (data) => {
  return axios.request({
    url: '/api/ac/sc/systemUserService/updatePwd',
    data: data,
    method: 'post'
  })
}

export const setUserInfo = (data) => {
  return axios.request({
    url: '/api/ac/sc/systemUserService/setUserInfo',
    data: data,
    method: 'post'
  })
}
export const sysgetDictInfoList = (data) => {
  return axios.request({
    url: '/api/as/sc/dict/getDictInfoList?method=sys_center_method',
    data: data,
    method: 'get'
  })
}
export const sysisSync = (center_key, center_code) => {
  return axios.request({
    url: '/api/ac/sc/systemFunction/isSync',
    data: {
      center_key: center_key,
      center_code: center_code
    },
    method: 'get',
    await: true
  })
}

export const sysupdateSysFun = (data) => {
  return axios.request({
    url: '/api/ac/sc/systemFunction/updateSysFun',
    data: data,
    method: 'post',
    await: true
  })
}
/**
 * 获取当前传递角色绑定的所有菜单
 * @param data
 * @returns {Promise | Promise<unknown> | AxiosPromise}
 */
export const getRoleMenuList = (id) => {
  return axios.request({
    url: '/api/as/sc/role/getRoleMenuList',
    data: { role_id: id },
    method: 'get'
  })
}
/**
 * 获取当前登录用户所属机构的全部菜单
 * @param data
 * @returns {Promise | Promise<unknown> | AxiosPromise}
 */
export const getCompanyUserMenuList = (data) => {
  return axios.request({
    url: '/api/as/sc/menu/getCompanyUserMenuList',
    data: data,
    method: 'post'
  })
}
/**
 * 给角色添加对应的菜单
 * @param data
 * @returns {Promise | Promise<unknown>}
 */
export const setRoleMenu = (data) => {
  return axios.request({
    url: '/api/ac/sc/roleService/setRoleMenu',
    data: data,
    method: 'post'
  })
}
export const selectAreacode = (data) => {
  return axios.request({
    url: '/api/as/csc/auditelectronicareacode/selectAreacode',
    data: data,
    method: 'post'
  })
}
