import Mock from 'mockjs'
import { login, logout, getUserInfo } from './login'
import { getTableData, getDragList, uploadImage, getOrgData, getCityData, getTreeSelectData, getRouterData, getRouterXianData, getGridData } from './data'
import { getMessageInit, getContentByMsgId, hasRead, removeReaded, restoreTrash, messageCount } from './user'
import imList from './data/im-getList'
import imMembers from './data/im-getMembers'
import feveData from './data/fever-data'
// 配置Ajax请求延时，可用来测试网络延迟大时项目中一些效果
Mock.setup({
  timeout: 1000
})

// 登录相关和获取用户信息
Mock.mock(/\/login_NoUse/, login)
Mock.mock(/\/get_info/, getUserInfo)
Mock.mock(/\/logout/, logout)
Mock.mock(/\/get_table_data/, getTableData)
// Mock.mock(/\/get_router/, getRouterData)
// ---拦截菜单数据 修改下面的拦截接口 getVueMenuList
Mock.mock(RegExp('getVueMenuList'), 'get', (options) => {
  // 最佳实践，将请求和参数都打印出来，以便调试
  console.log(options)
  if (options.url.indexOf('ed53d565-5113-11e9-81b3-7cd30abda6a8') !== -1) {
    return Mock.mock(getRouterData)
  } else if (options.url.indexOf('bbadf140-506f-11e9-81b3-7cd30abda6a8') !== -1) {
    return Mock.mock(getRouterXianData)
  }
})

Mock.mock(/\/get_drag_list/, getDragList)
Mock.mock(/\/save_error_logger/, 'success')
Mock.mock(/\/image\/upload/, uploadImage)
Mock.mock(/\/message\/init/, getMessageInit)
Mock.mock(/\/message\/content/, getContentByMsgId)
Mock.mock(/\/message\/has_read/, hasRead)
Mock.mock(/\/message\/remove_readed/, removeReaded)
Mock.mock(/\/message\/restore/, restoreTrash)
Mock.mock(/\/message\/count/, messageCount)
Mock.mock(/\/get_org_data/, getOrgData)
Mock.mock(/\/get_city_data/, getCityData)
Mock.mock(/\/get_tree_select_data/, getTreeSelectData)
Mock.mock(/\/get_grid_data/, getGridData)

Mock.mock(/\/layim_getlist/, imList)
Mock.mock(/\/layim_getmembers/, imMembers)

Mock.mock(/\/feverList/, feveData)

export default Mock
