import Main from '@/components/main'
// import parentView from '@/components/parent-view'
import systemRouter from './group/system'
import systemNewRouter from './group/system-new'
import systemSetupRouter from './group/system-setup'
import contradictionRouter from './group/contradiction'
import murderManagement from './group/murder-management'
import homePage from './group/home-page'
import approvalRouter from './group/approval'
import keyPerson from './group/key-person'

/**
 * iview-admin中meta除了原生参数外可配置的参数:
 * meta: {
 *  title: { String|Number|Function }
 *         显示在侧边栏、面包屑和标签栏的文字
 *         使用'{{ 多语言字段 }}'形式结合多语言使用，例子看多语言的路由配置;
 *         可以传入一个回调函数，参数是当前路由对象，例子看动态路由和带参路由
 *  hideInBread: (false) 设为true后此级路由将不会出现在面包屑中，示例看QQ群路由配置
 *  hideInMenu: (false) 设为true后在左侧菜单不会显示该页面选项
 *  notCache: (false) 设为true后页面在切换标签后不会缓存，如果需要缓存，无需设置这个字段，而且需要设置页面组件name属性和路由配置的name一致
 *  access: (null) 可访问该页面的权限数组，当前路由设置的权限会影响子路由
 *  icon: (-) 该页面在左侧菜单、面包屑和标签导航处显示的图标，如果是自定义图标，需要在图标名称前加下划线'_'
 *  beforeCloseName: (-) 设置该字段，则在关闭当前tab页时会去'@/router/before-close.js'里寻找该字段名对应的方法，作为关闭前的钩子函数
 * }
 */

const base = [
  {
    path: '/login',
    name: 'login',
    meta: {
      title: 'summary_login - 登录',
      hideInMenu: true
    },
    component: () => import('@/view/summary_login/login.vue')
  },
  {
    path: '/all_home_page',
    name: 'allHomePage',
    meta: {
      icon: 'md-funnel',
      title: '平台首页'
    },
    component: () => import('@/view/contradiction/allHomePage.vue'),
    children: [
    ]
  },
  {
    path: '/indexv3',
    name: 'indexv3',
    redirect: '/indexv3',
    meta: {
      title: '首页v3',
      hideInMenu: true,
      hide: false,
      hideInBread: false
    },
    component: () => import('@/view/view-page/indexv3/index-copy.vue'),
    children: [
      {
        path: '/mainv3',
        name: 'mainv3',
        meta: {
          title: '首页',
          icon: 'md-home',
          notCache: true,
          hide: true
        },
        component: () => import('@/view/view-page/mainv3/index.vue')
      }
    ]
  },
  {
    path: '/analyzeRouter',
    name: 'analyzeRouter',
    meta: {
      hideInMenu: true,
      title: '分析研判路由页'
    },
    component: () => import('@/view/analyzeRouter.vue')
  },
  {
    path: '/',
    name: '_all_home_page',
    redirect: '/all_home_page',
    component: Main,
    meta: {
      hideInMenu: true,
      notCache: true
    },
    children: [
      {
        path: '/all-home-page',
        name: 'all-home-page',
        meta: {
          hideInMenu: true,
          title: '首页',
          notCache: true,
          icon: 'md-home'
        },
        component: () => import('@/view/contradiction/allHomePage.vue')
      }
    ]
  },
  {
    path: '',
    name: 'doc',
    meta: {
      title: '文档',
      href: 'https://lison16.github.io/iview-admin-doc/#/',
      icon: 'ios-book'
    }
  },
  {
    path: '/join',
    name: 'join',
    component: Main,
    meta: {
      hideInBread: true
    },
    children: [
      {
        path: 'join_page',
        name: 'join_page',
        meta: {
          icon: '_qq',
          title: 'QQ群222'
        },
        component: () => import('@/view/join-page.vue')
      }
    ]
  },
  {
    path: '/components',
    name: 'components',
    meta: {
      icon: 'logo-buffer',
      title: '组件'
    },
    component: Main,
    children: [
      {
        path: 'count_to_page',
        name: 'count_to_page',
        meta: {
          icon: 'md-trending-up',
          title: '数字渐变'
        },
        component: () => import('@/view/components/count-to/count-to.vue')
      },
      {
        path: 'split_pane_page',
        name: 'split_pane_page',
        meta: {
          icon: 'md-pause',
          title: '分割窗口'
        },
        component: () => import('@/view/components/split-pane/split-pane.vue')
      },
      // {
      //   path: 'markdown_page',
      //   name: 'markdown_page',
      //   meta: {
      //     icon: 'logo-markdown',
      //     title: 'Markdown编辑器'
      //   },
      //   component: () => import('@/view/components/markdown/markdown.vue')
      // },
      {
        path: 'editor_page',
        name: 'editor_page',
        meta: {
          icon: 'ios-create',
          title: '富文本编辑器'
        },
        component: () => import('@/view/components/editor/editor.vue')
      },
      {
        path: 'icons_page',
        name: 'icons_page',
        meta: {
          icon: '_bear',
          title: '自定义图标'
        },
        component: () => import('@/view/components/icons/icons.vue')
      }
    ]
  },
  {
    path: '/tools_methods',
    name: 'tools_methods',
    meta: {
      hideInBread: true
    },
    component: Main,
    children: [
      {
        path: 'tools_methods_page',
        name: 'tools_methods_page',
        meta: {
          icon: 'ios-hammer',
          title: '工具方法',
          beforeCloseName: 'before_close_normal'
        },
        component: () => import('@/view/tools-methods/tools-methods.vue')
      }
    ]
  },
  {
    path: '/error_store',
    name: 'error_store',
    meta: {
      hideInBread: true
    },
    component: Main,
    children: [
    ]
  },
  {
    path: '/error_logger',
    name: 'error_logger',
    meta: {
      hideInBread: true,
      hideInMenu: true
    },
    component: Main,
    children: [
    ]
  },
  {
    path: '/directive',
    name: 'directive',
    meta: {
      hideInBread: true
    },
    component: Main,
    children: [
      {
        path: 'directive_page',
        name: 'directive_page',
        meta: {
          icon: 'ios-navigate',
          title: '指令'
        },
        component: () => import('@/view/directive/directive.vue')
      }
    ]
  },
  {
    path: '/multilevel',
    name: 'multilevel',
    meta: {
      icon: 'md-menu',
      title: '多级菜单'
    },
    component: Main,
    children: [
    ]
  },
  {
    path: '/argu',
    name: 'argu',
    meta: {
      hideInMenu: true
    },
    component: Main,
    children: [
      {
        path: 'params/:id',
        name: 'params',
        meta: {
          icon: 'md-flower',
          title: route => `{{ params }}-${route.params.id}`,
          notCache: true,
          beforeCloseName: 'before_close_normal'
        },
        component: () => import('@/view/argu-page/params.vue')
      },
      {
        path: 'query',
        name: 'query',
        meta: {
          icon: 'md-flower',
          title: route => `{{ query }}-${route.query.id}`,
          notCache: true
        },
        component: () => import('@/view/argu-page/query.vue')
      }
    ]
  },
  {
    path: '/401',
    name: 'error_401',
    meta: {
      hideInMenu: true
    },
    component: () => import('@/view/error-page/401.vue')
  },
  {
    path: '/500',
    name: 'error_500',
    meta: {
      hideInMenu: true
    },
    component: () => import('@/view/error-page/500.vue')
  },
  {
    path: '*',
    name: 'error_404',
    meta: {
      hideInMenu: true
    },
    component: () => import('@/view/error-page/404.vue')
  },
  {
    path: '/hdpage',
    name: 'hdpage',
    component: Main,
    meta: {
      hideInBread: true
    },
    children: [
    ]
  },
  {
    path: '/xianpage',
    name: 'xianpage',
    component: Main,
    meta: {
      hideInBread: true
    },
    children: [
    ]
  },
  {
    path: '/weihu',
    name: 'weihu',
    meta: {
      title: '维护中',
      hideInMenu: true
    },
    component: () => import('@/view/weihu/index.vue')
  }
]
base[2].children.push.apply(base[2].children, systemRouter)
base[2].children.push.apply(base[2].children, systemNewRouter)
base[2].children.push.apply(base[2].children, systemSetupRouter)
base[2].children.push.apply(base[2].children, contradictionRouter)
base[2].children.push.apply(base[2].children, murderManagement)
base[2].children.push.apply(base[2].children, homePage)
base[2].children.push.apply(base[2].children, approvalRouter)
base[2].children.push.apply(base[2].children, keyPerson)
export default base
