import axios from '@/libs/api.request'

// 申领列表（包含历史与查询）
export const getBorrowList = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmBorrow/selectList',
    method: 'post',
    data: param
  })
}

// 待审核列表
export const getPendingBorrowList = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmBorrow/selectPendingList',
    method: 'post',
    data: param
  })
}

// 获取历史列表
export const getHistoryBorrowList = (param) => {
  return axios.request({
    url: '/api/keyDmBorrow/selectHistoryList',
    method: 'post',
    data: param
  })
}

// 保存申请（含明细）
export const saveBorrowApplication = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmBorrow/save',
    method: 'post',
    data: param
  })
}

// 提交
export const submitBorrow = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmBorrow/submit',
    method: 'post',
    data: param
  })
}

// 撤回
export const revokeBorrow = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmBorrow/revoke',
    method: 'post',
    data: param
  })
}

// 审批通过（内部生成出库、更新库存）
export const approveBorrow = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmBorrow/approve',
    method: 'post',
    data: param
  })
}

// 驳回
export const rejectBorrow = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmBorrow/reject',
    method: 'post',
    data: param
  })
}

// 查询申请及明细/日志
export const getBorrowById = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmBorrow/getById',
    method: 'post',
    data: param
  })
}
