import axios from '@/libs/api.request'

// ===== 人员权限配置 =====
export const getPermissionConfigList = () => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUserCategory/selectPermissionConfigList',
    method: 'post'
  })
}

export const savePermissionUsers = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUserCategory/savePermissionUsers',
    method: 'post',
    data: param
  })
}

// ===== 请假类型管理 =====
export const getLeaveTypeList = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUserCategory/selectLeaveTypeList',
    method: 'post',
    data: param
  })
}

export const saveLeaveType = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUserCategory/saveLeaveType',
    method: 'post',
    data: param
  })
}

export const deleteLeaveType = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUserCategory/deleteLeaveType',
    method: 'post',
    data: param
  })
}

export const findLeaveTypeList = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUserCategory/findLeaveTypeList',
    method: 'post',
    data: param
  })
}

// ===== 办公用品分类管理 =====
export const getMaterialCategoryList = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUserCategory/selectMaterialCategoryList',
    method: 'post',
    data: param
  })
}

export const saveMaterialCategory = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUserCategory/saveMaterialCategory',
    method: 'post',
    data: param
  })
}

export const deleteMaterialCategory = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUserCategory/deleteMaterialCategory',
    method: 'post',
    data: param
  })
}

export const findMaterialCategoryList = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUserCategory/findMaterialCategoryList',
    method: 'post',
    data: param
  })
}

// ===== 办公用品管理 =====
export const getMaterialList = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUserCategory/selectMaterialList',
    method: 'post',
    data: param
  })
}

export const saveMaterial = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUserCategory/saveMaterial',
    method: 'post',
    data: param
  })
}

export const deleteMaterial = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUserCategory/deleteMaterial',
    method: 'post',
    data: param
  })
}

// 导入物料（Excel）
export const importMaterial = (formData) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUserCategory/importMaterial',
    method: 'post',
    data: formData
  })
}

// 下载物料导入模板
export const materialTemplateDownload = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUserCategory/templateDownload',
    method: 'post',
    data: param
  })
}

// --统计部分---------------------------------------------------------------------------------------------
// 使用统计
export const getUsageStats = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmStats/selectUsageStats',
    method: 'post',
    data: param
  })
}

export const getUsageDetails = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmStats/selectUsageDetails',
    method: 'post',
    data: param
  })
}

// 工作量统计
export const getWorkloadStats = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmStats/selectWorkloadStats',
    method: 'post',
    data: param
  })
}

export const getWorkloadDetails = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmStats/selectWorkloadDetails',
    method: 'post',
    data: param
  })
}
