import axios from '@/libs/api.request'

/**
 * 获取审批列表
 * @param {Object} params
 * @param {string} params.approve_type - 申请类型（0：申请延期，1：申请不回访，2：申请为办结，3：申请退回）
 * @param {string} params.data_type - 数据类型（1：我的申请，2：我的审批）
 * @param {number} params.pageNo - 页码
 * @param {number} params.pageSize - 每页条数
 */
export const getEventApproveList = (params) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/EventApproveServiceImpl/eventApproveList',
    method: 'get',
    params
  })
}

/**
 * 提交申请
 * @param {Object} data
 * @param {string} data.event_id - 事件ID
 * @param {string} data.approve_type - 申请类型（0：申请延期，1：申请不回访，2：申请未办结，3：申请退回）
 * @param {string} data.approve_desc - 申请原因
 * @param {string} data.approve_days - 申请延期天数（可选）
 */
export const insertEventApprove = (data) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/EventApproveServiceImpl/insertEventApprove',
    method: 'post',
    data
  })
}

/**
 * 提交审批
 * @param {Object} data
 * @param {string} data.id - 审批ID
 * @param {string} data.deal_result - 审批结果（1：审批通过，2：审批不通过）
 * @param {string} data.deal_desc - 处理结果描述
 */
export const updateEventApprove = (data) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/EventApproveServiceImpl/updateEventApprove',
    method: 'post',
    data
  })
}

/**
 * 撤回申请
 * @param {string} approveId - 审批ID
 */
export const cancelApproval = (approveId) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/EventApproveServiceImpl/cancelApproval',
    method: 'post',
    data: { approveId }
  })
}
