import axios from '@/libs/api.request'

// 时间转换为日期-> 2019-02-02
export function date2str (date, containtime) {
  if (!date || typeof date === 'string') {
    return date
  }
  var time1 = date.getFullYear()
  var month = date.getMonth() + 1
  var day = date.getDate()
  time1 += '-' + (month < 10 ? '0' + month : month)
  time1 += '-' + (day < 10 ? '0' + day : day)
  return time1
}
// 生成uuid
export function getUuid () {
  var s = []
  var hexDigits = '0123456789abcdef'
  for (var i = 0; i < 36; i++) {
    s[i] = hexDigits.substr(Math.floor(Math.random() * 0x10), 1)
  }
  s[14] = '4' // bits 12-15 of the time_hi_and_version field to 0010
  s[19] = hexDigits.substr((s[19] & 0x3) | 0x8, 1) // bits 6-7 of the clock_seq_hi_and_reserved to 01
  s[8] = s[13] = s[18] = s[23] = '-'
  var uuid = s.join('')
  return uuid
}
export function date3str (t, date) {
  var date2 = new Date(date)
  var o = {
    'M+': date2.getMonth() + 1,
    'd+': date2.getDate(),
    'h+': date2.getHours(),
    'm+': date2.getMinutes(),
    's+': date2.getSeconds(),
    'q+': Math.floor((date2.getMonth() + 3) / 3),
    'S': date2.getMilliseconds()
  }
  if (/(y+)/.test(t)) {
    t = t.replace(RegExp.$1, (date2.getFullYear() + '').substr(4 - RegExp.$1.length))
  }
  for (var k in o) {
    if (new RegExp('(' + k + ')').test(t)) {
      t = t.replace(RegExp.$1, (RegExp.$1.length === 1) ? (o[k]) : (('00' + o[k]).substr(('' + o[k]).length)))
    }
  }
  return t
}
export function date0str1 (date, containtime) {
  if (!date || typeof date === 'string') {
    return date
  }
  var time1 = date.getFullYear()
  var month = date.getMonth() + 1
  var day = date.getDate()
  var hour = date.getHours()
  var min = date.getMinutes()
  // var second = date.getSeconds()
  time1 += '-' + (month < 10 ? '0' + month : month)
  time1 += '-' + (day < 10 ? '0' + day : day)
  time1 += ' ' + (hour < 10 ? '0' + hour : hour)
  time1 += ':' + (min < 10 ? '0' + min : min)
  // time1 += ':' + (second < 10 ? '0' + second : second)
  return time1
}
export function date0str (date, containtime) {
  if (!date || typeof date === 'string') {
    return date
  }
  var time1 = date.getFullYear()
  var month = date.getMonth() + 1
  var day = date.getDate()
  var hour = date.getHours()
  var min = date.getMinutes()
  time1 += '-' + (month < 10 ? '0' + month : month)
  time1 += '-' + (day < 10 ? '0' + day : day)
  time1 += ' ' + (hour < 10 ? '0' + hour : hour)
  time1 += ':' + (min < 10 ? '0' + min : min)
  return time1
}

// 时间转字符串 年月日时分秒
export function datetime2str (date, containtime) {
  if (!date || typeof date === 'string') {
    return date
  }
  let time1 = date.getFullYear() + '-'
  let month = date.getMonth() + 1
  let day = date.getDate()
  let hh = date.getHours()
  let mm = date.getMinutes()
  let ss = date.getSeconds()
  time1 += month < 10 ? '0' + month + '-' : month + '-'
  time1 += day < 10 ? '0' + day + ' ' : day + ' '
  time1 += hh < 10 ? '0' + hh + ':' : hh + ':'
  time1 += mm < 10 ? '0' + mm + ':' : mm + ':'
  time1 += ss < 10 ? '0' + ss : ss
  return time1
}
// 电子证照获取图片
export const getImgInfoForDz = (param) => {
  return axios.request({
    url: 'http://10.40.20.4:8081/api/uc/mzsc/uploadService/getImgInfo',
    method: 'post',
    data: param
  })
}
// 可办理的事项列表
export const eventlist = (param) => {
  return axios.request({
    url: '/api/as/csc/audititem/list',
    method: 'post',
    data: param
  })
}
// 可办理的事项列表
export const eventlistPC = (param) => {
  return axios.request({
    url: '/api/as/csc/audititem/pclist',
    method: 'post',
    data: param
  })
}
// 事项id获取事项详细信息
export const iteminf = (param) => {
  return axios.request({
    url: '/api/ac/csc/auditItemService/itemInfo',
    method: 'post',
    data: param
  })
}
// 获取医保跳转链接
export const yiBaoToken = (param) => {
  return axios.request({
    url: '/api/ac/csc/yiBaoWuMiService/createGetToken',
    method: 'post',
    data: param
  })
}
// 获取人社跳转链接
export const renSheToken = (param) => {
  return axios.request({
    url: '/api/ac/csc/renSheWuMiService/createGetToken',
    method: 'post',
    data: param
  })
}
// 获取特困跳转链接
export const teKunToken = (param) => {
  return axios.request({
    url: '/api/ac/csc/teKunWuMiService/createGetToken',
    method: 'post',
    data: param
  })
}
// 身份证号获取用户信息
export const userinfo = (cardno) => {
  return axios.request({
    // url: '/api/as/csc/user/getuserinfobycardno',
    // url: '/api/ac/csc/userRegisterService/desensitization',
    url: '/api/ac/grid/userRegisterForCSCService/desensitization',
    method: 'post',
    data: {
      'cardno': cardno
    }
  })
}
// 注册用户信息
export const createuser = (param) => {
  return axios.request({
    url: '/api/ac/csc/userRegisterService/createUser',
    method: 'post',
    data: param
  })
}
// 获取验证码
export const saveAndSendMsgCode = (param) => {
  return axios.request({
    url: '/api/ac/csc/userRegisterService/saveAndSendMsgCode',
    method: 'post',
    data: param
  })
}
// 更新用户头像
export const updatePhotoByCardno = (param) => {
  return axios.request({
    url: '/api/as/csc/user/updatePhotoByCardno',
    method: 'post',
    data: param
  })
}
// 订单流程
export const orderProcess = (param) => {
  return axios.request({
    url: '/api/as/csc/auditorder/getOrderProcessList',
    method: 'post',
    data: param
  })
}
// 事项订单列表
export const eventorderlist = (param) => {
  return axios.request({
    url: '/api/as/csc/auditorder/orderlist',
    method: 'post',
    data: param
  })
}
// 事项订单列表
export const weborderlist = (param) => {
  return axios.request({
    url: '/api/as/csc/auditorder/weborderlist',
    method: 'post',
    data: param
  })
}
// 事项订单列表
export const shamitemorderlist = (param) => {
  return axios.request({
    url: '/api/as/csc/auditshamitemorder/shamitemorderlist',
    method: 'post',
    data: param
  })
}
// 审批
export const saveShenpiInfo = (param) => {
  return axios.request({
    url: '/api/ac/csc/auditShamOrderService/saveShenpiInfo',
    method: 'post',
    data: param
  })
}
// 已下单事项的各步骤状态变更
export const setorderapply = (param) => {
  return axios.request({
    url: '/api/ac/csc/auditOrderService/setOrderApply',
    method: 'post',
    data: param
  })
}
// 查询页面所需初始下拉数据
export const getAppraising = (param) => {
  return axios.request({
    url: '/api/ac/csc/createPostService/getAppraising',
    method: 'post',
    data: param
  })
}
// 特困事项查询字典
export const getTKAppraising = (param) => {
  return axios.request({
    url: '/api/ac/csc/createPostService/getTKAppraising',
    method: 'post',
    data: param
  })
}
// 查询行政规划信息
export const getAdministrativePlanning = (param) => {
  return axios.request({
    url: '/api/ac/csc/createPostService/getAdministrativePlanning',
    method: 'post',
    data: param
  })
}
// 请求调用民政接口
export const createPostNew = (param) => {
  return axios.request({
    url: '/api/ac/csc/createPostService/createPostNew',
    method: 'post',
    data: param
  })
}
export const getIdcard = (param) => {
  return axios.request({
    url: '/api/ac/csc/createPostService/getIdcard',
    method: 'post',
    data: param
  })
}
export const findFamilyList = (param) => {
  return axios.request({
    url: '/api/ac/csc/createPostService/findFamilyList',
    method: 'post',
    data: param
  })
}
export const getBack = (param) => {
  return axios.request({
    url: '/api/ac/csc/createPostService/getBack',
    method: 'post',
    data: param
  })
}
// 统计每个类型的事项数量，用于tab标签页
export const tabcount = () => {
  return axios.request({
    url: '/api/as/csc/auditorder/getTabCountList',
    method: 'get'
  })
}
// 收受分离页面的事项数量，用于tab标签页
export const tabcounts = () => {
  return axios.request({
    url: '/api/as/csc/auditorder/getTabCountSList',
    method: 'get'
  })
}
// 查询收受分离事项列表
export const separateorder = (param) => {
  return axios.request({
    url: '/api/ac/csc/auditOrderService/getSeparateList',
    method: 'post',
    data: param
  })
}
// 临时方案，定时查询收受分离事项
export const getSeparateNotice = () => {
  return axios.request({
    url: '/api/as/csc/auditorder/getNoticeList',
    method: 'get'
  })
}
// 临时方案，用户点击提示框的关闭或者查看都表示已读
export const setSeparateNotice = (id) => {
  return axios.request({
    url: '/api/as/csc/auditorder/setFlowSee',
    method: 'post',
    data: { id: id }
  })
}
// 事项下单
export const createOrder = (param) => {
  return axios.request({
    url: '/api/ac/csc/auditOrderService/createOrder',
    method: 'post',
    data: param
  })
}
// 修改订单入参
export const updateOrder = (param) => {
  return axios.request({
    url: '/api/ac/csc/auditOrderService/updateOrder',
    method: 'post',
    data: param
  })
}
// 删除订单
export const deleteOrder = (param) => {
  return axios.request({
    url: '/api/ac/csc/auditOrderService/deleteOrder',
    method: 'post',
    data: { code: param }
  })
}

// 根据身份证获取用户的头像
export const getAaaa = (param) => {
  return axios.request({
    url: '/api/ac/csc/createPostService/save',
    method: 'post',
    data: param
  })
}
// 左侧的菜单，孩子模式
export const treelist = () => {
  return axios.request({
    url: '/api/ac/csc/auditItemService/treelist'
  })
}
// 通讯录
export const mailList = (data) => {
  return axios.request({
    data: data,
    url: '/api/as/csc/audititem/mailList',
    method: 'post'
  })
}
// 知识库列表
export const knowledgeList = (param) => {
  return axios.request({
    url: '/api/as/csc/auditorder/knowledgeList',
    method: 'post',
    data: param
  })
}
// 添加知识库内容
export const createKnowledge = (param) => {
  return axios.request({
    url: '/api/as/csc/auditorder/createKnowledge',
    method: 'post',
    data: param
  })
}
// 知识库详情
export const getKnowledgeInfo = (param) => {
  return axios.request({
    url: '/api/as/csc/auditorder/getKnowledgeInfo',
    method: 'post',
    data: param
  })
}
// 删除知识库
export const delKnowledge = (param) => {
  return axios.request({
    url: '/api/as/csc/auditorder/delKnowledge',
    method: 'post',
    data: param
  })
}
// 查询不同级别的通讯录列表
export const getMailLevelList = (param) => {
  return axios.request({
    url: '/api/as/csc/auditmail/getMailLevelList',
    method: 'post',
    data: param
  })
}
export const getMailLevelPageList = (param) => {
  return axios.request({
    url: '/api/as/csc/auditmail/getMailLevelPageList',
    method: 'post',
    data: param
  })
}
// 订单统计接口
export const getCompanyCountList = (param) => {
  return axios.request({
    url: '/api/ac/csc/auditOrderService/getCompanyCountList',
    method: 'post',
    data: param
  })
}
// 订单统计分页接口
export const getCompanyCountPageList = (param) => {
  return axios.request({
    url: '/api/ac/csc/auditOrderService/getCompanyCountPageList',
    method: 'post',
    data: param
  })
}
// 订单统计导出接口
export const getCompanyCountExcelList = (param) => {
  return axios.request({
    url: '/api/ac/csc/auditOrderService/getCompanyCountExcelList',
    method: 'post',
    data: param
  })
}
// 事项办理时限统计
export const getNewOrderAvgTimeList = (param) => {
  return axios.request({
    url: '/api/ac/csc/auditOrderService/getOrderAvgTimeList',
    method: 'post',
    data: param
  })
}
// 工作量统计接口
export const getWorkList = (param) => {
  return axios.request({
    url: '/api/ac/csc/auditOrderService/getWorkList',
    method: 'post',
    data: param
  })
}
// 工作量统计订单列表
export const findWorkOrderList = (param) => {
  return axios.request({
    url: '/api/as/csc/auditorder/findWorkOrderList',
    method: 'post',
    data: param
  })
}
// 工作量统计订单列表
export const find3rdLogList = (param) => {
  return axios.request({
    url: '/api/as/csc/cummunitylog/find3rdLogList',
    method: 'post',
    data: param
  })
}
// 工作量统计订单
export const find3rdLogExcelList = (param) => {
  return axios.request({
    url: '/api/as/csc/cummunitylog/find3rdLogExcelList',
    method: 'post',
    data: param
  })
}
// 修改反馈内容
export const updateFeedback = (param) => {
  return axios.request({
    url: '/api/as/csc/cummunitylog/updateFeedback',
    method: 'post',
    data: param
  })
}
// 工作量统计订单列表导出excel
export const findWorkOrderToExcelList = (param) => {
  return axios.request({
    url: '/api/as/csc/auditorder/findWorkOrderToExcelList',
    method: 'post',
    data: param
  })
}
// 事项统计列表
export const getPeriodList = (param) => {
  return axios.request({
    url: '/api/as/csc/auditorder/getPeriodList',
    method: 'post',
    data: param
  })
}
// 事项统计之后-每个事项的办理人员名单列表
export const getItemHandleList = (param) => {
  return axios.request({
    url: '/api/as/csc/auditorder/getItemHandleList',
    method: 'post',
    data: param
  })
}
// 事项统计之后-每个事项的办理人员名单列表
export const getItemHandleToExcelList = (param) => {
  return axios.request({
    url: '/api/as/csc/auditorder/getItemHandleToExcelList',
    method: 'post',
    data: param
  })
}
// 月度受理趋势图111
export const getMonthAcceptList = (param) => {
  return axios.request({
    url: '/api/as/csc/auditorder/getMonthAcceptList',
    method: 'post',
    data: param
  })
}
// 月周日度受趋势图
export const getAcceptList = (param) => {
  return axios.request({
    url: '/api/ac/csc/auditOrderService/getAcceptList',
    method: 'post',
    data: param
  })
}
// 获取电子证照图片
export const getDzzzImg = (param) => {
  return axios.request({
    url: '/api/ac/csc/auditOrderService/getDzzzImg',
    method: 'post',
    data: param
  })
}
// 获取电子证照图片
export const getPDFByOrderCode = (param) => {
  return axios.request({
    url: '/api/ac/csc/htmlPicService/setPDFByOrderCode',
    method: 'post',
    data: param
  })
}
// 事项id和订单编号获取事项的要件信息
export const itemParamByOrderList = (param) => {
  return axios.request({
    url: '/api/ac/csc/auditItemService/itemParamByOrderList',
    method: 'post',
    await: true,
    data: param
  })
}
// 通知公告列表
export const noticeList = (param) => {
  return axios.request({
    url: '/api/as/csc/auditnotice/noticeList',
    method: 'post',
    data: param
  })
}
// 保存通知公告
export const saveNotice = (param) => {
  return axios.request({
    url: '/api/ac/csc/noticeService/saveNotice',
    method: 'post',
    data: param
  })
}
// 通知公告发布和撤销
export const setReleaseState = (param) => {
  return axios.request({
    url: '/api/as/csc/auditnotice/setReleaseState',
    method: 'post',
    data: param
  })
}
// 重要公告和普通公告
export const setReleaseStress = (param) => {
  return axios.request({
    url: '/api/as/csc/auditnotice/setReleaseStress',
    method: 'post',
    data: param
  })
}
// 删除通知公告
export const deleteNotice = (param) => {
  return axios.request({
    url: '/api/ac/csc/noticeService/deleteNotice',
    method: 'post',
    data: param
  })
}
// 电子材料模块相关start
// 上传电子材料模板
export const addElectronicmaterialstemplate = (param) => {
  return axios.request({
    url: '/api/as/csc/electronicmaterialstemplate/addElectronicmaterialstemplate',
    method: 'post',
    data: param
  })
}
// 电子模板历史记录留存
export const addmaterialstemplatehistory = (param) => {
  return axios.request({
    url: '/api/as/csc/electronicmaterialstemplate/addmaterialstemplatehistory',
    method: 'post',
    data: param
  })
}

// 修改电子材料模板
export const updateElectronicmaterialstemplate = (param) => {
  return axios.request({
    url: '/api/as/csc/electronicmaterialstemplate/updateElectronicmaterialstemplate',
    method: 'post',
    data: param
  })
}
// 删除电子材料模板
export const deletematerialstemplate = (param) => {
  return axios.request({
    url: '/api/as/csc/electronicmaterialstemplate/deletematerialstemplate',
    method: 'post',
    data: param
  })
}

// 获取电子材料模板列表
export const loadelectronicmaterialstemplateList = (param) => {
  return axios.request({
    url: '/api/as/csc/electronicmaterialstemplate/loadelectronicmaterialstemplateList',
    method: 'post',
    data: param
  })
}
// 给电子模板添加标签
export const addLabel = (param) => {
  return axios.request({
    url: '/api/as/csc/label/addLabel',
    method: 'post',
    data: param
  })
}
// 获取标签列表
export const loadLabelList = (param) => {
  return axios.request({
    url: '/api/as/csc/label/loadLabelList',
    method: 'post',
    data: param
  })
}
// 修改标签
export const editLabel = (param) => {
  return axios.request({
    url: '/api/as/csc/label/editLabel',
    method: 'post',
    data: param
  })
}
// 删除标签
export const deletematerialsLabel = (param) => {
  return axios.request({
    url: '/api/as/csc/label/deletematerialsLabel',
    method: 'post',
    data: param
  })
}
// 增加电子材料编码
export const addCode = (param) => {
  return axios.request({
    url: '/api/as/csc/code/addCode',
    method: 'post',
    data: param
  })
}
// 修改材料编码
export const editCode = (param) => {
  return axios.request({
    url: '/api/as/csc/code/editCode',
    method: 'post',
    data: param
  })
}
// 删除材料编码
export const deletematerialsCode = (param) => {
  return axios.request({
    url: '/api/as/csc/code/deletematerialsCode',
    method: 'post',
    data: param
  })
}
// 获取电子材料编码列表
export const loadCodeList = (param) => {
  return axios.request({
    url: '/api/as/csc/code/loadCodeList',
    method: 'post',
    data: param
  })
}
// 获取电子材料列表
export const loadelectronicmaterialsList = (param) => {
  return axios.request({
    url: '/api/as/csc/electronicmaterials/loadelectronicmaterialsList',
    method: 'post',
    data: param
  })
}
// 增加电子材料
export const savematerials = (param) => {
  return axios.request({
    url: '/api/as/csc/electronicmaterials/savematerials',
    method: 'post',
    data: param
  })
}

// 查询电子模板历史数据
export const loadelectronicmaterialstemplatehistory = (param) => {
  return axios.request({
    url: '/api/as/csc/electronicmaterialstemplate/findelectronicmaterialstemplatehistoryList',
    method: 'post',
    data: param
  })
}

// 电子材料模块相关end
// 事项列表
export const itemList = (param) => {
  return axios.request({
    url: '/api/as/csc/audititemoption/itemList',
    method: 'post',
    data: param
  })
}
// 修改事项
export const saveItem = (param) => {
  return axios.request({
    url: '/api/ac/csc/ItemOptionService/saveItem',
    method: 'post',
    data: param
  })
}
// 客服获取提取码
export const createPostFeilID = (param) => {
  return axios.request({
    url: '/api/ac/csc/auditJyzDzzzService/createPostFeilID',
    method: 'post',
    data: param
  })
}
// 客服根据提取码获取照片
export const createPostImg = (param) => {
  return axios.request({
    url: '/api/ac/csc/auditJyzDzzzService/createPostImg',
    method: 'post',
    data: param
  })
}
// 废弃事项
export const delFeiqi = (param) => {
  return axios.request({
    url: '/api/as/csc/audititemoption/delFeiqi',
    method: 'post',
    data: param
  })
}
// 修改事项要件
export const updateItemDoc = (param) => {
  return axios.request({
    url: '/api/ac/csc/ItemOptionService/updateItemDoc',
    method: 'post',
    data: param
  })
}
// 社区列表
export const getUserByMZList = (param) => {
  return axios.request({
    url: '/api/as/sc/office/getUserByMZList',
    method: 'post',
    data: param
  })
}
// 二维码地址
export const getCodeUrl = (company_code, loginName) => {
  return axios.request({
    url: 'https://txy.sylyx.cn/Api/Api/getQrcode/wxid/123/code/mzj-' + company_code + '-' + loginName + '/type/on',
    params: {},
    method: 'get',
    php: true
  })
}
// 网格用户-树
export const grid = (param) => {
  return axios.request({
    url: '/api/as/csc/auditmail/uslist',
    method: 'get',
    data: param
  })
}
// 网格用户-楼单元层
export const auditmailfloor_getdownlist = (param) => {
  return axios.request({
    url: '/api/as/csc/auditmailfloor/getdownlist',
    method: 'post',
    data: param
  })
}
// 网格用户-商户
export const auditmailcompany_uslist = (param) => {
  return axios.request({
    url: '/api/as/csc/auditmailcompany/uslist',
    method: 'post',
    data: param
  })
}
// 网格用户-户信息
export const auditmailfloor_userlist = (param) => {
  return axios.request({
    url: '/api/as/csc/auditmailfloor/userlist',
    method: 'post',
    await: true,
    data: param
  })
}
// 网格用户-搜索
export const auditmailfloor_getuserlist = (param) => {
  return axios.request({
    url: '/api/as/csc/auditmailfloor/getuserlist',
    method: 'post',
    data: param
  })
}
// 网格用户-搜索详情
export const auditmailfloor_getuserinfo = (param) => {
  return axios.request({
    url: '/api/as/csc/auditmailfloor/getuserinfo',
    method: 'post',
    data: param
  })
}
// 网格用户-查询户数
export const auditmailfloor_gethousenum = (param) => {
  return axios.request({
    url: '/api/as/csc/auditmailfloor/gethousenum',
    method: 'post',
    await: true,
    data: param
  })
}
// 网格用户-查询户数（默认）--废弃
export const auditmailfloor_getone = (param) => {
  return axios.request({
    url: '/api/as/csc/auditmailfloor/getone',
    method: 'post',
    data: param
  })
}
// 网格用户-根据单元查户列表
export const auditmailfloor_userbyunitidlist = (param) => {
  return axios.request({
    url: '/api/as/csc/auditmailfloor/userbyunitidlist',
    method: 'post',
    data: param
  })
}
// 网格管理-树
export const grid_maintain = (param) => {
  return axios.request({
    url: '/api/as/csc/auditmail/list',
    method: 'get',
    data: param
  })
}
// 网格管理-下级列表-小组以上
export const grid_downlist = (param) => {
  return axios.request({
    url: '/api/as/csc/auditmail/downlist',
    method: 'post',
    data: param
  })
}
// 网格管理-下级列表-小组以下
export const grid_downlist_floor = (param) => {
  return axios.request({
    url: '/api/as/csc/auditmailfloor/downlist',
    method: 'post',
    data: param
  })
}
// 网格管理-层户查询
export const auditMailFloorService_layerList = (param) => {
  return axios.request({
    url: '/api/ac/csc/auditMailFloorService/layerList',
    method: 'post',
    data: param
  })
}
// 网格管理-创建-小组以上
export const grid_maintain_create = (param) => {
  return axios.request({
    url: '/api/as/csc/auditmail/create',
    method: 'post',
    data: param
  })
}
// 网格管理-删除-小组以上
export const auditMailFloorService_delete = (param) => {
  return axios.request({
    url: '/api/ac/csc/auditMailFloorService/delete',
    method: 'post',
    data: param
  })
}
// 网格管理-创建-小组以下
export const grid_maintain_create_floor = (param) => {
  return axios.request({
    url: '/api/ac/csc/auditMailFloorService/createFloor',
    method: 'post',
    data: param
  })
}
// 网格管理-创建-小组以下(层户)
export const grid_maintain_create_floor_ceng = (param) => {
  return axios.request({
    url: '/api/ac/csc/auditMailFloorService/create',
    method: 'post',
    data: param
  })
}
// 网格管理-创建企业
export const auditmailcompany_create = (param) => {
  return axios.request({
    url: '/api/as/csc/auditmailcompany/create',
    method: 'post',
    data: param
  })
}
// 网格管理-查询企业
export const auditmailcompany_list = (param) => {
  return axios.request({
    url: '/api/as/csc/auditmailcompany/list',
    method: 'post',
    data: param
  })
}
// 网格管理-添加修改层户
export const auditmailfloor_create = (param) => {
  return axios.request({
    url: '/api/as/csc/auditmailfloor/create',
    method: 'post',
    await: true,
    data: param
  })
}
// 网格管理-删除单元层户
export const auditmailfloor_updatedelfloor = (param) => {
  return axios.request({
    url: '/api/as/csc/auditmailfloor/updatedelfloor',
    method: 'post',
    data: param
  })
}
// 电子证照列表
export const visalist = (param) => {
  return axios.request({
    url: '/api/as/csc/auditelectronic/visalist',
    method: 'post',
    data: param
  })
}
// 更新电子证照列表
export const updateVisa = (param) => {
  return axios.request({
    url: '/api/as/csc/auditelectronic/updateVisa',
    method: 'post',
    data: param
  })
}
// 配置医保列表
export const yibaoList = (param) => {
  return axios.request({
    url: '/api/as/csc/auditelectronic/yibaoList',
    method: 'post',
    data: param
  })
}
// 配置医保列表
export const rensheList = (param) => {
  return axios.request({
    url: '/api/as/csc/auditelectronic/rensheList',
    method: 'post',
    data: param
  })
}
// 更新电子证照列表
export const updateYibao = (param) => {
  return axios.request({
    url: '/api/as/csc/auditelectronic/updateYibao',
    method: 'post',
    data: param
  })
}
// 更新人社列表
export const updateRenshe = (param) => {
  return axios.request({
    url: '/api/as/csc/auditelectronic/updateRenshe',
    method: 'post',
    data: param
  })
}
// 添加人社列表
export const insertRenshe = (param) => {
  return axios.request({
    url: '/api/as/csc/auditelectronic/insertRenshe',
    method: 'post',
    data: param
  })
}
// 配置房产租赁列表
export const fczhulinList = (param) => {
  return axios.request({
    url: '/api/as/csc/auditelectronic/fczhulinList',
    method: 'post',
    data: param
  })
}
// 更新房产租赁列表
export const updateFczhulin = (param) => {
  return axios.request({
    url: '/api/as/csc/auditelectronic/updateFczhulin',
    method: 'post',
    data: param
  })
}
// 事项更新列表
export const itemUpdateList = (param) => {
  return axios.request({
    url: '/api/as/csc/audititemoption/itemUpdateList',
    method: 'post',
    data: param
  })
}
// 事项更新列表
export const getItemUpdateInfo = (param) => {
  return axios.request({
    url: '/api/ac/csc/auditItemService/getItemUpdateInfo',
    method: 'post',
    data: param
  })
}
// 添加流程设置社区隐藏
export const saveProcessCannotSee = (param) => {
  return axios.request({
    url: '/api/as/csc/auditprocess/saveProcessCannotSee',
    method: 'post',
    data: param
  })
}
// 添加流程类型
export const insertProcessType = (param) => {
  return axios.request({
    url: '/api/as/csc/auditprocess/insertProcessType',
    method: 'post',
    data: param
  })
}
// 删除流程类型
export const deleteProcessType = (param) => {
  return axios.request({
    url: '/api/as/csc/auditprocess/deleteProcessType',
    method: 'post',
    data: param
  })
}
// 更新流程类型
export const updateProcessType = (param) => {
  return axios.request({
    url: '/api/as/csc/auditprocess/updateProcessType',
    method: 'post',
    data: param
  })
}
// 查看流程类型列表(分页)
export const findProcessTypeList = (param) => {
  return axios.request({
    url: '/api/as/csc/auditprocess/findProcessTypeList',
    method: 'post',
    data: param
  })
}
// 查看流程类型列表
export const findProcessTypeAllList = (param) => {
  return axios.request({
    url: '/api/as/csc/auditprocess/findProcessTypeAllList',
    method: 'post',
    data: param
  })
}
// 查看流程类型详情
export const getProcessTypeInfo = (param) => {
  return axios.request({
    url: '/api/as/csc/auditprocess/getProcessTypeInfo',
    method: 'post',
    data: param
  })
}
// 添加流程信息
export const insertProcessInfo = (param) => {
  return axios.request({
    url: '/api/as/csc/auditprocess/insertProcessInfo',
    method: 'post',
    data: param
  })
}
// 删除流程信息
export const deleteProcessInfo = (param) => {
  return axios.request({
    url: '/api/as/csc/auditprocess/deleteProcessInfo',
    method: 'post',
    data: param
  })
}
// 更新流程信息
export const updateProcessInfo = (param) => {
  return axios.request({
    url: '/api/as/csc/auditprocess/updateProcessInfo',
    method: 'post',
    data: param
  })
}
// 获取流程类型信息
export const findProcessInfoList = (param) => {
  return axios.request({
    url: '/api/as/csc/auditprocess/findProcessInfoList',
    method: 'post',
    data: param
  })
}
// 获取流程类型信息
export const findProcessInfoAllList = (param) => {
  return axios.request({
    url: '/api/as/csc/auditprocess/findProcessInfoAllList',
    method: 'post',
    data: param
  })
}
// 查看流程类型信息
export const getProcessInfoInfo = (param) => {
  return axios.request({
    url: '/api/as/csc/auditprocess/getProcessInfoInfo',
    method: 'post',
    data: param
  })
}
// 添加流程信息
export const insertProcess = (param) => {
  return axios.request({
    url: '/api/as/csc/auditprocess/insertProcess',
    method: 'post',
    data: param
  })
}
// 复制流程信息
export const copyProcess = (data) => {
  return axios.request({
    url: '/api/ac/csc/auditItemService/createCopyProcess',
    method: 'post',
    data: data
  })
}
// 删除流程信息
export const deleteProcess = (param) => {
  return axios.request({
    url: '/api/as/csc/auditprocess/deleteProcess',
    method: 'post',
    data: param
  })
}
// 更新流程信息
export const updateProcess = (param) => {
  return axios.request({
    url: '/api/as/csc/auditprocess/updateProcess',
    method: 'post',
    data: param
  })
}
// 获取流程类型信息
export const findProcessPageList = (param) => {
  return axios.request({
    url: '/api/as/csc/auditprocess/findProcessPageList',
    method: 'post',
    data: param
  })
}
// 获取订单流程列表
export const getKefuOrderProcessList = (param) => {
  return axios.request({
    url: '/api/as/csc/auditorder/getKefuOrderProcessList',
    method: 'post',
    data: param
  })
}
// 好差评添加人员
export const createHcpUser = (param) => {
  return axios.request({
    url: '/api/ac/csc/hcpevaluateUserinfoService/createUser',
    method: 'post',
    data: param
  })
}
// 获取好差评链接
export const createHcpUrl = (param) => {
  return axios.request({
    url: '/api/ac/csc/hcpevaluateUserinfoService/createUrl',
    method: 'post',
    data: param
  })
}
// 第三方订单重新推送
export const updateSendAgain = (param) => {
  return axios.request({
    url: '/api/as/csc/auditorder/updateSendAgain',
    method: 'post',
    data: param
  })
}
// 获取api列表
export const getAllApi = (param) => {
  return axios.request({
    url: '/api/ac/csc/cscGetApiService/getApiList',
    method: 'post',
    data: param
  })
}
// 查看流程类型信息
export const findProcessList = (param) => {
  return axios.request({
    url: '/api/as/csc/auditprocess/findProcessList',
    method: 'post',
    data: param
  })
}
// 查看流程组详细信息
export const findGroupProcessList = (param) => {
  return axios.request({
    url: '/api/as/csc/auditprocess/findGroupProcessList',
    method: 'post',
    data: param
  })
}
// 更新事项信息，包含更新要件
export const updateItem = (param) => {
  return axios.request({
    url: '/api/ac/csc/auditItemService/updateItem',
    method: 'post',
    data: param
  })
}
export const byRowidList = (param) => {
  return axios.request({
    url: '/api/as/csc/questionconsultation/byRowidList',
    method: 'post',
    data: param
  })
}
export const byQlnameInfo = (param) => {
  return axios.request({
    url: '/api/as/csc/questionconsultation/byQlnameInfoList',
    method: 'post',
    data: param
  })
}
export const findMMDLPullList = (param) => {
  return axios.request({
    url: '/api/as/csc/auditorderto3rd/findMMDLPullList',
    method: 'post',
    data: param
  })
}
export const updateCreateOrderState0 = (param) => {
  return axios.request({
    url: '/api/as/csc/auditorderto3rd/updateCreateOrderState0',
    method: 'post',
    data: param
  })
}
export const updateYibaoLoginnameNull = (param) => {
  return axios.request({
    url: '/api/as/csc/auditelectronic/updateYibaoLoginnameNull',
    method: 'post',
    data: param
  })
}

export const findStreetNum = (param) => {
  return axios.request({
    url: '/api/ac/csc/QuestionConsultationService/findStreetNum',
    method: 'post',
    data: param
  })
}
export const getSomeNum = (param) => {
  return axios.request({
    url: '/api/ac/csc/auditOrderService/getSomeNum',
    method: 'post',
    data: param
  })
}
export const findDatamailList = (param) => {
  return axios.request({
    url: '/api/as/csc/auditdockingdatamail/findDatamailList',
    method: 'post',
    data: param
  })
}
export const adddatamail = (param) => {
  return axios.request({
    url: '/api/as/csc/auditdockingdatamail/adddatamail',
    method: 'post',
    data: param
  })
}
export const findLoginList = (param) => {
  return axios.request({
    url: '/api/ac/csc/auditCustomerService/findLoginList',
    method: 'post',
    data: param
  })
}
export const updatedatamail = (param) => {
  return axios.request({
    url: '/api/as/csc/auditdockingdatamail/updatedatamail',
    method: 'post',
    data: param
  })
}

export const dycgetSomeNum = (param) => {
  return axios.request({
    url: 'http://124.95.133.242:33681/api/us/dyc/issuancestatistics/findSomeNumList',
    method: 'post',
    data: param
  })
}

export const getBuildingNum = (param) => {
  return axios.request({
    url: 'http://qstb.mzj.shenyang.gov.cn/api/us/grid/sysOfficeinfo/getGridTJ',
    method: 'post',
    data: param
  })
}
// 首页统计,最后一项网格数量
export const getGardenNum = (param) => {
  return axios.request({
    url: 'http://qstb.mzj.shenyang.gov.cn/api/us/grid/sysOfficeinfo/getGardenNum',
    method: 'post',
    data: param
  })
}
export const getIndexCount = (param) => {
  return axios.request({
    url: '/api/as/csc/auditorder/getIndexCount',
    method: 'post',
    data: param
  })
}
export const byCreatebyInfoList = (param) => {
  return axios.request({
    url: '/api/as/csc/questionconsultation/byCreatebyInfoList',
    method: 'post',
    data: param
  })
}
export const getAgentAppointInfo = (param) => {
  return axios.request({
    url: '/api/as/csc/auditagentappoint/getAgentAppointInfo',
    method: 'post',
    data: param
  })
}
export const findAgentAppointList = (param) => {
  return axios.request({
    url: '/api/as/csc/auditagentappoint/findAgentAppointList',
    method: 'post',
    data: param
  })
}
export const findDealableItem = (param) => {
  return axios.request({
    url: '/api/ac/csc/auditItemService/findDealableItem',
    method: 'post',
    data: param
  })
}
// 查低保详情接口
export const getAssistanceInfo = (param) => {
  return axios.request({
    url: '/api/ac/csc/createPostService/getAssistanceInfo',
    method: 'post',
    data: param
  })
}
// 查询是否是残疾人详情接口
export const findCanlian = (param) => {
  return axios.request({
    url: '/api/ac/dyc/streeAllServiceImpl/findCanlian',
    method: 'post',
    data: param
  })
}

// 查询户籍详情接口
export const getRegisterInfo = (param) => {
  return axios.request({
    url: '/api/ac/csc/auditRegisterService/getRegisterInfo',
    method: 'post',
    data: param
  })
}
// 查询工伤护理费详情接口
export const getOccupationalInfo = (param) => {
  return axios.request({
    url: '/api/ac/csc/disabliityCheckService/getOccupationalInfo',
    method: 'post',
    data: param
  })
}
// 查询是否办理过残疾人事项接口
export const getInfoByCard = (param) => {
  return axios.request({
    url: '/api/as/csc/ejdm/infoByCardList',
    method: 'post',
    data: param
  })
}
// 查询是否为孤儿
export const getOrphanByCard = (param) => {
  return axios.request({
    url: '/api/as/csc/ejdm/getOrphanByCard',
    method: 'post',
    data: param
  })
}
// 查询是否为特困人员
export const getDifficultyByCard = (param) => {
  return axios.request({
    url: '/api/as/csc/ejdm/getDifficultyByCard',
    method: 'post',
    data: param
  })
}
// 查询殡葬详情接口
export const getFuneralInfo = (param) => {
  return axios.request({
    url: '/api/ac/dyc/abutmentService/getFuneralInfo',
    method: 'post',
    data: param
  })
}
// 查询社区编码接口
export const communityInfo = (param) => {
  return axios.request({
    url: '/api/as/csc/houseinfo/communityInfo',
    method: 'post',
    data: param
  })
}
// 获取户籍地区县code接口
export const getSQCodeFc = (param) => {
  return axios.request({
    url: '/api/as/csc/auditorderother/getSQCodeFc ',
    method: 'post',
    data: param
  })
}
// 获取户籍地区县街道社区地址接口
export const getSQCode = (param) => {
  return axios.request({
    url: '/api/as/csc/auditorderother/getSQCode ',
    method: 'post',
    data: param
  })
}
// 数据字典
export const codeList = (param) => {
  return axios.request({
    url: '/api/us/csc/ejdm/codeList',
    method: 'post',
    data: param
  })
}
// 树形数据
export const getCompanyMenuList = (param) => {
  return axios.request({
    url: '/api/ac/sc/menuService/getCompanyMenuList',
    method: 'post',
    data: param
  })
}
// 全市通办房产租赁事项
export const createFangChanLogin = (param) => {
  return axios.request({
    url: '/api/ac/csc/fangChanZuLinWuMiService/createFangChanLogin',
    method: 'post',
    data: param
  })
}
// 新上传图片地址
export const createUpLoadFiles = (param) => {
  return axios.request({
    url: '/api/ac/csc/auditHadoopUploadFilesService/createUpLoadFiles',
    method: 'post',
    data: param
  })
}
// 殡葬残疾信息
export const createDisabilityApi = (param) => {
  return axios.request({
    url: '/api/ac/csc/createDisabilityOrderService/createDisabilityApi',
    method: 'post',
    data: param
  })
}
// 时限统计
export const getOrderAvgTimeList = (param) => {
  return axios.request({
    url: '/api/as/csc/auditorder/getOrderAvgTimeList',
    method: 'post',
    data: param
  })
}
export const deleteOrderAndSaveLog = (param) => {
  return axios.request({
    url: '/api/ac/csc/auditOrderService/deleteOrderAndSaveLog',
    method: 'post',
    data: param
  })
}
export const getTKAttachmentConfigsk = (param) => {
  return axios.request({
    url: '/api/ac/csc/createPostService/getTKAttachmentConfigsk',
    method: 'post',
    data: param
  })
}
export const createcopyOrderInfo = (param) => {
  return axios.request({
    url: '/api/ac/csc/auditOrderService/createcopyOrderInfo',
    method: 'post',
    data: param
  })
}
// 办理事项列表（分页接口)
export const getPeriodOneList = (param) => {
  return axios.request({
    url: '/api/as/csc/auditorder/getPeriodOneList',
    method: 'post',
    data: param
  })
}
// 导出办理事项列表
export const getPeriodToExcelList = (param) => {
  return axios.request({
    url: '/api/as/csc/auditorder/getPeriodToExcelList',
    method: 'post',
    data: param
  })
}
// 保存社区人口数量
export const savePopulationNum = (param) => {
  return axios.request({
    url: '/api/ac/csc/autoPopulationNumService/save',
    method: 'post',
    data: param
  })
}
// 获取社区人口信息
export const getPopulationNum = (param) => {
  return axios.request({
    url: '/api/as/csc/auditpopulationnum/getPopulationNum',
    method: 'post',
    data: param
  })
}
// 获取社区人口信息变更记录
export const findPopulationNumLogList = (param) => {
  return axios.request({
    url: '/api/as/csc/auditpopulationnum/findPopulationNumLogList',
    method: 'post',
    data: param
  })
}
export const createCopyFiles = (param) => {
  return axios.request({
    url: '/api/ac/csc/auditHadoopUploadFilesService/createCopyFiles',
    method: 'post',
    data: param
  })
}
export const getDepositInfo = (param) => {
  return axios.request({
    url: '/api/ac/csc/auditJyzDzzzService/updateDepositInfo',
    method: 'post',
    data: param
  })
}
// 办结率
export const getForwardRateList = (param) => {
  return axios.request({
    url: '/api/as/csc/auditorder/getForwardRateList',
    method: 'post',
    data: param
  })
}
export const getOrderByCode = (param) => {
  return axios.request({
    url: '/api/as/csc/auditorder/getOrderByCode',
    method: 'post',
    data: param
  })
}
// 客服查询订单信息
export const getOrderInfoBycodeForKefu = (param) => {
  return axios.request({
    url: '/api/ac/csc/auditOrderService/getOrderInfoBycodeForKefu',
    method: 'post',
    data: param
  })
}
// 获取用户列表
export const findUserList = (param) => {
  return axios.request({
    url: '/api/ac/csc/userRegisterService/findUserList',
    method: 'post',
    data: param
  })
}
// 字典表接口
export const getDictList = (data) => {
  return axios.request({
    url: '/api/as/sc/dict/getDictList',
    method: 'post',
    data: data
  })
}
// 要件沉淀信息列表
export const findDocumentDepositList = (param) => {
  return axios.request({
    url: '/api/as/csc/auditDocumentDeposit/findDepositInfoList',
    method: 'post',
    data: param
  })
}
// 删除沉淀信息
export const deleteDocument = (param) => {
  return axios.request({
    url: '/api/as/csc/auditDocumentDeposit/deleteDocument',
    method: 'post',
    data: param
  })
}
// 修改沉淀信息
export const updateDocument = (param) => {
  return axios.request({
    url: '/api/as/csc/auditDocumentDeposit/updateDocument',
    method: 'post',
    data: param
  })
}
export const findItemList = (param) => {
  return axios.request({
    url: '/api/as/csc/questionconsultation/findItemList',
    method: 'post',
    data: param
  })
}
export const findGuestionConsultationMyList = (param) => {
  return axios.request({
    url: '/api/as/csc/questionconsultation/findGuestionConsultationMyList',
    method: 'post',
    data: param
  })
}
export const createQuestionConsultation = (param) => {
  return axios.request({
    url: '/api/as/csc/questionconsultation/createQuestionConsultation',
    method: 'post',
    data: param
  })
}
export const byIdInfo = (param) => {
  return axios.request({
    url: '/api/as/csc/questionconsultation/byIdInfo',
    method: 'post',
    data: param
  })
}
export const updateInfoById = (param) => {
  return axios.request({
    url: '/api/as/csc/questionconsultation/updateInfoById',
    method: 'post',
    data: param
  })
}
// 创建问卷模板
export const saveWenjuan = (data) => {
  return axios.request({
    url: '/api/ac/cscsst/ywtgWenjuanService/saveWenjuan',
    method: 'post',
    data: data
  })
}
// 创建问卷
export const saveWenjuanUse = (data) => {
  return axios.request({
    url: '/api/ac/cscsst/ywtgWenjuanService/saveWenjuanUse',
    method: 'post',
    data: data
  })
}
// 创建问卷
export const deleteUse = (data) => {
  return axios.request({
    url: '/api/ac/cscsst/ywtgWenjuanService/deleteUse',
    method: 'post',
    data: data
  })
}
// 创建问卷
export const updateUseState2 = (data) => {
  return axios.request({
    url: '/api/ac/cscsst/ywtgWenjuanService/updateUseState2',
    method: 'post',
    data: data
  })
}
// 创建问卷
export const updateUseState1 = (data) => {
  return axios.request({
    url: '/api/ac/cscsst/ywtgWenjuanService/updateUseState1',
    method: 'post',
    data: data
  })
}
// 删除问卷模板
export const deleteWenjuan = (data) => {
  return axios.request({
    url: '/api/ac/cscsst/ywtgWenjuanService/deleteWenjuan',
    method: 'post',
    data: data
  })
}
// 获取问卷模板列表
export const findWenjuanList = (data) => {
  return axios.request({
    url: '/api/ac/cscsst/ywtgWenjuanService/findWenjuanList',
    method: 'post',
    data: data
  })
}
// 获取问卷下拉框模板列表
export const findWenjuanAllList = (data) => {
  return axios.request({
    url: '/api/ac/cscsst/ywtgWenjuanService/findWenjuanAllList',
    method: 'post',
    data: data
  })
}
// 获取问卷列表
export const findUseWenjuanList = (data) => {
  return axios.request({
    url: '/api/ac/cscsst/ywtgWenjuanService/findUseWenjuanList',
    method: 'post',
    data: data
  })
}
// 获取问卷列表
export const getPerson = (data) => {
  return axios.request({
    url: '/api/ac/cscsst/ywtgWenjuanService/getPerson',
    method: 'post',
    data: data
  })
}
// 排队列表
export const auditlineup = (data) => {
  return axios.request({
    url: '/api/as/csc/auditlineup/findLineUpPageList',
    method: 'post',
    data: data
  })
}
// 获取当前号序
export const getNowLineNoByloginName = (data) => {
  return axios.request({
    url: '/api/as/csc/auditlineup/getNowLineNoByloginName',
    method: 'post',
    data: data
  })
}
// 完成并暂停
export const updateEnd = (data) => {
  return axios.request({
    url: '/api/ac/csc/lineUpService/updateEnd',
    method: 'post',
    data: data
  })
}
// 排队列表
export const updateNext = (data) => {
  return axios.request({
    url: '/api/ac/csc/lineUpService/updateNext',
    method: 'post',
    data: data
  })
}
// 排队列表
export const updateOne = (data) => {
  return axios.request({
    url: '/api/ac/csc/lineUpService/updateOne',
    method: 'post',
    data: data
  })
}
export const update5 = (data) => {
  return axios.request({
    url: '/api/ac/csc/lineUpService/update5',
    method: 'post',
    data: data
  })
}
export const updateIsCall = (data) => {
  return axios.request({
    url: '/api/as/csc/auditlineup/updateIsCall',
    method: 'post',
    data: data
  })
}
// 添加号段
export const createLinenum = (data) => {
  return axios.request({
    url: '/api/ac/csc/lineUpService/createLinenum',
    method: 'post',
    data: data
  })
}
// 添加号段
export const findLinenumList = (data) => {
  return axios.request({
    url: '/api/as/csc/auditlineup/findLinenumList',
    method: 'post',
    data: data
  })
}
// 添加号段
export const deleteLinenum = (data) => {
  return axios.request({
    url: '/api/ac/csc/lineUpService/deleteLinenum',
    method: 'post',
    data: data
  })
}
// 添加号段
export const updateLinenum = (data) => {
  return axios.request({
    url: '/api/as/csc/auditlineup/updateLinenum',
    method: 'post',
    data: data
  })
}
// 无密登录log列表
export const findLogAmlList = (data) => {
  return axios.request({
    url: '/api/as/csc/auditwumilog/findLogAmlList',
    method: 'post',
    data: data
  })
}
// 保存免密登录log
export const createWumiLog = (data) => {
  return axios.request({
    url: '/api/as/csc/auditwumilog/createWumiLog',
    method: 'post',
    data: data
  })
}
// 获取首页弹出html
export const findHtmlList = (data) => {
  return axios.request({
    url: '/api/as/csc/auditshowhtml/findHtmlList',
    method: 'post',
    data: data
  })
}
// 获取首页弹出html
export const getHtml1 = (data) => {
  return axios.request({
    url: '/api/as/csc/auditshowhtml/getHtml1',
    method: 'post',
    data: data
  })
}
export const sendReminders = (data) => {
  return axios.request({
    url: '/api/ac/csc/expectedremindersservice/updateAndSendReminders',
    method: 'post',
    data: data
  })
}
export const overtimeOrderList = (data) => {
  return axios.request({
    url: '/api/as/csc/expectedreminders/overtimeOrderList',
    method: 'post',
    data: data
  })
}
export const getPositionUserList = (data) => {
  return axios.request({
    url: '/api/as/csc/positionuserlist/getPositionUserList',
    method: 'post',
    data: data
  })
}
export const addPositionUser = (data) => {
  return axios.request({
    url: '/api/as/csc/positionuserlist/addPositionUser',
    method: 'post',
    data: data
  })
}
export const deletePositionUser = (data) => {
  return axios.request({
    url: '/api/as/csc/positionuserlist/deletePositionUser',
    method: 'post',
    data: data
  })
}
export const updatePositionUser = (data) => {
  return axios.request({
    url: '/api/as/csc/positionuserlist/updatePositionUser',
    method: 'post',
    data: data
  })
}
export const getItemBindUserList = (data) => {
  return axios.request({
    url: '/api/as/csc/audititembind/getItemBindUserList',
    method: 'post',
    data: data
  })
}
export const addItemBindUser = (data) => {
  return axios.request({
    url: '/api/as/csc/audititembind/addItemBindUser',
    method: 'post',
    data: data
  })
}
export const getPositionUserAllList = (data) => {
  return axios.request({
    url: '/api/as/csc/positionuserlist/getPositionUserAllList',
    method: 'post',
    data: data
  })
}
export const deleteItemBindUser = (data) => {
  return axios.request({
    url: '/api/as/csc/audititembind/deleteItemBindUser',
    method: 'post',
    data: data
  })
}
export const updateItemBindUser = (data) => {
  return axios.request({
    url: '/api/as/csc/audititembind/updateItemBindUser',
    method: 'post',
    data: data
  })
}
export const getComplaintHandleList = (data) => {
  return axios.request({
    url: '/api/as/csc/auditcomplainthandle/getComplaintHandleList',
    method: 'post',
    data: data
  })
}
export const addComplaint = (data) => {
  return axios.request({
    url: '/api/as/csc/auditcomplainthandle/addComplaint',
    method: 'post',
    data: data
  })
}
export const deleteComplaint = (data) => {
  return axios.request({
    url: '/api/as/csc/auditcomplainthandle/deleteComplaint',
    method: 'post',
    data: data
  })
}
export const updateComplaint = (data) => {
  return axios.request({
    url: '/api/as/csc/auditcomplainthandle/updateComplaint',
    method: 'post',
    data: data
  })
}
export const updateComplaintHandle = (data) => {
  return axios.request({
    url: '/api/as/csc/auditcomplainthandle/updateComplaintHandle',
    method: 'post',
    data: data
  })
}
// 获取首页弹出html
export const savelog = (data) => {
  return axios.request({
    url: '/api/as/csc/auditshowhtml/savelog',
    method: 'post',
    data: data
  })
}
export const itemTypeList = (data) => {
  return axios.request({
    url: '/api/as/csc/audititem/itemTypeList',
    method: 'post',
    data: data
  })
}
export const findDepositList = (data) => {
  return axios.request({
    url: '/api/as/csc/auditDocumentDeposit/findDepositList',
    method: 'post',
    data: data
  })
}
export const updateDeposit = (data) => {
  return axios.request({
    url: '/api/as/csc/auditDocumentDeposit/updateDeposit',
    method: 'post',
    data: data
  })
}
export const findDZZMList = (data) => {
  return axios.request({
    url: '/api/as/csc/auditDocumentDeposit/findDZZMList',
    method: 'post',
    data: data
  })
}
export const findItemVersionList = (data) => {
  return axios.request({
    url: '/api/as/csc/auditDocumentDeposit/findItemVersionList',
    method: 'post',
    data: data
  })
}

export const getJyzDzzzUrl = (data) => {
  return axios.request({
    url: '/api/ac/csc/auditJyzDzzzService/updateJyzDzzzUrl',
    method: 'post',
    data: data
  })
}
export const saveImportantdocument = (data) => {
  return axios.request({
    url: '/api/as/csc/auditDocumentDeposit/saveImportantdocument',
    method: 'post',
    data: data
  })
}
export const findDictList = (data) => {
  return axios.request({
    url: '/api/ac/csc/dictTypeService/findDictList',
    method: 'post',
    data: data
  })
}
export const DictList = (data) => {
  return axios.request({
    url: '/api/as/csc/dicttypeservicedao/findDictList',
    method: 'post',
    data: data
  })
}
export const saveDict = (data) => {
  return axios.request({
    url: '/api/as/csc/dicttypeservicedao/saveDict',
    method: 'post',
    data: data
  })
}
export const updateDict = (data) => {
  return axios.request({
    url: '/api/as/csc/dicttypeservicedao/updateDict',
    method: 'post',
    data: data
  })
}
export const deleteDict = (data) => {
  return axios.request({
    url: '/api/as/csc/dicttypeservicedao/deleteDict',
    method: 'post',
    data: data
  })
}
export const findDictTypeList = (data) => {
  return axios.request({
    url: '/api/ac/csc/dictTypeService/findDictTypeList',
    method: 'post',
    data: data
  })
}
export const DictTypeList = (data) => {
  return axios.request({
    url: '/api/as/csc/dicttypeservicedao/findDictTypeList',
    method: 'post',
    data: data
  })
}
export const saveDictType = (data) => {
  return axios.request({
    url: '/api/as/csc/dicttypeservicedao/saveDictType',
    method: 'post',
    data: data
  })
}
export const updateDictType = (data) => {
  return axios.request({
    url: '/api/as/csc/dicttypeservicedao/updateDictType',
    method: 'post',
    data: data
  })
}
export const deleteDictType = (data) => {
  return axios.request({
    url: '/api/as/csc/dicttypeservicedao/deleteDictType',
    method: 'post',
    data: data
  })
}
export const deleteDictList = (data) => {
  return axios.request({
    url: '/api/as/csc/dicttypeservicedao/deleteDictList',
    method: 'post',
    data: data
  })
}
export const findPhoneList = (data) => {
  return axios.request({
    url: '/api/as/csc/auditnotice/findPhoneList',
    method: 'post',
    data: data
  })
}
export const updatePhoneInfo = (data) => {
  return axios.request({
    url: '/api/as/csc/auditnotice/updatePhoneInfo',
    method: 'post',
    data: data
  })
}
export const findOfficeLevelList = (data) => {
  return axios.request({
    url: '/api/ac/csc/sysOfficeLevelService/findOfficeLevelList',
    method: 'post',
    data: data
  })
}
export const findSubordinateList = (data) => {
  return axios.request({
    url: '/api/ac/csc/sysOfficeLevelService/findSubordinateList',
    method: 'post',
    data: data
  })
}
export const insertCoordinate = (data) => {
  return axios.request({
    url: '/api/ac/csc/sysOfficeLevelService/Coordinate',
    method: 'post',
    data: data
  })
}
export const findTreeList = (data) => {
  return axios.request({
    url: '/api/ac/csc/sysOfficeLevelService/findTreeList',
    method: 'post',
    data: data
  })
}
export const createFloor = (data) => {
  return axios.request({
    url: '/api/ac/csc/sysOfficeLevelService/createFloor',
    method: 'post',
    data: data
  })
}
export const updateDoorplate = (data) => {
  return axios.request({
    url: '/api/as/csc/sysOfficeinfo/updateDoorplate',
    method: 'post',
    data: data
  })
}
export const deleteDoorplate = (data) => {
  return axios.request({
    url: '/api/as/csc/sysOfficeinfo/deleteDoorplate',
    method: 'post',
    data: data
  })
}
export const updateFloor = (data) => {
  return axios.request({
    url: '/api/as/csc/sysOfficeinfo/updateFloor',
    method: 'post',
    data: data
  })
}
export const deleteFloor = (data) => {
  return axios.request({
    url: '/api/ac/csc/sysOfficeLevelService/deleteFloor',
    method: 'post',
    data: data
  })
}
export const createFloorDoorplate = (data) => {
  return axios.request({
    url: '/api/ac/csc/sysOfficeLevelService/createFloorDoorplate',
    method: 'post',
    data: data
  })
}
export const updateFloorSort = (data) => {
  return axios.request({
    url: '/api/ac/csc/sysOfficeLevelService/updateFloorSort',
    method: 'post',
    data: data
  })
}
export const getStatistics = (data) => {
  return axios.request({
    url: '/api/ac/csc/sysOfficeLevelService/getStatistics',
    method: 'post',
    data: data
  })
}
export const findGridUserList = (data) => {
  return axios.request({
    url: '/api/as/csc/sysOfficeinfo/findUserList',
    method: 'post',
    data: data
  })
}
export const getUserInfoByCardNo = (data) => {
  return axios.request({
    url: '/api/as/csc/sysOfficeinfo/getUserInfoByCardNo',
    method: 'post',
    data: data
  })
}
export const findDoorplateUserList = (data) => {
  return axios.request({
    url: '/api/as/csc/sysOfficeinfo/findDoorplateUserList',
    method: 'post',
    data: data
  })
}
export const findGardenList = (data) => {
  return axios.request({
    url: '/api/as/csc/sysOfficeinfo/findGardenList',
    method: 'post',
    data: data
  })
}
export const findBuildingList = (data) => {
  return axios.request({
    url: '/api/as/csc/sysOfficeinfo/findBuildingList',
    method: 'post',
    data: data
  })
}
export const findUnitList = (data) => {
  return axios.request({
    url: '/api/as/csc/sysOfficeinfo/findUnitList',
    method: 'post',
    data: data
  })
}
export const findFloorList = (data) => {
  return axios.request({
    url: '/api/as/csc/sysOfficeinfo/findFloorList',
    method: 'post',
    data: data
  })
}
export const findDoorplateList = (data) => {
  return axios.request({
    url: '/api/as/csc/sysOfficeinfo/findDoorplateList',
    method: 'post',
    data: data
  })
}
export const getGridUserInfo = (data) => {
  return axios.request({
    url: '/api/as/csc/sysOfficeinfo/getGridUserInfo',
    method: 'post',
    data: data
  })
}
export const createGridUserInfo = (data) => {
  return axios.request({
    url: '/api/ac/csc/sysOfficeLevelService/createGridUserInfo',
    method: 'post',
    data: data
  })
}
export const getOfficeInfoByCompanyCode = (data) => { // 获取社区网格信息
  return axios.request({
    url: '/api/ac/csc/sysOfficeLevelService/getOfficeInfoByCompanyCode',
    method: 'post',
    data: data
  })
}
export const mzMenulist = (data) => {
  return axios.request({
    url: '/api/ac/sc/menuService/mzMenulist?menu_id=' + data,
    method: 'get'
  })
}
// 查询全部网格
export const findAllGridList = (data) => {
  return axios.request({
    url: '/api/as/csc/sysOfficeinfo/findAllGridList',
    method: 'post',
    data: data
  })
}
export const getGridByGardenId = (data) => {
  return axios.request({
    url: '/api/ac/csc/sysOfficeLevelService/getGridByGardenId',
    method: 'post',
    data: data
  })
}
export const getGardenByCoordinates = (data) => {
  return axios.request({
    url: '/api/as/csc/sysOfficeinfo/getGardenByCoordinates',
    method: 'post',
    data: data
  })
}
export const getPersonAcceptanceList = (data) => {
  return axios.request({
    url: '/api/as/csc/auditorderstatistics/getPersonAcceptanceList',
    method: 'post',
    data: data
  })
}
export const getPersonWorkList = (data) => {
  return axios.request({
    url: '/api/as/csc/auditorderstatistics/getPersonWorkList',
    method: 'post',
    data: data
  })
}
export const getReturnList = (data) => {
  return axios.request({
    url: '/api/as/csc/auditorderstatistics/getReturnList',
    method: 'post',
    data: data
  })
}
export const getPersonReturnList = (data) => {
  return axios.request({
    url: '/api/as/csc/auditorderstatistics/getPersonReturnList',
    method: 'post',
    data: data
  })
}
export const getProcessingTimeList = (data) => {
  return axios.request({
    url: '/api/as/csc/auditorderstatistics/getProcessingTimeList',
    method: 'post',
    data: data
  })
}
export const getApprovalTimeList = (data) => {
  return axios.request({
    url: '/api/as/csc/auditorderstatistics/getApprovalTimeList',
    method: 'post',
    data: data
  })
}
export const getLineupTimeList = (data) => {
  return axios.request({
    url: '/api/as/csc/auditorderstatistics/getLineupTimeList',
    method: 'post',
    data: data
  })
}
export const createOrderEMS = (data) => {
  return axios.request({
    url: '/api/ac/csc/AuditOrderEmsService/createOrderEMS',
    method: 'post',
    data: data
  })
}
export const getOrdeEMS = (data) => {
  return axios.request({
    url: '/api/as/csc/auditorderems/getOrdeEMS',
    method: 'post',
    data: data
  })
}
export const getOrderEMSList = (data) => {
  return axios.request({
    url: '/api/as/csc/auditorderems/getOrderEMSList',
    method: 'post',
    data: data
  })
}
export const findGardenXJList = (data) => {
  return axios.request({
    url: '/api/as/csc/sysOfficeinfo/findGardenXJList',
    method: 'post',
    data: data
  })
}
export const getBuildingByCoordinates = (data) => {
  return axios.request({
    url: '/api/as/csc/sysOfficeinfo/getBuildingByCoordinates',
    method: 'post',
    data: data
  })
}
export const findCommunityXJList = (data) => {
  return axios.request({
    url: '/api/as/csc/sysOfficeinfo/findCommunityXJList',
    method: 'post',
    data: data
  })
}
// 业务量统计接口
export const getbusinessStatisticsPageList = (param) => {
  return axios.request({
    url: '/api/as/csc/businessStatistics/getbusinessStatisticsPageList',
    method: 'post',
    data: param
  })
}
// 办件统计接口
export const processingStatisticsList = (param) => {
  return axios.request({
    url: '/api/as/csc/DataStatistics/processingStatisticsList',
    method: 'post',
    data: param
  })
}
// 满意度统计接口
export const satisfactionStatisticsList = (param) => {
  return axios.request({
    url: '/api/as/csc/DataStatistics/satisfactionStatisticsList',
    method: 'post',
    data: param
  })
}
// 残疾人身份验证
export const authentication = (data) => {
  return axios.request({
    url: '/api/ac/csc/auditOrder3rdService/authentication',
    method: 'post',
    data: data
  })
}
// 现场检查
export const inspectionList = (param) => {
  return axios.request({
    url: '/api/as/csc/onsiteinspection/inspectionList',
    method: 'post',
    data: param
  })
}
// 保存现场检查
export const saveSituation = (param) => {
  return axios.request({
    url: '/api/ac/csc/onSiteInspectionService/saveSituation',
    method: 'post',
    data: param
  })
}
// 删除检查信息通知公告
export const deleteSituation = (param) => {
  return axios.request({
    url: '/api/as/csc/onsiteinspection/deleteSituation',
    method: 'post',
    data: param
  })
}
// 事项是否检查
export const setSituationState = (param) => {
  return axios.request({
    url: '/api/as/csc/onsiteinspection/setSituationState',
    method: 'post',
    data: param
  })
}
// 助学金重复申请验证接口
export const repeatApplicationValidation = (data) => {
  return axios.request({
    url: '/api/ac/csc/auditOrder3rdService/repeatApplicationValidation',
    method: 'post',
    data: data
  })
}
// 所有残疾人证办理验证接口
export const checkDisabilityCertificateAll = (data) => {
  return axios.request({
    url: '/api/ac/csc/auditOrder3rdService/checkDisabilityCertificateAll',
    method: 'post',
    data: data
  })
}
// 满意度分析接口
export const findSatisfactionAnalysisList = (data) => {
  return axios.request({
    url: '/api/as/csc/statisticalanalysis/findSatisfactionAnalysisList',
    method: 'post',
    data: data
  })
}
// 办理量占比接口
export const getHandlingVolume = (data) => {
  return axios.request({
    url: '/api/as/csc/statisticalanalysis/getHandlingVolume',
    method: 'post',
    data: data
  })
}
// 各部门办理量接口
export const findImmediateRateList = (data) => {
  return axios.request({
    url: '/api/as/csc/statisticalanalysis/findImmediateRateList',
    method: 'post',
    data: data
  })
}
// export const getGridInfo = (data) => {
//   return axios.request({
//     url: '/api/ac/grid/gridLevelService/getGridInfo',
//     method: 'post',
//     data: data
//   })
// }
export const getGridInfo = (data) => {
  return axios.request({
    url: 'http://qstb.mzj.shenyang.gov.cn/api/ac/grid/gridLevelService/getGridInfo',
    method: 'post',
    data: data
  })
}
// 今日排队情况
export const findLineUpTodayList = (data) => {
  return axios.request({
    url: '/api/as/csc/AuditHistoryAndTodayLineUp/findTodayLineUpList',
    method: 'post',
    data: data
  })
}
// 历史排队情况
export const findLineUpHistoryList = (data) => {
  return axios.request({
    url: '/api/as/csc/AuditHistoryAndTodayLineUp/findHistoryLineUpList',
    method: 'post',
    data: data
  })
}
// 代办人信息列表查询
export const findinfomationList = (data) => {
  return axios.request({
    url: '/api/as/csc/agentinfomation/findinfomationList',
    method: 'post',
    data: data
  })
}
// 代办人信息增加修改
export const saveinfomation = (param) => {
  return axios.request({
    url: '/api/ac/csc/lineUpService/saveinfomation',
    method: 'post',
    data: param
  })
}
// 叫号机管理
export const saveAdministrationn = (data) => {
  return axios.request({
    url: '/api/ac/csc/lineUpService/saveAdministrationn',
    method: 'post',
    data: data
  })
}
// 材料信息列表查询
export const findconfirmList = (data) => {
  return axios.request({
    url: '/api/as/csc/agentinfomation/findconfirmList',
    method: 'post',
    data: data
  })
}
// 是否确认
export const setConfirmState = (data) => {
  return axios.request({
    url: '/api/as/csc/agentinfomation/setConfirmState',
    method: 'post',
    data: data
  })
}
// 添加材料信息
export const saveconfirm = (data) => {
  return axios.request({
    url: '/api/ac/csc/lineUpService/saveconfirm',
    method: 'post',
    data: data
  })
}
// 删除材料信息
export const deleteconfirm = (param) => {
  return axios.request({
    url: '/api/as/csc/agentinfomation/deleteconfirm',
    method: 'post',
    data: param
  })
}
// 叫号机管理查询
export const getAdministrationn = (data) => {
  return axios.request({
    url: '/api/as/csc/auditlineup/getAdministrationn',
    method: 'post',
    data: data
  })
}
// 员工满意度分析接口
export const findEmployeeSatisfactionList = (data) => {
  return axios.request({
    url: '/api/as/csc/statisticalanalysis/findEmployeeSatisfactionList',
    method: 'post',
    data: data
  })
}
// 满意度变化趋势分析
export const findSatisfactionTrendList = (data) => {
  return axios.request({
    url: '/api/as/csc/statisticalanalysis/findSatisfactionTrendList',
    method: 'post',
    data: data
  })
}
// 查询指标管理
export const getIndexManagement = (data) => {
  return axios.request({
    url: '/api/as/csc/onsiteinspection/getIndexManagement',
    method: 'post',
    data: data
  })
}
// 添加或修改指标
export const saveIndexManagement = (data) => {
  return axios.request({
    url: '/api/ac/csc/onSiteInspectionService/saveIndexManagement',
    method: 'post',
    data: data
  })
}
// 满意度排名
export const satisfactionRankingList = (data) => {
  return axios.request({
    url: '/api/as/csc/DataStatistics/satisfactionRankingList',
    method: 'post',
    data: data
  })
}
export const findScoreList = (param) => {
  return axios.request({
    url: '/api/as/csc/score/findScoreList',
    method: 'post',
    data: param
  })
}
export const insertScore = (param) => {
  return axios.request({
    url: '/api/as/csc/score/insertScore',
    method: 'post',
    data: param
  })
}
export const findUserPeopleList = (param) => {
  return axios.request({
    url: 'http://qstb.mzj.shenyang.gov.cn/api/as/grid/user/findUserList',
    method: 'post',
    data: param
  })
}
// 综合绩效排名
export const PerformanceRankingList = (data) => {
  return axios.request({
    url: '/api/as/csc/DataStatistics/PerformanceRankingList',
    method: 'post',
    data: data
  })
}
// 短信接口
export const createSendSMS = (data) => {
  return axios.request({
    url: '/api/ac/csc/sendSMSService/createSendSMS',
    method: 'post',
    data: data
  })
}
// 公共服务系统工作台接口
export const pubOrderList = (data) => {
  return axios.request({
    url: 'http://qstb.mzj.shenyang.gov.cn/api/as/cscpub/auditorder/orderlist',
    method: 'post',
    data: data
  })
}
// 公共服务系统收受分离接口
export const pubSeparateList = (data) => {
  return axios.request({
    url: 'http://qstb.mzj.shenyang.gov.cn/api/ac/cscpub/auditOrderService/getSeparateList',
    method: 'post',
    data: data
  })
}
// 测试环境公共服务系统工作台接口
export const csPubOrderList = (data) => {
  return axios.request({
    url: 'http://iviewpub.tripln.top/api/as/cscpub/auditorder/orderlist',
    method: 'post',
    data: data
  })
}
// 测试环境公共服务系统收受分离接口
export const csPubSeparateList = (data) => {
  return axios.request({
    url: 'http://iviewpub.tripln.top/api/ac/cscpub/auditOrderService/getSeparateList',
    method: 'post',
    data: data
  })
}
// 查询是否办理过残疾人两项补贴接口
export const getDisabilityInfo = (data) => {
  return axios.request({
    url: '/api/ac/csc/createDisabilityOrderService/getDisabilityInfo',
    method: 'post',
    data: data
  })
}
// 外部评价详情接口
export const getScoreInfo = (data) => {
  return axios.request({
    url: '/api/as/csc/score/getScoreInfo',
    method: 'post',
    data: data
  })
}
// 便民数据管理订单整合
export const orderNewList = (data) => {
  return axios.request({
    url: '/api/as/csc/auditorder/orderNewList',
    method: 'post',
    data: data
  })
}
// 便民数据管理订单整合service
export const getOrderNewList = (data) => {
  return axios.request({
    url: '/api/ac/csc/auditOrderService/getOrderNewList',
    method: 'post',
    data: data
  })
}
// 电子证照统计分析service
export const getDzzzStatisticalPageList = (data) => {
  return axios.request({
    url: '/api/ac/csc/auditOrderService/getDzzzStatisticalPageList',
    method: 'post',
    data: data
  })
}
// 沈阳市政府购买居家养老服务对接机构在养人员信息查询接口
export const getInPensionState = (data) => {
  return axios.request({
    url: '/api/ac/csc/CreatePensionOrderService/getInPensionState',
    method: 'post',
    data: data
  })
}
// 沈阳市政府购买居家养老服务对接失能护理补贴人员信息查询接口
export const getDisabilityCareState = (data) => {
  return axios.request({
    url: '/api/ac/csc/CreatePensionOrderService/getDisabilityCareState',
    method: 'post',
    data: data
  })
}
// 沈阳市政府购买居家养老服务对接计划生育人员信息数据查询
export const getFamilyPlanningState = (data) => {
  return axios.request({
    url: '/api/ac/csc/CreatePensionOrderService/getFamilyPlanningState',
    method: 'post',
    data: data
  })
}
// 沈阳市政府购买居家养老服务对接查询办理人是否已申报政府购买服务
export const getDoubleCheckState = (data) => {
  return axios.request({
    url: '/api/ac/csc/CreatePensionOrderService/getDoubleCheckState',
    method: 'post',
    data: data
  })
}
// 沈阳市政府高龄老人人员信息查询接口
export const gllrxxCXJK = (data) => {
  return axios.request({
    url: '/api/ac/csc/CreatePensionOrderService/selectGllrxxOrZsgllrxx',
    method: 'post',
    data: data
  })
}
// 高龄老人信息查询接口
export const getGllrruxxList = (param) => {
  return axios.request({
    url: '/api/as/csc/auditorder/getGllrruxxList',
    method: 'post',
    data: param
  })
}
// 沈阳市政府养老人员年龄查询接口
export const qureyAgeByCard = (data) => {
  return axios.request({
    url: '/api/ac/csc/createPostService/qureyAgeByCard',
    method: 'post',
    data: data
  })
}
// 居住证明查询列表接口
export const getResidentialList = (data) => {
  return axios.request({
    url: '/api/ac/csc/auditOrderService/getResidentialList',
    method: 'post',
    data: data
  })
}
// 查询挂牌列表
export const findBrandList = (data) => {
  return axios.request({
    url: '/api/ac/csc/auditBrandService/findBrandList',
    method: 'post',
    data: data
  })
}
// 添加挂牌
export const addBrand = (data) => {
  return axios.request({
    url: '/api/as/csc/auditbrand/addBrand',
    method: 'post',
    data: data
  })
}
// 修改挂牌信息
export const setBrand = (data) => {
  return axios.request({
    url: '/api/as/csc/auditbrand/setBrand',
    method: 'post',
    data: data
  })
}
// 删除挂牌
export const delBrand = (data) => {
  return axios.request({
    url: '/api/as/csc/auditbrand/delBrand',
    method: 'post',
    data: data
  })
}
// 逻辑删除挂牌
export const setBrandState = (data) => {
  return axios.request({
    url: '/api/as/csc/auditbrand/setBrandState',
    method: 'post',
    data: data
  })
}
// 添加子挂牌
export const addBrandDetailed = (data) => {
  return axios.request({
    url: '/api/as/csc/auditbrand/addBrandDetailed',
    method: 'post',
    data: data
  })
}
// 修改子挂牌
export const setBrandDetailed = (data) => {
  return axios.request({
    url: '/api/as/csc/auditbrand/setBrandDetailed',
    method: 'post',
    data: data
  })
}
// 删除子挂牌
export const delBrandDetailed = (data) => {
  return axios.request({
    url: '/api/as/csc/auditbrand/delBrandDetailed',
    method: 'post',
    data: data
  })
}
// 发起挂牌的列表
export const findListingList = (data) => {
  return axios.request({
    url: '/api/as/csc/communityListing/findListingList',
    method: 'post',
    data: data
  })
}
// 挂牌的待审批列表
export const findPendingApprovalList = (data) => {
  return axios.request({
    url: '/api/as/csc/communityListing/findPendingApprovalList',
    method: 'post',
    data: data
  })
}
// 挂牌的已审批列表
export const findApprovedList = (data) => {
  return axios.request({
    url: '/api/as/csc/communityListing/findApprovedList',
    method: 'post',
    data: data
  })
}
// 挂牌审批
export const ProcessApproval = (data) => {
  return axios.request({
    url: '/api/ac/csc/CommunityListingService/updateProcessApproval',
    method: 'post',
    data: data
  })
}
// 我的牌子
export const findMyBrandList = (data) => {
  return axios.request({
    url: '/api/as/csc/communityListing/findBrandList',
    method: 'post',
    data: data
  })
}
// 统计牌子
// export const findBrandStatisticsList = (data) => {
//   return axios.request({
//     url: '/api/as/csc/communityListing/findBrandStatisticsList',
//     method: 'post',
//     data: data
//   })
// }
// 统计牌子
export const findBrandStatisticsList = (data) => {
  return axios.request({
    url: '/api/ac/csc/CommunityListingService/findBrandStatisticsList',
    method: 'post',
    data: data
  })
}
// 牌子照片
export const getPhotoAll = (data) => {
  return axios.request({
    url: '/api/as/csc/communityListing/getPhotoList',
    method: 'post',
    data: data
  })
}
// 养老接口下拉框
export const getdmlbTreeList = (data) => {
  return axios.request({
    url: '/api/as/csc/auditYangLao/getdmlbTreeList',
    method: 'post',
    data: data
  })
}
// 社区未挂的牌子
export const findUnlistedList = (data) => {
  return axios.request({
    url: '/api/as/csc/communityListing/findUnlistedList',
    method: 'post',
    data: data
  })
}
// 社区添加挂牌
export const saveBrand = (data) => {
  return axios.request({
    url: '/api/ac/csc/auditBrandService/saveBrand',
    method: 'post',
    data: data
  })
}
// 不合格的牌子列表
export const findUnqualifiedList = (data) => {
  return axios.request({
    url: '/api/as/csc/communityListing/findUnqualifiedList',
    method: 'post',
    data: data
  })
}
// 添加不合格牌子
export const saveUnqualifiedBrand = (data) => {
  return axios.request({
    url: '/api/ac/csc/CommunityListingService/saveUnqualifiedBrand',
    method: 'post',
    data: data
  })
}
// 删除不合格的牌子
export const deleteBrand = (data) => {
  return axios.request({
    url: '/api/as/csc/communityListing/deleteBrand',
    method: 'post',
    data: data
  })
}
export const findTestCode = (data) => {
  return axios.request({
    url: '/api/as/csc/ejdm/findTestCodeList',
    method: 'post',
    data: data
  })
}
export const findOfficeList = (data) => {
  return axios.request({
    url: '/api/ac/csc/CommunityListingService/findOfficeList',
    method: 'post',
    data: data
  })
}
export const dealToCommunity = (data) => {
  return axios.request({
    url: '/api/ac/csc/CommunityListingService/saveDealToCommunity',
    method: 'post',
    data: data
  })
}
// 上传牌子照片
export const updatePhoto = (data) => {
  return axios.request({
    url: '/api/as/csc/communityListing/updatePhoto',
    method: 'post',
    data: data
  })
}
// 查询不同级别的通讯录列表
export const getOfficeList = (param) => {
  return axios.request({
    url: '/api/as/csc/auditmail/getOfficeList',
    method: 'post',
    data: param
  })
}
// 发牌单位字典
export const getDictTreeList = (data) => {
  return axios.request({
    url: '/api/as/csc/communityListing/getDictTreeList',
    method: 'post',
    data: data
  })
}
// 社区门牌子
export const addCommunityBrand = (data) => {
  return axios.request({
    url: '/api/ac/csc/CommunityListingService/addCommunityBrand',
    method: 'post',
    data: data
  })
}
// 社区门牌子
export const getCommunityPhoto = (data) => {
  return axios.request({
    url: '/api/as/csc/communityListing/getCommunityPhoto',
    method: 'post',
    data: data
  })
}
export const getDocumentSjNum = (data) => {
  return axios.request({
    url: 'api/as/csc/auditDocumentDeposit/getDocumentSjNum',
    method: 'post',
    data: data
  })
}
export const getDocumentLxNum = (data) => {
  return axios.request({
    url: 'api/as/csc/auditDocumentDeposit/getDocumentLxNum',
    method: 'post',
    data: data
  })
}
// 获取挂牌提示
export const findHtmlList2 = (data) => {
  return axios.request({
    url: '/api/as/csc/auditshowhtml/findHtmlList2',
    method: 'post',
    data: data
  })
}
// 获取挂牌提示
export const getHtml2 = (data) => {
  return axios.request({
    url: '/api/as/csc/auditshowhtml/getHtml2',
    method: 'post',
    data: data
  })
}
export const findItemDocumentNumList = (data) => {
  return axios.request({
    url: '/api/us/csc/auditDocumentDeposit/findItemDocumentNumList',
    method: 'post',
    data: data
  })
}
export const findItemDocumentList = (data) => {
  return axios.request({
    url: '/api/us/csc/auditDocumentDeposit/findItemList',
    method: 'post',
    data: data
  })
}
// 导出管理查询导出数据库设置列表
export const getExportDataBaseList = (data) => {
  return axios.request({
    url: '/api/ac/export/exportCommonService/getExportDataBaseList',
    method: 'post',
    data: data
  })
}
// 导出管理添加导出数据库
export const insertExportDataBase = (data) => {
  return axios.request({
    url: '/api/ac/export/exportCommonService/insertExportDataBase',
    method: 'post',
    data: data
  })
}
// 导出管理修改导出数据库
export const updateExportDataBase = (data) => {
  return axios.request({
    url: '/api/ac/export/exportCommonService/updateExportDataBase',
    method: 'post',
    data: data
  })
}
// 导出管理删除导出数据库
export const deleteExportDataBase = (data) => {
  return axios.request({
    url: '/api/ac/export/exportCommonService/deleteExportDataBase',
    method: 'post',
    data: data
  })
}
// 导出管理获取数据库系统表列表
export const getDataBaseNameList = (data) => {
  return axios.request({
    url: '/api/ac/export/exportCommonService/getDataBaseNameList',
    method: 'post',
    data: data
  })
}
// 导出管理获取数据库系统表分页列表
export const getExportDataBaseTablePageList = (data) => {
  return axios.request({
    url: '/api/ac/export/exportCommonService/getExportDataBaseTablePageList',
    method: 'post',
    data: data
  })
}
// 导出管理修改导出数据库表设置
export const updateExportDataBaseTable = (data) => {
  return axios.request({
    url: '/api/ac/export/exportCommonService/updateExportDataBaseTable',
    method: 'post',
    data: data
  })
}
// 导出管理删除导出数据库表设置
export const deleteExportDataBaseTable = (data) => {
  return axios.request({
    url: '/api/ac/export/exportCommonService/deleteExportDataBaseTable',
    method: 'post',
    data: data
  })
}
// 导出管理批量添加导出数据库表设置
export const insertExportDataBaseTableList = (data) => {
  return axios.request({
    url: '/api/ac/export/exportCommonService/insertExportDataBaseTableList',
    method: 'post',
    data: data
  })
}
// 导出管理查询导出任务设置列表
export const getExportSetPageList = (data) => {
  return axios.request({
    url: '/api/ac/export/exportCommonService/getExportSetPageList',
    method: 'post',
    data: data
  })
}
// 导出管理添加导出任务设置
export const insertExportSet = (data) => {
  return axios.request({
    url: '/api/ac/export/exportCommonService/insertExportSet',
    method: 'post',
    data: data
  })
}
// 导出管理查询导出数据库设置标识列表
export const getExportDataBaseBsList = (data) => {
  return axios.request({
    url: '/api/ac/export/exportCommonService/getExportDataBaseBsList',
    method: 'post',
    data: data
  })
}
// 导出管理查询导出数据库设置标识表列表
export const getExportDataBaseBsTableList = (data) => {
  return axios.request({
    url: '/api/ac/export/exportCommonService/getExportDataBaseBsTableList',
    method: 'post',
    data: data
  })
}
// 导出管理删除导出任务设置
export const deleteExportSet = (data) => {
  return axios.request({
    url: '/api/ac/export/exportCommonService/deleteExportSet',
    method: 'post',
    data: data
  })
}
// 导出管理修改导出任务设置
export const updateExportSet = (data) => {
  return axios.request({
    url: '/api/ac/export/exportCommonService/updateExportSet',
    method: 'post',
    data: data
  })
}
// 导出管理查询导出任务子表设置列表
export const getExportSetSubList = (data) => {
  return axios.request({
    url: '/api/ac/export/exportCommonService/getExportSetSubList',
    method: 'post',
    data: data
  })
}
// 导出管理修改导出任务子表设置
export const updateExportSetSub = (data) => {
  return axios.request({
    url: '/api/ac/export/exportCommonService/updateExportSetSub',
    method: 'post',
    data: data
  })
}
// 导出管理删除导出任务子表设置
export const deleteExportSetSub = (data) => {
  return axios.request({
    url: '/api/ac/export/exportCommonService/deleteExportSetSub',
    method: 'post',
    data: data
  })
}
// 导出管理添加导出任务子表设置
export const insertExportSetSub = (data) => {
  return axios.request({
    url: '/api/ac/export/exportCommonService/insertExportSetSub',
    method: 'post',
    data: data
  })
}
// 导出管理查询导出任务字段设置列表
export const getExportSetDetailList = (data) => {
  return axios.request({
    url: '/api/ac/export/exportCommonService/getExportSetDetailList',
    method: 'post',
    data: data
  })
}
// 导出管理查询导出任务绑定表列表
export const getExportSetTableNameList = (data) => {
  return axios.request({
    url: '/api/ac/export/exportCommonService/getExportSetTableNameList',
    method: 'post',
    data: data
  })
}
// 导出管理通过系统表查询字段列表
export const getTableFieldList = (data) => {
  return axios.request({
    url: '/api/ac/export/exportCommonService/getTableFieldList',
    method: 'post',
    data: data
  })
}
// 导出管理添加导出任务字段设置
export const insertExportSetDetail = (data) => {
  return axios.request({
    url: '/api/ac/export/exportCommonService/insertExportSetDetail',
    method: 'post',
    data: data
  })
}
// 导出管理删除导出任务字段设置
export const deleteExportSetDetail = (data) => {
  return axios.request({
    url: '/api/ac/export/exportCommonService/deleteExportSetDetail',
    method: 'post',
    data: data
  })
}
// 导出管理查询导出任务条件列表
export const getExportSetConditionList = (data) => {
  return axios.request({
    url: '/api/ac/export/exportCommonService/getExportSetConditionList',
    method: 'post',
    data: data
  })
}
// 导出管理添加导出任务条件设置
export const insertExportSetCondition = (data) => {
  return axios.request({
    url: '/api/ac/export/exportCommonService/insertExportSetCondition',
    method: 'post',
    data: data
  })
}
// 导出管理删除导出任务条件设置
export const deleteExportSetCondition = (data) => {
  return axios.request({
    url: '/api/ac/export/exportCommonService/deleteExportSetCondition',
    method: 'post',
    data: data
  })
}
// 导出管理通过页面标识查询字段列表
export const getCountNameList = (data) => {
  return axios.request({
    url: '/api/ac/export/exportCommonService/getCountNameList',
    method: 'post',
    data: data
  })
}
// 导出管理通过页面标识查询任务列表
export const getSetByUrlList = (data) => {
  return axios.request({
    url: '/api/ac/export/exportCommonService/getSetByUrlList',
    method: 'post',
    data: data
  })
}
// 导出管理生成导出sql并创建定时任务
export const createExportSetTask = (data) => {
  return axios.request({
    url: '/api/ac/export/exportCommonService/createExportSetTask',
    method: 'post',
    data: data
  })
}
// 导出管理查询导出任务定时任务分页列表
export const getExportTaskList = (data) => {
  return axios.request({
    url: '/api/ac/export/exportCommonService/getExportTaskList',
    method: 'post',
    data: data
  })
}
// 通用对接 查询对接系统设置分页列表
export const getCommonDockingSystemPageList = (data) => {
  return axios.request({
    url: '/api/ac/exp/commonDockingService/getCommonDockingSystemPageList',
    method: 'post',
    data: data
  })
}
// 通用对接 添加对接系统设置
export const addCommonDockingSystem = (data) => {
  return axios.request({
    url: '/api/ac/exp/commonDockingService/addCommonDockingSystem',
    method: 'post',
    data: data
  })
}
// 通用对接 修改对接系统设置
export const updateCommonDockingSystem = (data) => {
  return axios.request({
    url: '/api/ac/exp/commonDockingService/updateCommonDockingSystem',
    method: 'post',
    data: data
  })
}
// 通用对接 删除对接系统设置
export const deleteCommonDockingSystem = (data) => {
  return axios.request({
    url: '/api/ac/exp/commonDockingService/deleteCommonDockingSystem',
    method: 'post',
    data: data
  })
}
// 通用对接 查询对接接口设置分页列表
export const getCommonDockingInterfacePageList = (data) => {
  return axios.request({
    url: '/api/ac/exp/commonDockingService/getCommonDockingInterfacePageList',
    method: 'post',
    data: data
  })
}
// 通用对接 查询对接系统设置列表
export const getCommonDockingSystemList = (data) => {
  return axios.request({
    url: '/api/ac/exp/commonDockingService/getCommonDockingSystemList',
    method: 'post',
    data: data
  })
}
// 通用对接 添加对接接口设置
export const addCommonDockingInterface = (data) => {
  return axios.request({
    url: '/api/ac/exp/commonDockingService/addCommonDockingInterface',
    method: 'post',
    data: data
  })
}
// 通用对接 修改对接接口设置
export const updateCommonDockingInterface = (data) => {
  return axios.request({
    url: '/api/ac/exp/commonDockingService/updateCommonDockingInterface',
    method: 'post',
    data: data
  })
}
// 通用对接 删除对接接口设置
export const deleteCommonDockingInterface = (data) => {
  return axios.request({
    url: '/api/ac/exp/commonDockingService/deleteCommonDockingInterface',
    method: 'post',
    data: data
  })
}
// 新前置查询
export const preQueryInfo = (data) => {
  return axios.request({
    url: '/api/ac/csc/preQueryService/preQueryInfo',
    method: 'post',
    data: data
  })
}
export const findbdNumList = (data) => {
  return axios.request({
    url: '/api/us/csc/auditDocumentDeposit/findbdNumList',
    method: 'post',
    data: data
  })
}
// 获取好差评配置列表
export const findHcpUserConfigList = (data) => {
  return axios.request({
    url: '/api/as/csc/audithcpevaluateuserinfo/findHcpUserConfigList',
    method: 'post',
    data: data
  })
}
// 设置好差评社区机构编号
export const updateCompanyConfig = (data) => {
  return axios.request({
    url: '/api/as/csc/audithcpevaluateuserinfo/updateCompanyConfig',
    method: 'post',
    data: data
  })
}
// 保障金额调整事项第一步提交接口
export const createPostLogin = (data) => {
  return axios.request({
    url: '/api/ac/csc/createPostService/createPostLogin',
    method: 'post',
    data: data
  })
}
// 获取常见问题列表
export const getProblemList = (data) => {
  return axios.request({
    url: '/api/as/csc/commonproblem/getProblemList',
    method: 'post',
    data: data
  })
}
// 添加常见问题
export const insertProblem = (data) => {
  return axios.request({
    url: '/api/as/csc/commonproblem/insertProblem',
    method: 'post',
    data: data
  })
}
// 修改常见问题
export const updateProblem = (data) => {
  return axios.request({
    url: '/api/as/csc/commonproblem/updateProblem',
    method: 'post',
    data: data
  })
}
// 删除常见问题
export const deleteProblem = (data) => {
  return axios.request({
    url: '/api/as/csc/commonproblem/deleteProblem',
    method: 'post',
    data: data
  })
}
// 查询盛世通推送的人员数据
export const saveUserInfo = (data) => {
  return axios.request({
    url: '/api/ac/csc/userInfoService/saveUserInfo',
    method: 'post',
    data: data
  })
}
// 作废账号
export const updateUser = (data) => {
  return axios.request({
    url: '/api/ac/csc/userInfoService/getUser',
    method: 'post',
    data: data
  })
}
export const getItemNoticeTreeList = (data) => {
  return axios.request({
    url: '/api/ac/csc/noticeService/getItemNoticeTreeList',
    method: 'post',
    data: data
  })
}
export const addItemNotice = (data) => {
  return axios.request({
    url: '/api/ac/csc/noticeService/addItemNotice',
    method: 'post',
    data: data
  })
}
export const getItemNotice = (data) => {
  return axios.request({
    url: '/api/ac/csc/noticeService/getItemNotice',
    method: 'post',
    data: data
  })
}
//  获取当前机构下账号列表
export const getUserList = (data) => {
  return axios.request({
    url: '/api/ac/sc/systemUserCSCServiceImpl/getUserList',
    method: 'post',
    data: data
  })
}
//  获取当前机构下角色组列表
export const getRoleGroupList = (data) => {
  return axios.request({
    url: '/api/ac/sc/systemUserCSCServiceImpl/getRoleGroupList',
    method: 'post',
    data: data
  })
}
//  添加用户
export const getAddUser = (data) => {
  return axios.request({
    url: '/api/ac/sc/systemUserCSCServiceImpl/addUser',
    method: 'post',
    data: data
  })
}
//  获取用户下角色组列表
export const getUserRoleGroupList = (data) => {
  return axios.request({
    url: '/api/ac/sc/systemUserCSCServiceImpl/getUserRoleGroupList',
    method: 'post',
    data: data
  })
}
//  修改用户角色组
export const getEditUserRoleGroup = (data) => {
  return axios.request({
    url: '/api/ac/sc/systemUserCSCServiceImpl/updateUserRoleGroup',
    method: 'post',
    data: data
  })
}
//  重置密码
export const getUpdateResetAccount = (data) => {
  return axios.request({
    url: '/api/ac/sc/systemUserCSCServiceImpl/updateResetAccount',
    method: 'post',
    data: data
  })
}

//  获取角色组列表
export const getRoleGroupPageList = (data) => {
  return axios.request({
    url: '/api/ac/sc/systemUserCSCServiceImpl/getRoleGroupPageList',
    method: 'post',
    data: data
  })
}
//  获取系统角色列表
export const getSystemRoleList = (data) => {
  return axios.request({
    url: '/api/ac/sc/systemUserCSCServiceImpl/getSystemRoleList',
    method: 'post',
    data: data
  })
}
//  创建角色组
export const getAddRoleGroup = (data) => {
  return axios.request({
    url: '/api/ac/sc/systemUserCSCServiceImpl/addRoleGroup',
    method: 'post',
    data: data
  })
}
//  修改角色组
export const getUpdateRoleGroup = (data) => {
  return axios.request({
    url: '/api/ac/sc/systemUserCSCServiceImpl/updateRoleGroup',
    method: 'post',
    data: data
  })
}
//  删除角色组
export const getDelRoleGroup = (data) => {
  return axios.request({
    url: '/api/ac/sc/systemUserCSCServiceImpl/deleteRoleGroup',
    method: 'post',
    data: data
  })
}
//  worker添加账号
export const getAddUserForWorker = (data) => {
  return axios.request({
    url: '/api/ac/sc/systemUserCSCServiceImpl/getAddUser',
    method: 'post',
    data: data
  })
}
//  网办修改订单状态
export const updateOrderApply = (data) => {
  return axios.request({
    url: '/api/ac/csc/auditOrderService/updateOrderApply',
    method: 'post',
    data: data
  })
}
//  低保免密登录
export const dibaoCreateGetToken = (data) => {
  return axios.request({
    url: '/api/ac/csc/diBaoWuMiService/createGetToken',
    method: 'post',
    data: data
  })
}
// 保存网办事项PDF
export const wbSaveItemWbPdf = (data) => {
  return axios.request({
    url: '/api/as/csc/audititemoption/saveItemWbPdf',
    method: 'post',
    data: data
  })
}
// 获取网办事项PDF
export const getItemWbPdf = (data) => {
  return axios.request({
    url: '/api/as/csc/audititemoption/getItemWbPdf',
    method: 'post',
    data: data
  })
}
export const postCN = (data) => {
  return axios.request({
    url: '/api/ac/csc/auditOrder3rdService/postCN',
    method: 'post',
    data: data
  })
}
export const findCommunityGridList = (data) => {
  return axios.request({
    url: '/api/ac/grid/gridDivideJurisdictionService/findCommunityGridList',
    method: 'post',
    data: data
  })
}
export const saveGridDivideJurisdictionForGrid = (data) => {
  return axios.request({
    url: '/api/ac/grid/gridDivideJurisdictionService/saveGridDivideJurisdictionForGrid',
    method: 'post',
    data: data
  })
}
export const DivideJurisdiction = (data) => {
  return axios.request({
    url: '/api/ac/grid/gridDivideJurisdictionService/DivideJurisdiction',
    method: 'post',
    data: data
  })
}
export const bindingWorker = (data) => {
  return axios.request({
    url: '/api/ac/csc/weChatService/bindingWorker',
    method: 'post',
    data: data
  })
}
export const findAuditRegionTreeList = (data) => { // 区划码树状图
  return axios.request({
    url: '/api/ac/sc/auditRegionService/findAuditRegionTreeList',
    method: 'post',
    data: data
  })
}
export const findAuditRegionList = (data) => { // 区划码级联接口
  return axios.request({
    url: '/api/as/sc/auditregion/findAuditRegionList',
    method: 'post',
    data: data
  })
}
export const createDownInfo = (data) => { // 创建下级行政区划
  return axios.request({
    url: '/api/ac/sc/auditRegionService/createDownInfo',
    method: 'post',
    data: data
  })
}
export const updateInfo = (data) => { // 修改下级行政区划
  return axios.request({
    url: '/api/ac/sc/auditRegionService/updateInfo',
    method: 'post',
    data: data
  })
}
export const getCommunityOfficeList = (data) => { // 获取信息
  return axios.request({
    url: '/api/as/sc/auditregion/getOfficeList',
    method: 'post',
    data: data
  })
}
export const getOfficeInfoList = (data) => { // 获取company_code
  return axios.request({
    url: '/api/as/sc/auditregion/getOfficeInfoList',
    method: 'post',
    data: data
  })
}
export const updateCommunityCode = (data) => { // 获取company_code
  return axios.request({
    url: '/api/ac/sc/auditRegionService/updateCommunityCode',
    method: 'post',
    data: data
  })
}
export const getMenuList = (data) => { // 获取菜单接口（2024-06-18）
  return axios.request({
    url: '/api/ac/jilinsscgsdp/sysService/selectMenuList?parentId=' + data,
    method: 'get'
  })
}
