import axios from '@/libs/api.request'

// ===== 人员分类管理 =====
export const getUserCategoryList = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUserCategory/selectList',
    method: 'post',
    data: param
  })
}

export const saveUserCategory = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUserCategory/save',
    method: 'post',
    data: param
  })
}

export const deleteUserCategory = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUserCategory/delete',
    method: 'post',
    data: param
  })
}

// ===== 人员分类权限管理 =====
export const getUserCategoryPermissionList = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUserCategoryPermission/selectList',
    method: 'post',
    data: param
  })
}

export const saveUserCategoryPermission = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmUserCategoryPermission/save',
    method: 'post',
    data: param
  })
}

// ===== 请假类型管理 =====
export const getLeaveTypeList = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmLeaveType/selectList',
    method: 'post',
    data: param
  })
}

export const saveLeaveType = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmLeaveType/save',
    method: 'post',
    data: param
  })
}

export const deleteLeaveType = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmLeaveType/delete',
    method: 'post',
    data: param
  })
}

// ===== 办公用品分类管理 =====
export const getMaterialCategoryList = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmMaterialCategory/selectList',
    method: 'post',
    data: param
  })
}

export const saveMaterialCategory = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmMaterialCategory/save',
    method: 'post',
    data: param
  })
}

export const deleteMaterialCategory = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmMaterialCategory/delete',
    method: 'post',
    data: param
  })
}

// ===== 办公用品管理 =====
export const getMaterialList = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmMaterial/selectList',
    method: 'post',
    data: param
  })
}

export const saveMaterial = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmMaterial/save',
    method: 'post',
    data: param
  })
}

export const deleteMaterial = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmMaterial/delete',
    method: 'post',
    data: param
  })
}

// 导入物料（Excel）
export const importMaterial = (formData) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmMaterial/import',
    method: 'post',
    data: formData
  })
}

// 下载物料导入模板
export const materialTemplateDownload = (param) => {
  return axios.request({
    url: '/api/ac/jilinsscgsdp/keyDmMaterial/templateDownload',
    method: 'post',
    data: param
  })
}
