var socket
var isSocketConnect = false
var openFlagA = false

var isOpenMainCamera = false

var MainCanvas
var MainContext

var pMainShowStartX = 0
var pMainShowStartY = 0

var isMouseDown = false
var pALastX = 0
var pALastY = 0
var pACurrentX = 0
var pACurrentY = 0

var MainCamCutMode = 0

// window.onload = function (event) {
//    WebSocketConnect();
// }

window.onbeforeunload = function () {
  CloseCamera() // 关闭摄像头
  try {
    socket.close()
    socket = null
  } catch (ex) {
  }
}

function $ (id) {
  console.log(id, '获取节点数据')
  return document.getElementById(id)
}

function stringToUint8Array (str) {
  var arr = []
  for (var i = 0, j = str.length; i < j; ++i) {
    arr.push(str.charCodeAt(i))
  }
  arr.push('\0')
  var tmpUint8Array = new Uint8Array(arr)
  return tmpUint8Array
}

function Uint8ArrayToString (fileData) {
  var dataString = ''
  for (var i = 0; i < fileData.length; i++) {
    dataString += String.fromCharCode(fileData[i])
  }
  return dataString
}

function stringToByte (str) {
  var bytes = new Array()
  var len, c
  len = str.length
  for (var i = 0; i < len; i++) {
    c = str.charCodeAt(i)
    if (c >= 0x010000 && c <= 0x10FFFF) {
      bytes.push(((c >> 18) & 0x07) | 0xF0)
      bytes.push(((c >> 12) & 0x3F) | 0x80)
      bytes.push(((c >> 6) & 0x3F) | 0x80)
      bytes.push((c & 0x3F) | 0x80)
    } else if (c >= 0x000800 && c <= 0x00FFFF) {
      bytes.push(((c >> 12) & 0x0F) | 0xE0)
      bytes.push(((c >> 6) & 0x3F) | 0x80)
      bytes.push((c & 0x3F) | 0x80)
    } else if (c >= 0x000080 && c <= 0x0007FF) {
      bytes.push(((c >> 6) & 0x1F) | 0xC0)
      bytes.push((c & 0x3F) | 0x80)
    } else {
      bytes.push(c & 0xFF)
    }
  }
  return bytes
}

function byteToString (arr) {
  if (typeof arr === 'string') {
    return arr
  }
  var str = '',
    _arr = arr
  for (var i = 0; i < _arr.length; i++) {
    var one = _arr[i].toString(2),
      v = one.match(/^1+?(?=0)/)
    if (v && one.length == 8) {
      var bytesLength = v[0].length
      var store = _arr[i].toString(2).slice(7 - bytesLength)
      for (var st = 1; st < bytesLength; st++) {
        store += _arr[st + i].toString(2).slice(2)
      }
      str += String.fromCharCode(parseInt(store, 2))
      i += bytesLength - 1
    } else {
      str += String.fromCharCode(_arr[i])
    }
  }
  return str
}

function InitCanvas (DivMainBox, mX, mY, mwidth, mheight) {
  // var DivMainBox = $("CameraCtl");

  if (mwidth != 0 && mheight != 0) {
    MainCanvas = document.createElement('canvas')
    MainCanvas.style.border = 'solid 1px #A0A0A0'
    MainCanvas.id = 'MainCamCanvas'
    MainCanvas.width = mwidth
    MainCanvas.height = mheight
    MainContext = MainCanvas.getContext('2d')
    DivMainBox.appendChild(MainCanvas) // 添加画布
    MainCanvas.onmousedown = MainCanvasMouseDown
    MainCanvas.onmousemove = MainCanvasMouseMove
    MainCanvas.onmouseup = MainCanvasMouseUp
    MainCanvas.onmouseout = MainCanvasMouseOut
  }
}

//* ************摄像头操作初始化***************
function Cam_ControlInit (documentObj, mX, mY, mwidth, mheight, callback) {
  WebSocketConnect(callback)
  InitCanvas(documentObj, mX, mY, mwidth, mheight)
  // console.log("Cam_ControlInit");
}

//* ************获取设备数目***************
function Cam_GetDevCount () {
  GetDevCount()
}

//* **************获取分辨率***************
function Cam_GetDevResolution (iCamNo) {
  GetResolution(iCamNo)
}

//* ************打开主摄像头***************
function Cam_Open (iCamNo, width, height) {
  OpenCamera(iCamNo, width, height)
}

//* ************关闭摄像头***************
function Cam_Close () {
  CloseCamera()
  isOpenMainCamera = false
}

//* ************拍照***************
function Cam_Photo (fileAddr) {
  if (MainCamCutMode == 1) {
    SetCutRect(pALastX, pALastY, (pACurrentX - pALastX), (pACurrentY - pALastY)) // 手动裁剪区域
  }
  CaptureImage(fileAddr)
}

//* ************放大***************
function Cam_ZoomIn () {
  ZoomIn()
}

//* ************缩小***************
function Cam_ZoomOut () {
  ZoomOut()
}

//* ************适合大小***************
function Cam_BestSize () {
  BestSize()
}

//* ************1:1***************
function Cam_TrueSize () {
  TrueSize()
}

//* ************左旋***************
function Cam_RotateLeft () {
  RotateL()
}

//* ************右旋***************
function Cam_RotateRight () {
  RotateR()
}

//* ************对焦***************
function Cam_Focus () {
  ManualFocus()
}

//* ************设置视频属性***************
function Cam_ShowVideoProp () {
  ShowVideoProp()
}

//* ************设置裁剪模式***************
function Cam_SetCutMode (CutMode) {
  SetCutMode(CutMode)
}

//* ************读取身份证信息*************
function Cam_ReadIdCard (cardImgPath) {
  ReadIdCard(cardImgPath)
}

/****************************************************************************************/

function ReadIdCard (cardImgPath) {
  if (isSocketConnect) {
    var path = encodeURI(cardImgPath)
    var pathArray = stringToByte(path)
    var len = pathArray.length
    var totalLen = len + 3
    var aDataArray = new Uint8Array(totalLen)
    aDataArray[0] = 0x77
    aDataArray[1] = 0x88
    aDataArray[2] = 0x80
    for (var i = 0; i < len; i++) {
      aDataArray[3 + i] = pathArray[i]
    }
    socket.send(aDataArray.buffer)
  }
}

function GetDevCount () {
  var aDataArray = new Uint8Array(3)
  aDataArray[0] = 0x77
  aDataArray[1] = 0x88
  aDataArray[2] = 0x50
  socket.send(aDataArray.buffer)
}

function GetResolution (iCamNo) {
  var aDataArray = new Uint8Array(4)
  aDataArray[0] = 0x77
  aDataArray[1] = 0x88
  aDataArray[2] = 0x51
  aDataArray[3] = iCamNo
  socket.send(aDataArray.buffer)
}

function OpenCamera (iCamNo, width, height) {
  pALastX = 0
  pALastY = 0
  pACurrentX = 0
  pACurrentY = 0

  if (isSocketConnect) {
    var aDataArray = new Uint8Array(12)
    aDataArray[0] = 0x77
    aDataArray[1] = 0x88
    aDataArray[2] = 0x01 // 打开摄像头
    aDataArray[3] = iCamNo
    aDataArray[4] = MainCanvas.width >> 8 & 0xff
    aDataArray[5] = MainCanvas.width & 0xff
    aDataArray[6] = MainCanvas.height >> 8 & 0xff
    aDataArray[7] = MainCanvas.height & 0xff
    aDataArray[8] = width >> 8 & 0xff
    aDataArray[9] = width & 0xff
    aDataArray[10] = height >> 8 & 0xff
    aDataArray[11] = height & 0xff

    socket.send(aDataArray.buffer)
  }
}

function CloseCamera () {
  if (isSocketConnect) {
    var aDataArray = new Uint8Array(4)
    aDataArray[0] = 0x77
    aDataArray[1] = 0x88
    aDataArray[2] = 0x02 // 关闭摄像头
    aDataArray[3] = 0x00
    socket.send(aDataArray.buffer)
  }
}

function CaptureImage (fileAddr) {
  if (isSocketConnect) {
    // var pathArray = stringToUint8Array(fileAddr);
    var path = encodeURI(fileAddr)
    // console.log(path);
    var pathArray = stringToByte(path)

    var len = pathArray.length
    var totalLen = len + 4
    var aDataArray = new Uint8Array(totalLen)
    aDataArray[0] = 0x77
    aDataArray[1] = 0x88
    aDataArray[2] = 0x10 // 拍照
    aDataArray[3] = 0x00
    for (var i = 0; i < len; i++) {
      aDataArray[4 + i] = pathArray[i]
    }
    socket.send(aDataArray.buffer)
  }
}

function ZoomIn () {
  if (isSocketConnect) {
    var aDataArray = new Uint8Array(4)
    aDataArray[0] = 0x77
    aDataArray[1] = 0x88
    aDataArray[2] = 0x03 // 放大
    aDataArray[3] = 0x00
    socket.send(aDataArray.buffer)
  }
}

function ZoomOut () {
  if (isSocketConnect) {
    var aDataArray = new Uint8Array(4)
    aDataArray[0] = 0x77
    aDataArray[1] = 0x88
    aDataArray[2] = 0x04 // 缩小
    aDataArray[3] = 0x00
    socket.send(aDataArray.buffer)
  }
}

function BestSize () {
  if (isSocketConnect) {
    var aDataArray = new Uint8Array(4)
    aDataArray[0] = 0x77
    aDataArray[1] = 0x88
    aDataArray[2] = 0x05 // 适合大小
    aDataArray[3] = 0x00
    socket.send(aDataArray.buffer)
  }
}

function TrueSize () {
  if (isSocketConnect) {
    var aDataArray = new Uint8Array(4)
    aDataArray[0] = 0x77
    aDataArray[1] = 0x88
    aDataArray[2] = 0x06 // 1:1
    aDataArray[3] = 0x00
    socket.send(aDataArray.buffer)
  }
}

function RotateL () {
  if (isSocketConnect) {
    var aDataArray = new Uint8Array(4)
    aDataArray[0] = 0x77
    aDataArray[1] = 0x88
    aDataArray[2] = 0x07 // 左旋
    aDataArray[3] = 0x00
    socket.send(aDataArray.buffer)
  }
}

function RotateR () {
  if (isSocketConnect) {
    var aDataArray = new Uint8Array(4)
    aDataArray[0] = 0x77
    aDataArray[1] = 0x88
    aDataArray[2] = 0x08 // 右旋
    aDataArray[3] = 0x00
    socket.send(aDataArray.buffer)
  }
}

function ManualFocus () {
  if (isSocketConnect) {
    var aDataArray = new Uint8Array(4)
    aDataArray[0] = 0x77
    aDataArray[1] = 0x88
    aDataArray[2] = 0x30
    aDataArray[3] = 0x00
    socket.send(aDataArray.buffer)
  }
}

function SetCutMode (cutMode) {
  if (isSocketConnect) {
    MainCamCutMode = cutMode
    var aDataArray = new Uint8Array(5)
    aDataArray[0] = 0x77
    aDataArray[1] = 0x88
    aDataArray[2] = 0x11 // 设置裁剪模式
    aDataArray[3] = 0x00
    aDataArray[4] = cutMode
    socket.send(aDataArray.buffer)
  }
}

function SetCutRect (rectX, rectY, rectW, rectH) {
  if (isSocketConnect) {
    var aDataArray = new Uint8Array(12)
    aDataArray[0] = 0x77
    aDataArray[1] = 0x88
    aDataArray[2] = 0x13 // 设置裁剪模式
    aDataArray[3] = 0x00
    aDataArray[4] = rectX >> 8 & 0xff
    aDataArray[5] = rectX & 0xff
    aDataArray[6] = rectY >> 8 & 0xff
    aDataArray[7] = rectY & 0xff
    aDataArray[8] = rectW >> 8 & 0xff
    aDataArray[9] = rectW & 0xff
    aDataArray[10] = rectH >> 8 & 0xff
    aDataArray[11] = rectH & 0xff
    socket.send(aDataArray.buffer)
  }
}

function ShowVideoProp () {
  if (isSocketConnect) {
    var aDataArray = new Uint8Array(4)
    aDataArray[0] = 0x77
    aDataArray[1] = 0x88
    aDataArray[2] = 0x12 // 设置视频属性
    aDataArray[3] = 0x00
    socket.send(aDataArray.buffer)
  }
}

function MoveOffsetXY (px, py, xdir, ydir) {
  if (isSocketConnect) {
    var aDataArray = new Uint8Array(10)
    aDataArray[0] = 0x77
    aDataArray[1] = 0x88
    aDataArray[2] = 0x09 // 移动
    aDataArray[3] = 0x00
    aDataArray[4] = px >> 8 & 0xff
    aDataArray[5] = px & 0xff
    aDataArray[6] = py >> 8 & 0xff
    aDataArray[7] = py & 0xff
    aDataArray[8] = xdir
    aDataArray[9] = ydir
    socket.send(aDataArray.buffer)
  }
}

function MainCanvasMouseDown (e) {
  isMouseDown = true
  pALastX = e.pageX - MainCanvas.offsetLeft
  pALastY = e.pageY - MainCanvas.offsetTop
  if (MainCamCutMode == 1) {
    pACurrentX = pALastX
    pACurrentY = pALastY
  }
}

function MainCanvasMouseUp (e) {
  isMouseDown = false
}

function MainCanvasMouseOut (e) {
  isMouseDown = false
}

function MainCanvasMouseMove (e) {
  if (isMouseDown) {
    if (MainCamCutMode == 1) {
      pACurrentX = e.pageX - MainCanvas.offsetLeft
      pACurrentY = e.pageY - MainCanvas.offsetTop
      SetCutRect(pALastX, pALastY, (pACurrentX - pALastX), (pACurrentY - pALastY)) // 手动裁剪区域
    } else {
      pACurrentX = e.pageX - MainCanvas.offsetLeft
      pACurrentY = e.pageY - MainCanvas.offsetTop
      var dx = pACurrentX - pALastX
      var dy = pACurrentY - pALastY
      var xdir = 0
      var ydir = 0
      if (dx < 0) { xdir = 0 } else { xdir = 1 }
      if (dy < 0) { ydir = 0 } else { ydir = 1 }
      pALastX = pACurrentX
      pALastY = pACurrentY
      MoveOffsetXY(Math.abs(dx), Math.abs(dy), xdir, ydir)
    }
  }
}

/** ********************callback第一个返回参数是状态值，第二个数组返回正常参数***********************************/

function WebSocketConnect (callback) {
  socket = new WebSocket('ws://localhost:9001')
  socket.binaryType = 'arraybuffer'
  try {
    socket.onopen = function (event) {
      isSocketConnect = true
      console.log('socket.onopen')
      Cam_GetDevCount()
    }

    socket.onclose = function (event) {
      isSocketConnect = false
      try {
        socket.close()
        socket = null
      } catch (ex) {
      }
      callback('error', '程序出错，连接关闭!')
    }

    socket.onerror = function (event) {
      isSocketConnect = false
      try {
        socket.close()
        socket = null
      } catch (ex) {
      }
      WebSocketConnect(callback)
      // alert("程序连接出错！");
      console.log('onerror 报错啦')
      callback('error', 'websocket connect error!')
    }

    socket.onmessage = function (event) {
      var rDataArr = new Uint8Array(event.data)
      if (rDataArr.length > 0) {
        if (rDataArr[0] == 0x55 && rDataArr[1] == 0x66) {
          // 摄像头数目返回
          if (rDataArr[2] == 0x50) {
            var devCount = rDataArr[3]
            var devNameBufLen = rDataArr.length - 4
            var devNameData = new Uint8Array(devNameBufLen)
            for (var i = 0; i < devNameBufLen; i++) {
              devNameData[i] = rDataArr[4 + i]
            }
            // var AllCamName = Uint8ArrayToString(devNameData);
            var str = byteToString(devNameData)
            var AllCamName = decodeURIComponent(str)
            var camName = new Array()
            camName = AllCamName.split('|')
            callback('GetDevCountAndNameResultCB', [devCount, camName])
          }

          // 摄像头分辨率返回
          if (rDataArr[2] == 0x51) {
            var resCount = rDataArr[3]
            var resArr = new Array()
            for (var i = 0; i < resCount; i++) {
              var width = rDataArr[4 + i * 4 + 0] * 256 + rDataArr[4 + i * 4 + 1]
              var height = rDataArr[4 + i * 4 + 2] * 256 + rDataArr[4 + i * 4 + 3]
              var resStr = '' + width + '*' + height
              resArr.push(resStr)
            }
            callback('GetResolutionResultCB', [resCount, resArr])
          }

          // 摄像头开启状态返回
          if (rDataArr[2] == 0x01) {
            if (rDataArr[3] == 0x01) {
              isOpenMainCamera = true
              callback('GetCameraOnOffStatus', [0])
            }
            if (rDataArr[3] == 0x03) {
              isOpenMainCamera = false
              callback('GetCameraOnOffStatus', 1)
            }
          }

          // 拍照结果返回
          if (rDataArr[2] == 0x10) {
            var flag
            if (rDataArr[3] == 0x01) {
              flag = 0
            }
            if (rDataArr[3] == 0x02) {
              flag = 2
            }
            var imgpathLen = rDataArr[4] * 256 + rDataArr[5]
            var base64Len = rDataArr[6] * 65536 + rDataArr[7] * 256 + rDataArr[8]

            var pData = new Uint8Array(imgpathLen)
            for (var i = 0; i < imgpathLen; i++) {
              pData[i] = rDataArr[9 + i]
            }
            var str = byteToString(pData)
            var imgPathStr = decodeURIComponent(str)

            var base64Data = new Uint8Array(base64Len)
            for (var i = 0; i < base64Len; i++) {
              base64Data[i] = rDataArr[9 + imgpathLen + i]
            }
            var base64Str = Uint8ArrayToString(base64Data)

            callback('GetCaptrueImgResultCB', [flag, imgPathStr, base64Str])
          }

          // 身份证信息返回
          if (rDataArr[2] == 0x80) {
            var flag
            if (rDataArr[3] == 0x01) {
              flag = 0
            }
            if (rDataArr[3] == 0x02) {
              flag = 2
            }
            var pDataLen = rDataArr.length - 4
            var pData = new Uint8Array(pDataLen)
            for (var i = 0; i < pDataLen; i++) {
              pData[i] = rDataArr[4 + i]
            }
            var str = byteToString(pData)
            var AllInfoStr = decodeURIComponent(str)
            var resultStr = new Array()
            resultStr = AllInfoStr.split(';')
            // console.log(resultStr);
            callback('GetIdCardInfoResultCB', [flag, resultStr[0], resultStr[1], resultStr[2], resultStr[3], resultStr[4], resultStr[5], resultStr[6], resultStr[7], resultStr[8], resultStr[9]])
          }

          // 摄像头数据
          if (rDataArr[2] == 0xcc) {
            var ww = rDataArr[3] * 256 + rDataArr[4]
            var hh = rDataArr[5] * 256 + rDataArr[6]
            pMainShowStartX = rDataArr[7] * 256 + rDataArr[8]
            pMainShowStartY = rDataArr[9] * 256 + rDataArr[10]
            MainContext.clearRect(0, 0, MainCanvas.width, MainCanvas.height)
            var imgData = MainContext.createImageData(ww, hh)
            var dataNum = 0
            dataNum = dataNum + 11
            for (var i = 0; i < imgData.data.length; i += 4) {
              imgData.data[i + 0] = rDataArr[dataNum]
              imgData.data[i + 1] = rDataArr[dataNum + 1]
              imgData.data[i + 2] = rDataArr[dataNum + 2]
              imgData.data[i + 3] = 255
              dataNum = dataNum + 3
            }
            MainContext.putImageData(imgData, pMainShowStartX, pMainShowStartY)

            if (MainCamCutMode == 1) {
              MainContext.strokeStyle = 'red' // 设置线条的颜色
              MainContext.lineWidth = 2 // 设置线条的宽度
              MainContext.beginPath() // 绘制直线
              MainContext.rect(pALastX, pALastY, (pACurrentX - pALastX), (pACurrentY - pALastY))
              MainContext.closePath()
              MainContext.stroke()
            }
          }
        }
      }
    }
  } catch (ex) {
    callback('error', '异常错误!')
  }
}
