import axios from '@/libs/api.request'

// 时间转换为日期-> 2019-02-02
export function date2str (date, containtime) {
  if (!date || typeof date === 'string') {
    return date
  }
  var time1 = date.getFullYear()
  var month = date.getMonth() + 1
  var day = date.getDate()
  time1 += '-' + (month < 10 ? '0' + month : month)
  time1 += '-' + (day < 10 ? '0' + day : day)
  return time1
}
export function date0str (date, containtime) {
  if (!date || typeof date === 'string') {
    return date
  }
  var time1 = date.getFullYear()
  var month = date.getMonth() + 1
  var day = date.getDate()
  var hour = date.getHours()
  var min = date.getMinutes()
  time1 += '-' + (month < 10 ? '0' + month : month)
  time1 += '-' + (day < 10 ? '0' + day : day)
  time1 += ' ' + (hour < 10 ? '0' + hour : hour)
  time1 += ':' + (min < 10 ? '0' + min : min)
  return time1
}
// 身份证号获取用户信息
export const userinfo = (cardno) => {
  return axios.request({
    // url: '/api/as/csc/user/getuserinfobycardno',
    // url: '/api/ac/csc/userRegisterService/desensitization',
    url: '/api/ac/grid/userRegisterForCSCService/desensitization',
    method: 'post',
    data: {
      'cardno': cardno
    }
  })
}
// 注册用户信息
export const createuser = (param) => {
  return axios.request({
    // url: '/api/ac/csc/userRegisterService/createUser',
    url: '/api/ac/grid/userRegisterForCSCService/createUser',
    method: 'post',
    data: param
  })
}
export const getFocusGroupList = (param) => {
  return axios.request({
    // url: '/api/ac/csc/userRegisterService/createUser',
    url: '/api/ac/grid/userRegisterForCSCService/getFocusGroupList',
    method: 'post',
    data: param
  })
}
// 识别市民码
export const distinguishSstErCode = (param) => {
  return axios.request({
    url: '/api/ac/csc/tosstservice/distinguishSstErCode',
    method: 'post',
    data: param
  })
}
// 柱状图表数据
export const orderWorkCountList = () => {
  return axios.request({
    url: '/api/as/csc/auditorder/getOrderWorkCountList',
    method: 'get'
  })
}
// 政务通知公告列表
export const releaseNoticeList = (param) => {
  return axios.request({
    url: '/api/as/csc/auditnotice/releaseNoticeList',
    method: 'post',
    data: param
  })
}
// 公共测试通知公告列表
export const csPubReleaseNoticeList = (param) => {
  return axios.request({
    url: 'http://iviewpub.tripln.top/api/as/csc/auditnotice/releaseNoticeList',
    method: 'post',
    data: param
  })
}
// 公共生产通知公告列表
export const scPubReleaseNoticeList = (param) => {
  return axios.request({
    url: 'http://qstb.mzj.shenyang.gov.cn/api/as/csc/auditnotice/releaseNoticeList',
    method: 'post',
    data: param
  })
}
// 根据身份证获取用户的头像
export const getUserPhoto = (cardno) => {
  return axios.request({
    url: '/api/as/csc/user/getUserPhoto',
    method: 'get',
    params: { cardno: cardno }
  })
}

// 可办理的事项列表
export const itemtodolist = (param) => {
  return axios.request({
    url: '/api/ac/csc/auditItemService/todolist',
    method: 'post',
    data: param
  })
}
// 可办理的事项列表
export const itemtodolistForCSC = (param) => {
  return axios.request({
    url: '/api/ac/csc/auditItemService/todolistForCSC',
    method: 'post',
    data: param
  })
}
// 用户订单列表
export const userOrderList = (cardno) => {
  return axios.request({
    url: '/api/as/csc/auditorder/getSimOrderList',
    method: 'get',
    params: { cardno: cardno }
  })
}
// 完善信息-小区|组
export const getgrouplist = (param) => {
  return axios.request({
    url: '/api/as/csc/auditmail/getgrouplist',
    method: 'post',
    data: param
  })
}
// 完善信息-楼,层,户
export const getdownlist = (param) => {
  return axios.request({
    url: '/api/as/csc/auditmailfloor/getdownlist',
    method: 'post',
    data: param
  })
}
