export default {
  errcode: 0,
  data: {
    list: [
      {
        path: '/login',
        name: 'login',
        meta: {
          title: 'Login - 登录',
          hideInMenu: true
        }
      },
      {
        path: '/',
        name: '_home',
        redirect: '/home',
        meta: {
          hideInMenu: true,
          notCache: true
        },
        children: [
          {
            path: '/home',
            name: 'home',
            meta: {
              hideInMenu: true,
              title: '首页',
              notCache: true,
              icon: 'md-home'
            }
          }
        ]
      },
      {
        path: '',
        name: 'doc',
        meta: {
          title: '文档',
          href: 'https://lison16.github.io/iview-admin-doc/#/',
          icon: 'ios-book'
        }
      },
      {
        path: '/join',
        name: 'join',
        meta: {
          hideInBread: true
        },
        children: [
          {
            path: 'join_page',
            name: 'join_page',
            meta: {
              icon: '_qq',
              title: 'QQ群111'
            }
          }
        ]
      },
      {
        path: '/message',
        name: 'message',
        meta: {
          hideInBread: true,
          hideInMenu: true
        },
        children: [
          {
            path: 'message_page',
            name: 'message_page',
            meta: {
              icon: 'md-notifications',
              title: '消息中心'
            }
          }
        ]
      },
      {
        path: '/components',
        name: 'components',
        meta: {
          icon: 'logo-buffer',
          title: '组件'
        },
        children: [
          {
            path: 'tree_select_page',
            name: 'tree_select_page',
            meta: {
              icon: 'md-arrow-dropdown-circle',
              title: '树状下拉选择器'
            }
          },
          {
            path: 'count_to_page',
            name: 'count_to_page',
            meta: {
              icon: 'md-trending-up',
              title: '数字渐变'
            }
          },
          {
            path: 'drag_list_page',
            name: 'drag_list_page',
            meta: {
              icon: 'ios-infinite',
              title: '拖拽列表'
            }
          },
          {
            path: 'drag_drawer_page',
            name: 'drag_drawer_page',
            meta: {
              icon: 'md-list',
              title: '可拖拽抽屉'
            }
          },
          {
            path: 'org_tree_page',
            name: 'org_tree_page',
            meta: {
              icon: 'ios-people',
              title: '组织结构树'
            }
          },
          {
            path: 'tree_table_page',
            name: 'tree_table_page',
            meta: {
              icon: 'md-git-branch',
              title: '树状表格'
            }
          },
          {
            path: 'cropper_page',
            name: 'cropper_page',
            meta: {
              icon: 'md-crop',
              title: '图片裁剪'
            }
          },
          {
            path: 'tables_page',
            name: 'tables_page',
            meta: {
              icon: 'md-grid',
              title: '多功能表格'
            }
          },
          {
            path: 'split_pane_page',
            name: 'split_pane_page',
            meta: {
              icon: 'md-pause',
              title: '分割窗口'
            }
          },
          {
            path: 'markdown_page',
            name: 'markdown_page',
            meta: {
              icon: 'logo-markdown',
              title: 'Markdown编辑器'
            }
          },
          {
            path: 'editor_page',
            name: 'editor_page',
            meta: {
              icon: 'ios-create',
              title: '富文本编辑器'
            }
          },
          {
            path: 'icons_page',
            name: 'icons_page',
            meta: {
              icon: '_bear',
              title: '自定义图标'
            }
          }
        ]
      },
      {
        path: '/update',
        name: 'update',
        meta: {
          icon: 'md-cloud-upload',
          title: '数据上传'
        },
        children: [
          {
            path: 'update_table_page',
            name: 'update_table_page',
            meta: {
              icon: 'ios-document',
              title: '上传Csv'
            }
          },
          {
            path: 'update_paste_page',
            name: 'update_paste_page',
            meta: {
              icon: 'md-clipboard',
              title: '粘贴表格数据'
            }
          }
        ]
      },
      {
        path: '/excel',
        name: 'excel',
        meta: {
          icon: 'ios-stats',
          title: 'EXCEL导入导出'
        },
        children: [
          {
            path: 'upload-excel',
            name: 'upload-excel',
            meta: {
              icon: 'md-add',
              title: '导入EXCEL'
            }
          },
          {
            path: 'export-excel',
            name: 'export-excel',
            meta: {
              icon: 'md-download',
              title: '导出EXCEL'
            }
          }
        ]
      },
      {
        path: '/tools_methods',
        name: 'tools_methods',
        meta: {
          hideInBread: true
        },
        children: [
          {
            path: 'tools_methods_page',
            name: 'tools_methods_page',
            meta: {
              icon: 'ios-hammer',
              title: '工具方法',
              beforeCloseName: 'before_close_normal'
            }
          }
        ]
      },
      {
        path: '/i18n',
        name: 'i18n',
        meta: {
          hideInBread: true
        },
        children: [
          {
            path: 'i18n_page',
            name: 'i18n_page',
            meta: {
              icon: 'md-planet',
              title: 'i18n - {{ i18n_page }}'
            }
          }
        ]
      },
      {
        path: '/error_store',
        name: 'error_store',
        meta: {
          hideInBread: true
        },
        children: [
          {
            path: 'error_store_page',
            name: 'error_store_page',
            meta: {
              icon: 'ios-bug',
              title: '错误收集'
            }
          }
        ]
      },
      {
        path: '/error_logger',
        name: 'error_logger',
        meta: {
          hideInBread: true,
          hideInMenu: true
        },
        children: [
          {
            path: 'error_logger_page',
            name: 'error_logger_page',
            meta: {
              icon: 'ios-bug',
              title: '错误收集'
            }
          }
        ]
      },
      {
        path: '/directive',
        name: 'directive',
        meta: {
          hideInBread: true
        },
        children: [
          {
            path: 'directive_page',
            name: 'directive_page',
            meta: {
              icon: 'ios-navigate',
              title: '指令'
            }
          }
        ]
      },
      {
        path: '/multilevel',
        name: 'multilevel',
        meta: {
          icon: 'md-menu',
          title: '多级菜单'
        },
        children: [
          {
            path: 'level_2_1',
            name: 'level_2_1',
            meta: {
              icon: 'md-funnel',
              title: '二级-122'
            }
          },
          {
            path: 'level_2_2',
            name: 'level_2_2',
            meta: {
              access: ['admin'],
              icon: 'md-funnel',
              showAlways: true,
              title: '二级-2111'
            },
            children: [
              {
                path: 'level_2_2_1',
                name: 'level_2_2_1',
                meta: {
                  icon: 'md-funnel',
                  title: '三级'
                }
              },
              {
                path: 'level_2_2_2',
                name: 'level_2_2_2',
                meta: {
                  icon: 'md-funnel',
                  title: '三级'
                }
              }
            ]
          },
          {
            path: 'level_2_3',
            name: 'level_2_3',
            meta: {
              icon: 'md-funnel',
              title: '二级-3'
            }
          }
        ]
      },
      {
        path: '/argu',
        name: 'argu',
        meta: {
          hideInMenu: true
        },
        children: [
          {
            path: 'params/:id',
            name: 'params',
            meta: {
              icon: 'md-flower',
              notCache: true,
              beforeCloseName: 'before_close_normal'
            }
          },
          {
            path: 'query',
            name: 'query',
            meta: {
              icon: 'md-flower',
              notCache: true
            }
          }
        ]
      },
      {
        path: '/401',
        name: 'error_401',
        meta: {
          hideInMenu: true
        }
      },
      {
        path: '/500',
        name: 'error_500',
        meta: {
          hideInMenu: true
        }
      },
      {
        path: '*',
        name: 'error_404',
        meta: {
          hideInMenu: true
        }
      },
      {
        path: '/hddemo',
        name: 'hddemo',
        meta: {
          hideInBread: false,
          title: '慧鼎demo'
        },
        children: [
          {
            path: 'face',
            name: 'face',
            meta: {
              icon: '_qq',
              title: '人脸识别'
            }
          },
          {
            path: 'camera',
            name: 'camera',
            meta: {
              icon: '_qq',
              title: '高拍仪demo'
            }
          },
          {
            path: 'camera2',
            name: 'camera2',
            meta: {
              icon: '_qq',
              title: '捷宇高拍仪demo'
            }
          },
          {
            path: 'idcard',
            name: 'idcard',
            meta: {
              icon: '_qq',
              title: '身份证读取'
            }
          },
          {
            path: 'layim',
            name: 'layim',
            meta: {
              icon: '_qq',
              title: '聊天功能'
            }
          },
          {
            path: 'print',
            name: 'print',
            meta: {
              icon: '_qq',
              title: '打印demo'
            }
          }
        ]
      },
      {
        path: 'goods',
        name: 'goods',
        meta: {
          icon: '_qq',
          title: '测试页面222'
        }
      },
      {
        path: 'gridlist',
        name: 'gridlist',
        meta: {
          icon: '_qq',
          title: '网格列表'
        }
      }
    ]
  }
}
