const path = require('path')

const resolve = dir => {
  return path.join(__dirname, dir)
}

// 项目部署基础
// 默认情况下，我们假设你的应用将被部署在域的根目录下,
// 例如：https://www.my-app.com/
// 默认：'/'
// 如果您的应用程序部署在子路径中，则需要在这指定子路径
// 例如：https://www.foobar.com/my-app/
// 需要将它改为'/my-app/'
// iview-admin线上演示打包路径： https://file.iviewui.com/admin-dist/
const BASE_URL = process.env.NODE_ENV === 'production'
  ? '/'
  // ? '/zfw-contradiction/'
  : '/'

module.exports = {
  // Project deployment base
  // By default we assume your app will be deployed at the root of a domain,
  // e.g. https://www.my-app.com/
  // If your app is deployed at a sub-path, you will need to specify that
  // sub-path here. For example, if your app is deployed at
  // https://www.foobar.com/my-app/
  // then change this to '/my-app/'
  // outputDir: 'dist/zfw-contradiction',
  publicPath: BASE_URL,
  // tweak internal webpack configuration.
  // see https://github.com/vuejs/vue-cli/blob/dev/docs/webpack.md
  // 如果你不需要使用eslint，把lintOnSave设为false即可
  lintOnSave: true,
  chainWebpack: config => {
    config.resolve.alias
      .set('@', resolve('src')) // key,value自行定义，比如.set('@@', resolve('src/components'))
      .set('_c', resolve('src/components'))
  },
  // 打包时不生成.map文件
  productionSourceMap: false,
  // 这里写你调用接口的基础路径，来解决跨域，如果设置了代理，那你本地开发环境的axios的baseUrl要写为 '' ，即空字符串
  // devServer: {
  //   proxy: 'localhost:3000'
  // }
  devServer: {
    // port: 8088,
    proxy: {
      '/Api/Api/': {
        ws: false,
        target: 'https://txy.sylyx.cn',
        // target: 'http://t.hidlq.com',
        changeOrigin: true,
        secure: false
      },
      '/v1/': {
        ws: false,
        target: 'http://csapi.tripln.com',
        // target: 'http://t.hidlq.com'
        changeOrigin: true,
        secure: false
      },
      '/api/': {
        ws: false,
        // target: 'http://10.40.3.212:30384',
        // target: 'http://iview.tripln.top/',
        // target: 'http://qstb.mzj.shenyang.gov.cn',
        // target: 'http://jilinmdjf.lngov.top/',
        // target: 'http://jilinmdjf.lngov.top:8088/',
        // target: 'http://172.16.8.169:8090/zfw-contradiction',
        // target: 'http://jlmdjf.lngov.top/',
        // target: 'http://172.24.25.37:8088/',
        // target: 'http://jilintest.lngov.top/',
        // target: 'http://36.135.8.40:8088',
        // target: 'http://192.168.3.254:8083/',
        target: 'http://localhost:8081/',
        changeOrigin: true,
        secure: false
      },
      '/manager/': {
        ws: false,
        target: 'http://iview.tripln.top/',
        // target: 'http://qstb.mzj.shenyang.gov.cn',
        // target: 'http://t.hidlq.com',
        changeOrigin: true,
        secure: false
      },
      '/mock/': {
        ws: false,
        target: 'http://localhost:8080',
        // target: 'http://t.hidlq.com',
        changeOrigin: true,
        secure: false
      }

    }
  }

}
