package com.scpyun.platform.jilinsscgsdp.enums;

import com.scpyun.base.core.exception.CustomException;

public enum FamilyRelationshipEnum {

    HOUSEHOLDER(0, "户主"),
    SPOUSE(1, "配偶"),
    CHILD(2, "子女"),
    PARENT(3, "父母"),
    PARENT_IN_LAW(4, "岳父母或公婆"),
    GRANDPARENT(5, "祖父母"),
    SON_DAUGHTER_IN_LAW(6, "媳婿"),
    GRANDCHILD(7, "孙祖女"),
    SIBLING(9, "兄弟姐妹"),
    OTHER(10, "其他");

    private final int code;
    private final String description;

    FamilyRelationshipEnum(int code, String description) {
        this.code = code;
        this.description = description;
    }

    public int getCode() {
        return code;
    }

    public String getDescription() {
        return description;
    }

    public static FamilyRelationshipEnum fromCode(int code) {
        for (FamilyRelationshipEnum relationship : values()) {
            if (relationship.code == code) {
                return relationship;
            }
        }
        throw new CustomException("与户主关系.未知的关系编码: " + code);
    }

    public static FamilyRelationshipEnum fromDescription(String description) {
        for (FamilyRelationshipEnum relationship : values()) {
            if (relationship.description.equals(description)) {
                return relationship;
            }
        }
        throw new CustomException("与户主关系,未知的关系描述: " + description);
    }
}
