package com.scpyun.platform.jilinsscgsdp.utils;

import com.scpyun.base.core.utils.UnifyLogger;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
/**
 *
 * @Title:  DisposeRedisStatisticsUtil
 * @Package DisposeRedisStatisticsUtil.java
 * @Description: copy By scp-grid
 * @author:  guojiucoder
 * @date:   2024/7/31 14:09
 * @version V1.0.0
 *
 */
public class DisposeRedisStatisticsUtil {
	
	private static final String key_begin="shenyang.qstb.grid.";
	private static final String redis="redisgrid";
	
	public Map<String, String> getStatisticsInfo(String id,Statistics statistics) {
	        return statistics.getStatistics(id);
	}
	 
	public Map<String, String> getRedisInfo(String key_end,String id){
		String key = key_begin+key_end+"_"+id;
		UnifyLogger.parent("redisKey====="+key,UnifyLogger.Level.INFO);
		return RedisTemplateUtils.getMap(key,redis); 
	}
	public void setRedisInfo(String key_end,String id,Map<String, String> map){
		Date day=new Date();
		SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		String timeString=df.format(day);
		map.put("time", timeString);
		RedisTemplateUtils.setMap(key_begin+key_end+"_"+id,map,60*1000*60,redis);
	}

}
