package com.scpyun.platform.jilinsscgsdp.bean.dto;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

/**
 * @program: scp-jilinsscgsdp
 * @ClassName RiskComparison
 * @description: TODO
 * @author: cgh
 * @date: 2025-06-09 14:25
 * @Version 1.0
 **/
public class RiskComparisonDTO {
    // 定义风险类型枚举
    public enum RiskType {
        GROUP_EVENT("群体性事件"),
        RISK_FACTOR("风险因子"),
        STAKEHOLDER("涉众");

        private final String description;

        RiskType(String description) {
            this.description = description;
        }

        public String getDescription() {
            return description;
        }
    }

    // 定义风险等级对象
    public static class RiskLevel {
        private RiskType riskType;
        private int level; // 等级数值，1表示最高，3最低

        public RiskLevel(RiskType riskType, int level) {
            this.riskType = riskType;
            this.level = level;
        }

        public RiskType getRiskType() {
            return riskType;
        }

        public int getLevel() {
            return level;
        }

        @Override
        public String toString() {
            return riskType.getDescription() + " 风险等级：" + level;
        }
    }


    /**
     * 找出最高风险等级的对象
     */
    public static List<RiskLevel> findHighestRisk(List<RiskLevel> risks) {
        if (risks == null || risks.isEmpty()) {
            return Collections.emptyList();
        }

        // 排序：按等级从小到大排序（1最高，3最低）
        risks.sort(Comparator.comparingInt(RiskLevel::getLevel));

        int highestLevel = risks.get(0).getLevel(); // 最小等级值为最高风险
        // 如果最高级别为99 则返回null
        if (highestLevel == 99) {
            return null;
        }

        // 收集所有与最高风险等级相同的项
        List<RiskLevel> result = new ArrayList<>();
        for (RiskLevel risk : risks) {
            if (risk.getLevel() == highestLevel) {
                result.add(risk);
            } else {
                break; // 后续等级更高，无需继续遍历
            }
        }

        return result;
    }
}
