package com.scpyun.platform.jilinsscgsdp.bean.vo.task;


import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Update;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.Pattern;

public class ReqEventFlowLogVo extends ReqBaseVo {
    /**
     * 分派状态 1:正常 2:删除 3:待确认
     */
    @Pattern(regexp = "^$|^[1-3]$", message = "分派状态值必须为1-3", groups = {Insert.class, Update.class})
    private String assignmentType;
    /**
     * 分派处置备注
     */
    private String assignResult;
    /**
     * 分派时间
     */
    private String assignTime;
    /**
     * 退回时间
     */
    private String backTime;
    /**
     * 完成时间
     */
    private String completeTime;
    /**
     * 处置人名称
     */
    @NotEmpty(message = "处置人名称不可为空", groups = {Insert.class, Update.class})
    private String createName;
    /**
     * 风险等级 无 ,一般矛盾纠纷 ,负责矛盾纠纷 ,重大矛盾纠纷
     */
    @NotEmpty(message = "风险等级不可为空", groups = {Insert.class, Update.class})
    private String riskLevel;
    /**
     * 创建时间
     */
    //private String createTime;
    /**
     * 事件id
     */
    @NotEmpty(message = "事件id不可为空", groups = {Insert.class, Update.class})
    private String eventId;
    /**
     * 主键ID
     */
    @NotEmpty(message = "id不可为空", groups = {Insert.class, Update.class})
    private String id;
    /**
     * 是否预警告警 1:未预警告警 2:预警 3:告警
     */
    @Pattern(regexp = "^$|^[1-3]$", message = "是否预警告警值必须为1-3", groups = {Insert.class, Update.class})
    private String isEarlyWarning;
    /**
     * 是否化解 1:是 2:否
     */
    @Pattern(regexp = "^$|^[1-2]$", message = "是否化解值必须为1-2", groups = {Insert.class, Update.class})
    private String isResolve;
    /**
     * 是否满意 1:是 2:否
     */
    @Pattern(regexp = "^$|^[1-2]$", message = "是否满意值必须为1-2", groups = {Insert.class, Update.class})
    private String isSatisfaction;
    /**
     * 处理结果
     */
    private String logResult;
    /**
     * 流程 1上报 2办结 3分派 4退回 5横传
     */
    @NotEmpty(message = "流程不可为空", groups = {Insert.class, Update.class})
    @Pattern(regexp = "^[1-5]$", message = "流程值必须为1-5", groups = {Insert.class, Update.class})
    private String logType;
    /**
     * 处置部门区划编码
     */
    @NotEmpty(message = "处置部门区划编码不可为空", groups = {Insert.class, Update.class})
    private String officeId;
    /**
     * 处置部门名称
     */
    @NotEmpty(message = "处置部门名称不可为空", groups = {Insert.class, Update.class})
    private String officeName;
    /**
     * 受理时间
     */
    private String receiveTime;
    /**
     * 化解层级
     */
    private String resolveHierarchy;
    /**
     * 化解人
     */
    private String resolveName;
    /**
     * 化解过程
     */
    private String resolveProcess;
    /**
     * 化解时间
     */
    private String resolveTime;
    /**
     * 化解人单位
     */
    private String resolveUnit;
    /**
     * 化解方式 1人民调解 2行政调解 3司法调解 4行业调解 5仲裁 6诉讼 7其他
     */
    @Pattern(regexp = "^$|^[1-7]$", message = "化解方式值必须为1-7", groups = {Insert.class, Update.class})
    private String resolveWay;
    /**
     * 预警级别
     */
    private String warningLevel;
    /**
     * 地市对接id
     */
    private String dockingId;
    /**
     * 扫描状态 0:修噶或新增后等待扫描 1:已扫描
     */
    private Integer isScanned;
    /**
     * 扫描时间
     */
    private String scanningTime;

    @NotEmpty(message = "appid不可为空", groups = {Insert.class, Update.class})
    private String appid;
    /**
     * 添加状态
     */
    private String type;
    /**
     * 操作状态 1成功 2失败
     */
    private String operateType;
    private String status;
    /**
     * 是否是分派、横传的处置部门0：否，1：是
     */
    @NotEmpty(message = "是否是分派、横传的处置部门不可为空", groups = {Insert.class, Update.class})
    private String isDispatchOffice;

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getIsDispatchOffice() {
        return isDispatchOffice;
    }

    public void setIsDispatchOffice(String isDispatchOffice) {
        this.isDispatchOffice = isDispatchOffice;
    }

    public String getRiskLevel() {
        return riskLevel;
    }

    public void setRiskLevel(String riskLevel) {
        this.riskLevel = riskLevel;
    }

    public String getAssignmentType() {
        return assignmentType;
    }

    public void setAssignmentType(String assignmentType) {
        this.assignmentType = assignmentType;
    }

    public String getAssignResult() {
        return assignResult;
    }

    public void setAssignResult(String assignResult) {
        this.assignResult = assignResult;
    }

    public String getAssignTime() {
        return assignTime;
    }

    public void setAssignTime(String assignTime) {
        this.assignTime = assignTime;
    }

    public String getBackTime() {
        return backTime;
    }

    public void setBackTime(String backTime) {
        this.backTime = backTime;
    }

    public String getCompleteTime() {
        return completeTime;
    }

    public void setCompleteTime(String completeTime) {
        this.completeTime = completeTime;
    }

    public String getCreateName() {
        return createName;
    }

    public void setCreateName(String createName) {
        this.createName = createName;
    }
    
    public String getEventId() {
        return eventId;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getIsEarlyWarning() {
        return isEarlyWarning;
    }

    public void setIsEarlyWarning(String isEarlyWarning) {
        this.isEarlyWarning = isEarlyWarning;
    }

    public String getIsResolve() {
        return isResolve;
    }

    public void setIsResolve(String isResolve) {
        this.isResolve = isResolve;
    }

    public String getIsSatisfaction() {
        return isSatisfaction;
    }

    public void setIsSatisfaction(String isSatisfaction) {
        this.isSatisfaction = isSatisfaction;
    }

    public String getLogResult() {
        return logResult;
    }

    public void setLogResult(String logResult) {
        this.logResult = logResult;
    }

    public String getLogType() {
        return logType;
    }

    public void setLogType(String logType) {
        this.logType = logType;
    }

    public String getOfficeId() {
        return officeId;
    }

    public void setOfficeId(String officeId) {
        this.officeId = officeId;
    }

    public String getOfficeName() {
        return officeName;
    }

    public void setOfficeName(String officeName) {
        this.officeName = officeName;
    }

    public String getReceiveTime() {
        return receiveTime;
    }

    public void setReceiveTime(String receiveTime) {
        this.receiveTime = receiveTime;
    }

    public String getResolveHierarchy() {
        return resolveHierarchy;
    }

    public void setResolveHierarchy(String resolveHierarchy) {
        this.resolveHierarchy = resolveHierarchy;
    }

    public String getResolveName() {
        return resolveName;
    }

    public void setResolveName(String resolveName) {
        this.resolveName = resolveName;
    }

    public String getResolveProcess() {
        return resolveProcess;
    }

    public void setResolveProcess(String resolveProcess) {
        this.resolveProcess = resolveProcess;
    }

    public String getResolveTime() {
        return resolveTime;
    }

    public void setResolveTime(String resolveTime) {
        this.resolveTime = resolveTime;
    }

    public String getResolveUnit() {
        return resolveUnit;
    }

    public void setResolveUnit(String resolveUnit) {
        this.resolveUnit = resolveUnit;
    }

    public String getResolveWay() {
        return resolveWay;
    }

    public void setResolveWay(String resolveWay) {
        this.resolveWay = resolveWay;
    }

    public String getWarningLevel() {
        return warningLevel;
    }

    public void setWarningLevel(String warningLevel) {
        this.warningLevel = warningLevel;
    }

    public String getDockingId() {
        return dockingId;
    }

    public void setDockingId(String dockingId) {
        this.dockingId = dockingId;
    }

    public Integer getIsScanned() {
        return isScanned;
    }

    public void setIsScanned(Integer isScanned) {
        this.isScanned = isScanned;
    }

    public String getScanningTime() {
        return scanningTime;
    }

    public void setScanningTime(String scanningTime) {
        this.scanningTime = scanningTime;
    }

    public String getAppid() {
        return appid;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getOperateType() {
        return operateType;
    }

    public void setOperateType(String operateType) {
        this.operateType = operateType;
    }
}
