package com.scpyun.platform.jilinsscgsdp.service.impl;

import com.scpyun.base.core.annotation.Api;
import com.scpyun.base.core.annotation.ApiOperation;
import com.scpyun.base.core.exception.CustomException;
import com.scpyun.base.core.utils.DataSourceSwitcher;
import com.scpyun.base.core.utils.StringUtils;
import com.scpyun.base.db.service.CommonService;

import cn.hutool.core.map.MapUtil;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

@Api("模块选择")
@Service("gridModuleServiceImpl")
public class GridModuleServiceImpl {
	
	@Autowired
	CommonService commonService;
	
	private final String sys_office_namespace = "com.scpyun.platform.standard.jilinsscgsdp.sysOfficeinfo.";
	private final String module_nameSpace = "com.scpyun.platform.standard.jilinsscgsdp.gridModule.";
    private final String user_nameSpace = "com.scpyun.platform.standard.jilinsscgsdp.user.";
	
	@ApiOperation(desc = "查询层户搭配选择模块",value = "查询层户搭配选择模块")
	public List<Map<String, Object>> findFloorDoorplateList(Map<String, Object> map) {
    	DataSourceSwitcher.setMaster();
    	//DataSourceSwitcher.setShardingSphere("ShardingDataSource");
    	Map cityInfo = commonService.getObject(module_nameSpace+"getCityIdFromUnit", map);
    	map.putAll(cityInfo);
		List<Map<String, Object>> modulePeopleList = commonService.findList(module_nameSpace + "findModulePeopleList", map);
		List<Map<String, Object>> doorplatePeopleNumList = commonService.findList(module_nameSpace + "findDoorplatePeopleNumList", map);
		List<Map<String, Object>> list = commonService.findList(sys_office_namespace + "findUnitXJList", map);
		if (list.size() != 0) {
			for (Map<String, Object> aMap : list) {
				map.put("floor_id", aMap.get("id"));
				List<Map<String, Object>> doorplateList = commonService.findList(sys_office_namespace + "findFloorXJList", map);
				for (Map<String, Object> bMap : doorplateList) {
					// 标签图标
					for (Map<String, Object> cMap : modulePeopleList) {
						String id = StringUtils.toString(bMap.get("id"));
						String doorplate_id = StringUtils.toString(cMap.get("doorplate_id"));
						if (id.equals(doorplate_id)) {
							bMap.put("module", "1");
							break;
						}
					}
					// 空户图标
					for (Map<String, Object> dMap : doorplatePeopleNumList) {
						String id = StringUtils.toString(bMap.get("id"));
						String doorplate_id = StringUtils.toString(dMap.get("doorplate_id"));
						if (id.equals(doorplate_id)) {
							bMap.put("doorplate_people_num", dMap.get("num"));
							break;
						}
					}
					// 走访日志图标
//					for (Map<String,Object> eMap : InterviewLogList){
//						String id = StringUtils.toString(bMap.get("id"));
//						String doorplate_id = StringUtils.toString(eMap.get("doorplate_id"));
//						if (id.equals(doorplate_id)) {
//							bMap.put("InterviewLog_type", "1");
//							break;
//						}
//					}
				}
				aMap.put("children", doorplateList);
			}
			return list;
		} else {
			return new ArrayList<Map<String, Object>>();
		}
	}
	
	@ApiOperation(desc = "查询层户人员列表(分表)",value = "查询层户人员列表(分表)")
	public List<Map<String, Object>> findModuleUserList(Map<String, Object> map) {
		DataSourceSwitcher.setMaster();
    	//DataSourceSwitcher.setShardingSphere("ShardingDataSource");
    	Map cityInfo = commonService.getObject(module_nameSpace+"getCityIdFromUnitOrBuildingOrDoorplate", map);
    	map.putAll(cityInfo);
		List<Map<String, Object>> userList = commonService.findList(module_nameSpace + "findModuleUserList", map);
		userList.stream().forEach(item->{
			item.putAll(commonService.getObject(user_nameSpace+"decryptStr", item.get("cardno")));
		});
		return userList;
	}
	
	
	
	@ApiOperation(desc = "查询本户人员",value = "查询本户人员")
	public List<Map<String, Object>> findDoorplatePeopleList(Map<String, Object> map){
		DataSourceSwitcher.setMaster();
    	//DataSourceSwitcher.setShardingSphere("ShardingDataSource");
    	Map cityInfo = commonService.getObject(module_nameSpace+"getCityIdFromUnitOrBuildingOrDoorplate", map);
    	map.putAll(cityInfo);
		List<Map<String, Object>> peopleList = commonService.findList(module_nameSpace+"findDoorplatePeopleList", map);
		if(!(StringUtils.isEmpty(map.get("first_level_id")) && StringUtils.isEmpty(map.get("second_level_id")))){
			List<Map<String, Object>> modulePeopleList = new ArrayList<Map<String,Object>>();
			if("L000".equals(map.get("first_level_id"))) {
				modulePeopleList = commonService.findList(module_nameSpace+"findModuleDoorplatePeopleYQList", map);
			}else {
				modulePeopleList = commonService.findList(module_nameSpace+"findModuleDoorplatePeopleList", map);
			}
			if(peopleList.size() > 0 && modulePeopleList.size() > 0) {
				for (Map<String, Object> aMap : peopleList) {
					for (Map<String, Object> bMap : modulePeopleList) {
						if(StringUtils.toString(aMap.get("id")).equals(StringUtils.toString(bMap.get("id")))) {
							aMap.put("module", "1");
							break;
						}
					}
				}
			}
		}else{
			List<Map<String,Object>> labelList = commonService.findList(module_nameSpace + "findDoorplatePeopleLabelList",map);
			if(peopleList.size() > 0 && labelList.size() > 0){
				for (Map<String, Object> aMap : peopleList) {
					List<Map<String,Object>> children = new ArrayList<Map<String, Object>>();
					for (Map<String,Object> bMap : labelList){
						if(StringUtils.toString(aMap.get("cardno")).equals(StringUtils.toString(bMap.get("cardno")))){
							children.add(bMap);
						}
					}
					aMap.put("children",children);
				}
			}
		}
		peopleList.stream().forEach(item->{
			Map<String,Object> mapUserInfo=commonService.getObject(user_nameSpace+"decryptStr", item.get("cardno"));
			item.putAll(mapUserInfo);
		});
		return peopleList;
	}
	
	@ApiOperation(desc = "查询本户人员详细",value = "查询本户人员详细")
	public Map<String, Object> getUserInfoByCardNo(Map<String, Object> map){
    	DataSourceSwitcher.setMaster();
    	//DataSourceSwitcher.setShardingSphere("ShardingDataSource");
        Map<String, Object> user = commonService.getObject(user_nameSpace + "getGridUserByCardNo", map);
        if(user==null) {
        	throw new CustomException("未查询到人员");
        }
        Map<String,Object> mapUserInfo=commonService.getObject(user_nameSpace+"decryptStr", user.get("cardno"));
        String cardno = MapUtil.getStr(mapUserInfo,"cardno");
        user.putAll(mapUserInfo);
        user.put("mobile", user.get("tel"));
        user.put("name", user.get("user_name"));
        return user;
        
	}	
	@ApiOperation(value = "查询模块",desc = "查询模块")
	public List<Map<String, Object>> findModuleList(Map<String, Object> map){
		
		List<Map<String, Object>> returnList = new ArrayList<Map<String,Object>>();
		List<Map<String, Object>> list = commonService.findList(module_nameSpace+"findModuleList", map);
		for (Map<String, Object> aMap : list) {
			Map<String, Object> bMap = new LinkedHashMap<String, Object>();
			if("0".equals(aMap.get("pid"))) {
				bMap.putAll(aMap);
				bMap.put("expand", true);
				if(StringUtils.isEmpty(bMap.get("second_level_id"))) {
				bMap.put("disabled", true);
			}
				bMap.put("children", findModuleChildrenList(list, aMap, map)); 
				returnList.add(bMap);
			}
		}
		return returnList;
	}
	public List<Map<String, Object>> findModuleChildrenList(List<Map<String,Object>> list,Map<String, Object> map,Map<String, Object> pMap){
		List<Map<String, Object>> returnList = new ArrayList<Map<String,Object>>();
		for (Map<String, Object> aMap : list) {
			Map<String, Object> bMap = new LinkedHashMap<String, Object>();
			if(map.get("id").equals(aMap.get("pid"))) {
				bMap.putAll(aMap);
				bMap.put("expand", true);
				if(StringUtils.isEmpty(bMap.get("second_level_id"))) {
					bMap.put("disabled", true);
				}
				if("2".equals(bMap.get("type_level")) && !StringUtils.isEmpty(pMap.get("building_id")) && "0".equals(bMap.get("is_click"))) {
					Map<String, Object> ttMap = new HashMap<String, Object>();
					ttMap.put("building_id",pMap.get("building_id"));
					ttMap.put("first_level_id", bMap.get("first_level_id"));
					ttMap.put("second_level_id", bMap.get("second_level_id"));
					Map<String, Object> resultMap = commonService.getObject(module_nameSpace+"getFocusGroupUserNum", ttMap);
					bMap.put("focusgroupUserNum", resultMap.get("num"));
				}
				bMap.put("children", findModuleChildrenList(list, aMap, pMap));
				returnList.add(bMap);
			}
		}
		return returnList;
	}

	@ApiOperation(value = "查询类型",desc = "查询类型")
	public List<Map<String,Object>> findGridTypeList (Map<String,Object> map) {
		List<Map<String,Object>> returnList = new ArrayList<>();
		List<Map<String,Object>> list = commonService.findList(module_nameSpace + "findGridTypeList", map);
		for (Map<String,Object> typeMap: list) {
			Map<String,Object> aMap = new LinkedHashMap<>();
			if ("0".equals(typeMap.get("pid").toString())) {
				aMap.putAll(typeMap);
				aMap.put("expand", true);
				aMap.put("children", findGridTypeChildrenList(list, typeMap));
				returnList.add(aMap);
			}
		}
		return returnList;
	}

	public List<Map<String,Object>> findGridTypeChildrenList (List<Map<String,Object>> list, Map<String,Object> typeMap) {
		List<Map<String,Object>> returnList = new ArrayList<>();
		for (Map<String,Object> aMap: list){
			Map<String,Object> bMap = new LinkedHashMap<>();
			if (typeMap.get("id").equals(aMap.get("pid"))) {
				bMap.putAll(aMap);
				bMap.put("expand", true);
				bMap.put("children", findGridTypeChildrenList(list, aMap));
				returnList.add(bMap);
			}
		}

		return returnList;
	}
	@ApiOperation(value = "查询类型",desc = "查询类型")
	public String addGridType (Map<String,Object> map) {
		if (StringUtils.isEmpty(map.get("pid"))) {
			throw new CustomException("缺少父级id！");
		}
		if (StringUtils.isEmpty(map.get("name"))) {
			throw new CustomException("缺少类型名称！");
		}
		Map<String,Object> countMap = commonService.getObject(module_nameSpace + "findGridTypeInfo", map);
		String id = map.get("pid").toString() + "-" + countMap.get("count").toString();
		map.put("id", id);
		if (commonService.insert(module_nameSpace + "addGridType", map) == 0) {
			throw new CustomException("添加失败！");
		}
		return "1";
	}

	@ApiOperation(value = "查询类型",desc = "查询类型")
	public String updateGridType (Map<String,Object> map) {
		if (StringUtils.isEmpty(map.get("name"))) {
			throw new CustomException("缺少类型名称！");
		}
		if (commonService.insert(module_nameSpace + "updateGridType", map) == 0) {
			throw new CustomException("修改失败！");
		}
		return "1";
	}
}
