package com.scpyun.base.core.utils;

import com.scpyun.base.core.bean.JedisType;

import java.util.List;
import java.util.Map;
import java.util.Set;

public class JedisSentinelUtils {


    public static final String KEY_PREFIX = "juyou";

    /**
     * redis过期时间,以秒为单位
     */
    public final static int HALF_HOUR = 30*60;          //30分钟
    public final static int QUARTER_HOUR = 60*60;       //45分钟
    public final static int EXRP_HOUR = 60*60;          //一小时
    public final static int EXRP_DAY = 60*60*24;        //一天
    public final static int EXRP_MONTH = 60*60*24*30;   //一个月

    //这个 timeout 是到 redis 的连接的超时时间
    private static final int TIMEOUT = 30*60;


    /**
     * redis 是否被实例化
     * @return
     */
    public static boolean exist(){
//		if( == null){
//			return true;
//		}else{
//			return false;
//		}
        return false;
    }

    /**
     * 是否使用了redis
     * @return true:未使用，false:已使用
     */
    public static boolean useRedis(){
        if (JedisImplUtils.SENTINEL_ONLY.equals("true")) {
            return false;
        } else {
            return StringUtils.isEmpty(Global.getConfig("scp.redis.host"));
        }
    }


    /**
     * 获取缓存
     * @param key 键
     * @return 值
     */
    public static String get(String key) {
        if(useRedis()){
            return JedisEhcacheUtils.get(key, String.class);
        } else {
            return JedisSentinelImplUtils.get(key);
        }
    }

    public static String get(String key, JedisType jedisType) {
        if(useRedis()){
            return JedisEhcacheUtils.get(key, String.class);
        } else {
            return JedisSentinelImplUtils.get(key, jedisType);
        }
    }


    /**
     * 获取缓存-半成品
     * @param key 键
     * @return 值
     */
    public static byte[] get(byte[] key) {
        if(useRedis()){
            return JedisEhcacheUtils.get(key);
        } else {
            return JedisSentinelImplUtils.get(key);
        }
    }


    /**
     * 获取缓存
     * @param key 键
     * @return 值
     */
    public static Object getObject(String key) {
        if(useRedis()){
            return JedisEhcacheUtils.get(key, Object.class);
        } else {
            return JedisSentinelImplUtils.getObject(key);
        }
    }

    public static Object getObject(String key, Enum jedisType) {
        if(useRedis()){
            return JedisEhcacheUtils.get(key, Object.class);
        } else {
            return JedisSentinelImplUtils.getObject(key, jedisType);
        }
    }


    /**
     * 获取缓存
     * @param key 键
     * @param index db_index键
     * @return 值
     */
    public static Object getObject(String key,int index) {
        if(useRedis()){
            return JedisEhcacheUtils.get(key, Object.class);
        } else {
            return JedisSentinelImplUtils.getObject(key, index);
        }
    }


    /**
     * 设置缓存
     * @param key 键
     * @param value 值
     * @param cacheSeconds 超时时间，0为不超时
     * @return
     */
    public static String set(String key, String value, int cacheSeconds) {
        if(useRedis()){
            return JedisEhcacheUtils.set(key, value, cacheSeconds);
        } else {
            return JedisSentinelImplUtils.set(key, value, cacheSeconds);
        }
    }

    public static String set(String key, String value, int cacheSeconds, JedisType jedisType) {
        if(useRedis()){
            return JedisEhcacheUtils.set(key, value, cacheSeconds);
        } else {
            return JedisSentinelImplUtils.set(key, value, cacheSeconds, jedisType);
        }
    }

    public static Long zadd(String key,Double score,String member, int cacheSeconds){
        return JedisSentinelImplUtils.zadd(key,score,cacheSeconds,member);
    }


    /**
     * 设置缓存
     * @param key 键
     * @param value 值
     * @param cacheSeconds 超时时间，0为不超时
     * @return
     */
    public static String setObject(String key, Object value, int cacheSeconds) {
        if(useRedis()){
            return JedisEhcacheUtils.set(key, value, cacheSeconds);
        } else {
            return JedisSentinelImplUtils.setObject(key, value, cacheSeconds);
        }
    }

    /**
     * 设置缓存
     * @param key 键
     * @param value 值
     * @param index db_index值
     * @param cacheSeconds 超时时间，0为不超时
     * @return
     */
    public static String setObject(String key, Object value, int cacheSeconds,int index) {
        if(useRedis()){
            return JedisEhcacheUtils.set(key, value, cacheSeconds);
        } else {
            return JedisSentinelImplUtils.setObject(key, value, cacheSeconds, index);
        }
    }


    /**
     * 获取List缓存
     * @param key 键
     * @return 值
     */
    public static List<String> getList(String key) {
        if(useRedis()){
            return JedisEhcacheUtils.getList(key, String.class);
        } else {
            return JedisSentinelImplUtils.getList(key);
        }
    }

    /**
     * 获取List缓存
     * @param key 键
     * @return 值
     */
    public static List<Object> getObjectList(String key) {
        if(useRedis()){
            return JedisEhcacheUtils.getList(key, Object.class);
        } else {
            return JedisSentinelImplUtils.getObjectList(key);
        }
    }

    /**
     * 设置List缓存
     * @param key 键
     * @param value 值
     * @param cacheSeconds 超时时间，0为不超时
     * @return
     */
    public static long setList(String key, List<String> value, int cacheSeconds) {
        if(useRedis()){
            return JedisEhcacheUtils.setList(key, value, cacheSeconds);
        } else {
            return JedisSentinelImplUtils.setList(key, value, cacheSeconds);
        }
    }

    /**
     * 设置List缓存
     * @param key 键
     * @param value 值
     * @param cacheSeconds 超时时间，0为不超时
     * @return
     */
    public static long setObjectList(String key, List<Object> value, int cacheSeconds) {
        if(useRedis()){
            return JedisEhcacheUtils.setList(key, value, cacheSeconds);
        } else {
            return JedisSentinelImplUtils.setObjectList(key, value, cacheSeconds);
        }
    }

    /**
     * 向List缓存中添加值
     * @param key 键
     * @param value 值
     * @return
     */
    public static long listAdd(String key, String... value) {
        if(useRedis()){
            return JedisEhcacheUtils.listAdd(key, value);
        } else {
            return JedisSentinelImplUtils.listAdd(key, value);
        }
    }

    /**
     * 向List缓存中添加值
     * @param key 键
     * @param value 值
     * @return
     */
    public static long listObjectAdd(String key, Object... value) {
        if(useRedis()){
            return JedisEhcacheUtils.listAdd(key, value);
        } else {
            return JedisSentinelImplUtils.listObjectAdd(key, value);
        }
    }

    /**
     * 向List缓存中添加值
     * @param key 键
     * @param value 值
     * @return
     */
    public static long setQueue(String key, String... value) {
        if(useRedis()){
            return JedisEhcacheUtils.setQueue(key, value);
        } else {
            return JedisSentinelImplUtils.setQueue(key, value);
        }
    }

    /**
     * 向List缓存中添加值
     * @param key 键
     * @return
     */
    public static String getQueue(String key) {
        if(useRedis()){
            return JedisEhcacheUtils.getQueue(key);
        } else {
            return JedisSentinelImplUtils.getQueue(key);
        }
    }

    /**
     * 获取缓存
     * @param key 键
     * @return 值
     */
    public static Set<String> getSet(String key) {
        if(useRedis()){
            return JedisEhcacheUtils.getSet(key, String.class);
        } else {
            return JedisSentinelImplUtils.getSet(key);
        }
    }

    /**
     * 获取缓存
     * @param key 键
     * @return 值
     */
    public static Set<Object> getObjectSet(String key) {
        if(useRedis()){
            return JedisEhcacheUtils.getSet(key, Object.class);
        } else {
            return JedisSentinelImplUtils.getObjectSet(key);
        }
    }

    /**
     * 设置Set缓存
     * @param key 键
     * @param value 值
     * @param cacheSeconds 超时时间，0为不超时
     * @return
     */
    public static long setSet(String key, Set<String> value, int cacheSeconds) {
        if(useRedis()){
            return JedisEhcacheUtils.setSet(key, value, cacheSeconds);
        } else {
            return JedisSentinelImplUtils.setSet(key, value, cacheSeconds);
        }
    }

    /**
     * 设置Set缓存
     * @param key 键
     * @param value 值
     * @param cacheSeconds 超时时间，0为不超时
     * @return
     */
    public static long setObjectSet(String key, Set<Object> value, int cacheSeconds) {
        if(useRedis()){
            return JedisEhcacheUtils.setSet(key, value, cacheSeconds);
        } else {
            return JedisSentinelImplUtils.setObjectSet(key, value, cacheSeconds);
        }
    }

    /**
     * 向Set缓存中添加值
     * @param key 键
     * @param value 值
     * @return
     */
    public static long setSetAdd(String key, String... value) {
        if(useRedis()){
            return JedisEhcacheUtils.setSetAdd(key, value);
        } else {
            return JedisSentinelImplUtils.setSetAdd(key, value);
        }
    }

    /**
     * 向Set缓存中添加值
     * @param key 键
     * @param value 值
     * @return
     */
    public static long setSetObjectAdd(String key, Object... value) {
        if(useRedis()){
            return JedisEhcacheUtils.setSetAdd(key, value);
        } else {
            return JedisSentinelImplUtils.setSetObjectAdd(key, value);
        }
    }

    /**
     * 获取Map缓存
     * @param key 键
     * @return 值
     */
    public static Map<String, String> getMap(String key) {
        if(useRedis()){
            return JedisEhcacheUtils.getMap(key);
        } else {
            return JedisSentinelImplUtils.getMap(key);
        }
    }

    public static Map<String, String> getMap(String key, Enum jedisType) {
        if(useRedis()){
            return JedisEhcacheUtils.getMap(key);
        } else {
            return JedisSentinelImplUtils.getMap(key, jedisType);
        }
    }

    /**
     * 获取Map缓存
     * @param key 键
     * @return 值
     */
    public static Map<String, Object> getObjectMap(String key) {
        if(useRedis()){
            return JedisEhcacheUtils.getObjectMap(key);
        } else {
            return JedisSentinelImplUtils.getObjectMap(key);
        }
    }

    /**
     * 设置Map缓存
     * @param key 键
     * @param value 值
     * @param cacheSeconds 超时时间，0为不超时
     * @return
     */
    public static String setMap(String key, Map<String, String> value, int cacheSeconds) {
        if(useRedis()){
            return JedisEhcacheUtils.setMap(key, value, cacheSeconds);
        } else {
            return JedisSentinelImplUtils.setMap(key, value, cacheSeconds);
        }
    }

    /**
     * 设置Map缓存
     * @param key 键
     * @param value 值
     * @param cacheSeconds 超时时间，0为不超时
     * @return
     */
    public static String setObjectMap(String key, Map<String, Object> value, int cacheSeconds) {
        if(useRedis()){
            return JedisEhcacheUtils.setObjectMap(key, value, cacheSeconds);
        } else {
            return JedisSentinelImplUtils.setObjectMap(key, value, cacheSeconds);
        }
    }

    /**
     * 向Map缓存中添加值
     * @param key 键
     * @param value 值
     * @return
     */
    public static String mapPut(String key, Map<String, String> value) {
        if(useRedis()){
            return JedisEhcacheUtils.mapPut(key, value);
        } else {
            return JedisSentinelImplUtils.mapPut(key, value);
        }
    }

    /**
     * 向Map缓存中添加值
     * @param key 键
     * @param value 值
     * @return
     */
    public static String mapObjectPut(String key, Map<String, Object> value) {
        if(useRedis()){
            return JedisEhcacheUtils.mapObjectPut(key, value);
        } else {
            return JedisSentinelImplUtils.mapObjectPut(key, value);
        }
    }

    /**
     * 移除Map缓存中的值
     * @param key 键
     * @param mapKey 值
     * @return
     */
    public static long mapRemove(String key, String mapKey) {
        if(useRedis()){
            return JedisEhcacheUtils.mapRemove(key, mapKey);
        } else {
            return JedisSentinelImplUtils.mapRemove(key, mapKey);
        }
    }

    /**
     * 移除Map缓存中的值
     * @param key 键
     * @param mapKey 值
     * @return
     */
    public static long mapObjectRemove(String key, String mapKey) {
        if(useRedis()){
            return JedisEhcacheUtils.mapRemove(key, mapKey);
        } else {
            return JedisSentinelImplUtils.mapObjectRemove(key, mapKey);
        }
    }

    /**
     * 判断Map缓存中的Key是否存在
     * @param key 键
     * @param mapKey 值
     * @return
     */
    public static boolean mapExists(String key, String mapKey) {
        if(useRedis()){
            return JedisEhcacheUtils.mapExists(key, mapKey);
        } else {
            return JedisSentinelImplUtils.mapExists(key, mapKey);
        }
    }

    /**
     * 判断Map缓存中的Key是否存在
     * @param key 键
     * @param mapKey 值
     * @return
     */
    public static boolean mapObjectExists(String key, String mapKey) {
        if(useRedis()){
            return JedisEhcacheUtils.mapExists(key, mapKey);
        } else {
            return JedisSentinelImplUtils.mapObjectExists(key, mapKey);
        }
    }

    /**
     * 删除缓存
     * @param key 键
     * @return
     */
    public static long del(String key) {
        if(useRedis()){
            return JedisEhcacheUtils.del(key);
        } else {
            return JedisSentinelImplUtils.del(key);
        }
    }

    /**
     * 批量删除缓存
     * @param keys 键
     * @return 删除的记录数
     */
    public static long del(String... keys) {
        if(useRedis()){
            return JedisEhcacheUtils.del(keys);
        } else {
            return JedisSentinelImplUtils.del(keys);
        }
    }

    /**
     * 批量删除缓存
     * @param keys 键
     * @return 删除的记录数
     */
    public static long del(byte[]... keys) {
        if(useRedis()){
            long count = 0;
            for(byte[] key : keys){
                count += JedisEhcacheUtils.del(new String(key));
            }
            return count;
        } else {
            return JedisSentinelImplUtils.del(keys);
        }
    }

    /**
     * 对List,Set,SortSet进行排序,如果集合数据较大应避免使用这个方法
     * @param key
     * @return
     */
    public static List<String> sort(String key){
        if(useRedis()){
            return JedisEhcacheUtils.getList(key, String.class);
        } else {
            return JedisSentinelImplUtils.sort(key);
        }
    }

    /**
     * 更改key
     * @param oldkey
     * @param newkey
     * @return
     */
    public static String rename(String oldkey, String newkey){
        if(useRedis()){
            return JedisEhcacheUtils.rename(oldkey, newkey);
        } else {
            return JedisSentinelImplUtils.rename(oldkey, newkey);
        }
    }
    /**
     * 更改key,仅当新key不存在时才执行
     * @param oldkey
     * @param newkey
     * @return Integer reply, specifically: 1 if the key was renamed 0 if the target key already exist
     */
    public static Long renamex(String oldkey, String newkey){
        if(useRedis()){
            return JedisEhcacheUtils.renamex(oldkey, newkey);
        } else {
            return JedisSentinelImplUtils.renamex(oldkey, newkey);
        }
    }

    /**
     * 设置key的过期时间，以秒为单位
     * @param key
     * @param seconds
     * @return 影响的记录数
     */
    public static Long expired(String key, int seconds){
        if(useRedis()){
            return JedisEhcacheUtils.expired(key, seconds);
        } else {
            return JedisSentinelImplUtils.expired(key, seconds);
        }
    }

    /**
     * 设置key的过期时间,它是距历元（即格林威治标准时间 1970 年 1 月 1 日的 00:00:00，格里高利历）的偏移量
     * @param key
     * @param timestamp
     * @return 影响的记录数
     */
    public static Long expireAt(String key, long timestamp){
        if(useRedis()){
            return JedisEhcacheUtils.expireAt(key, timestamp);
        } else {
            return JedisSentinelImplUtils.expireAt(key, timestamp);
        }
    }

    /**
     * 查询key的过期时间
     * @param key
     * @return 以秒为单位的时间表示
     */
    public static Long ttl(String key){
        if(useRedis()){
            return JedisEhcacheUtils.ttl(key);
        } else {
            return JedisSentinelImplUtils.ttl(key);
        }
    }

    /**
     * 取消对key过期时间的设置
     * @param key
     * @return 影响的记录数
     */
    public static Long persist(String key){
        if(useRedis()){
            return JedisEhcacheUtils.persist(key);
        } else {
            return JedisSentinelImplUtils.persist(key);
        }
    }

    /**
     * 查找所有匹配给定的模式的键
     * @param pattern key的表达式,*表示多个，？表示一个
     * @return
     */
    public static Set<String> keys(String pattern){
        if(useRedis()){
            return null;
        } else {
            return JedisSentinelImplUtils.keys(pattern);
        }
    }


    /**
     * 删除缓存
     * @param key 键
     * @return
     */
    public static long delObject(String key) {
        if(useRedis()){
            return JedisEhcacheUtils.del(key);
        } else {
            return JedisSentinelImplUtils.delObject(key);
        }
    }

    /**
     * 删除缓存
     * @param key 键
     * @return
     */
    public static long delObject(String key,int index) {
        if(useRedis()){
            return JedisEhcacheUtils.del(key);
        } else {
            return JedisSentinelImplUtils.delObject(key, index);
        }
    }



    /**
     * 缓存是否存在
     * @param key 键
     * @return
     */
    public static boolean exists(String key) {
        if(useRedis()){
            return JedisEhcacheUtils.exists(key);
        } else {
            return JedisSentinelImplUtils.exists(key);
        }
    }

    /**
     * 缓存是否存在
     * @param key 键
     * @return
     */
    public static boolean existsObject(String key) {
        if(useRedis()){
            return JedisEhcacheUtils.exists(key);
        } else {
            return JedisSentinelImplUtils.existsObject(key);
        }
    }

    /**
     * 删除原有key并且重新设值
     * @param key
     * @param cacheSeconds
     */
    public static String resetObjectByKey(String key,Object value,int cacheSeconds){
        if(useRedis()){
            return JedisEhcacheUtils.resetObjectByKey(key, value, cacheSeconds);
        } else {
            return JedisSentinelImplUtils.resetObjectByKey(key, value, cacheSeconds);
        }
    }

    /**
     * 获取byte[]类型Key
     * @return
     */
    public static byte[] getBytesKey(Object object){
        if(object instanceof String){
            return ((String)object).getBytes();
        }else{
            // TOFO
            return ObjectUtils.serialize(object);
        }
    }

    /**
     * Object转换byte[]类型
     * @return
     */
    public static byte[] toBytes(Object object){
        return  ObjectUtils.serialize(object);
    }

    /**
     * byte[]型转换Object
     * @return
     */
    public static Object toObject(byte[] bytes){
        return ObjectUtils.unserialize(bytes);
    }


    /**
     * 返回当前数据库的 key 的数量
     * @return
     */
//	public static long dbSize(){
//		if(useRedis()){
//			return 0;
//		} else {
//			return JedisSentinelImplUtils.dbSize();
//		}
//	}


    /**
     * 返回当前数据库的 key 的数量
     * @return
     */
//	public static long dbSize(int index){
//		if(useRedis()){
//			return 0;
//		} else {
//			return JedisSentinelImplUtils.dbSize(index);
//		}
//	}


    /**
     * 清空当前数据库
     * @return
     */
//	public static String flushDB(int index){
//		if(useRedis()){
//			return "FAIL";
//		} else {
//			return JedisSentinelImplUtils.flushDB(index);
//		}
//	}

    /**
     * 选择数据库
     * @param index
     * @return Status code reply
     */
//	public static String select(Jedis jedis,int index){
//		if(useRedis()){
//			return "FAIL";
//		} else {
//			return JedisSentinelImplUtils.select(jedis, index);
//		}
//	}



    /**
     * 清空所有数据库
     * @return
     */
//	public static String flushALL(){
//		if(useRedis()){
//			return "FAIL";
//		} else {
//			return JedisSentinelImplUtils.flushALL();
//		}
//	}

    public static Long hset(final String key, final String field, final String value) {
        if(useRedis()){
            return JedisEhcacheUtils.hset(key, field, value);
        } else {
            return JedisSentinelImplUtils.hset(key, field, value);
        }
    }

    public static String hget(final String key, final String field, JedisType jedisType) {
        if(useRedis()){
            return JedisEhcacheUtils.hget(key, field);
        } else {
            return JedisSentinelImplUtils.hget(key, field, jedisType);
        }
    }

    public static String hget(final String key, final String field) {
        if(useRedis()){
            return JedisEhcacheUtils.hget(key, field);
        } else {
            return JedisSentinelImplUtils.hget(key, field);
        }
    }


    public static List<String> hvals(final String key) {
        if(useRedis()){
            return JedisEhcacheUtils.hvals(key);
        } else {
            return JedisSentinelImplUtils.hvals(key);
        }
    }

    public static Set<String> hkeys(final String key) {
        if(useRedis()){
            return JedisEhcacheUtils.hkeys(key);
        } else {
            return JedisSentinelImplUtils.hkeys(key);
        }
    }

    public static Long hdel(final String key, final String... fields) {
        if(useRedis()){
            return JedisEhcacheUtils.hdel(key, fields);
        } else {
            return JedisSentinelImplUtils.hdel(key, fields);
        }
    }

    public static String rpoplpush(String queue, String tmpQueue) {
        if(useRedis()){
            return JedisEhcacheUtils.rpoplpush(queue, tmpQueue);
        } else {
            return JedisSentinelImplUtils.rpoplpush(queue, tmpQueue);
        }
    }

    public static long lpush(final String key, final String... strings)  {
        if(useRedis()){
            return JedisEhcacheUtils.lpush(key, strings);
        } else {
            return JedisSentinelImplUtils.lpush(key, strings);
        }
    }

    public static String rpop(String queue) {
        if(useRedis()){
            return JedisEhcacheUtils.rpop(queue);
        } else {
            return JedisSentinelImplUtils.rpop(queue);
        }
    }

    public static Long incr(String key){
        if(useRedis()){
            return 0L;
        } else {
            return JedisSentinelImplUtils.incr(key);
        }
    }

//
///**
//     * GEO key  经度 纬度 名称
//     *
//     * @param key
//     * @param longitude
//     * @param latitude
//     * @param member
//     * @return
//     */
//    public static Long geoadd(String key, double longitude, double latitude, String member) {
//        return JedisSentinelImplUtils.geoadd(key, longitude, latitude, member);
//    }
//
//    /**
//     * geo 查询地理位置
//     *
//     * @param key
//     * @param name 位置名
//     * @return
//     */
//    public static List<GeoCoordinate> geops(String key, String... name) {
//        return JedisSentinelImplUtils.geops(key, name);
//    }
//
//    /**
//     * 用于获取两个地理位置间的距离
//     * unit m 表示单位为米；
//     * km 表示单位为千米；
//     * mi 表示单位为英里；
//     * ft 表示单位为英尺。
//     * pS: 计算举例时存在 0.5% 左右的误差，这是由于 Redis GEO 把地球假设成了完美的球体
//     *
//     * @return
//     */
//    public static Double geoDist(String key, String city1, String city2, GeoUnit unit) {
//        return JedisSentinelImplUtils.geoDist(key, city1, city2, unit);
//    }
//
//    /**
//     * 以给定的经纬度为中心，计算出 key 包含的地理位置元素与中心的距离不超过给定最大距离的所有位置元素
//     * GeoRadiusParam 参数说明：
//     * WITHDIST ：在返回位置元素的同时， 将位置元素与中心之间的距离也一并返回。
//     * WITHCOORD ：返回位置元素的经度和维度。
//     * WITHHASH ：采用 GEOHASH 对位置元素进行编码，以 52 位有符号整数的形式返回有序集合的分值，该选项主要用于底层调试，实际作用不大。
//     * COUNT：指定返回位置元素的数量，在数据量非常大时，可以使用此参数限制元素的返回数量，从而加快计算速度。
//     * 默认返回的是未排序的位置元素。通过 ASC 与 DESC 可让返回的位置元素以升序或者降序方式排列
//     *
//     * @param radius 半径（最大范围）
//     * @return
//     */
//    public static List<GeoRadiusResponse> geoRadius(String key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam geoRadiusParam) {
//        return JedisSentinelImplUtils.geoRadius(key, longitude, latitude, radius, unit, geoRadiusParam);
//    }
//
//    /**
//     * 根据给定的地理位置坐标（即经纬度）获取指定范围内的位置元素集合
//     * GEORADIUSBYMEMBER city guiyang 900 km WITHCOORD WITHDIST
//     *
//     * @param key
//     * @param radius         搜索半径
//     * @param unit           单位
//     * @param geoRadiusParam
//     * @return
//     */
//    public static List<GeoRadiusResponse> getRadiusByMember(String key, String city, double radius, GeoUnit unit, GeoRadiusParam geoRadiusParam) {
//        return JedisSentinelImplUtils.getRadiusByMember(key, city, radius, unit, geoRadiusParam);
//    }
//
//    /**
//     * 返回一个或多个位置元素的哈希字符串，该字符串具有唯一 ID 标识，它与给定的位置元素
//     * GEOHASH city lanzhou beijing shanghai
//     *
//     * @param key
//     * @param members
//     * @return
//     */
//    public static List<String> geoHash(String key, String... members) {
//        return JedisSentinelImplUtils.geoHash(key, members);
//    }
//
//    /**
//     * 用于删除指定的地理位置元素
//     *
//     * @param key
//     * @param members
//     * @return
//     */
//    public static Long zRem(String key, String... members) {
//        return JedisSentinelImplUtils.zRem(key, members);
//    }


}
