//package com.scpyun.platform.jilinsscgsdp.aspect;
//
//import com.fasterxml.jackson.databind.exc.InvalidDefinitionException;
//import com.scpyun.base.core.exception.CustomException;
//import com.scpyun.base.core.utils.StringUtils;
//import com.scpyun.base.core.utils.UUIDUtil;
//import com.scpyun.base.core.utils.UnifyLogger;
//import org.aspectj.lang.ProceedingJoinPoint;
//import org.aspectj.lang.annotation.Around;
//import org.aspectj.lang.annotation.Aspect;
//import org.aspectj.lang.annotation.Pointcut;
//import org.springframework.core.Ordered;
//import org.springframework.stereotype.Component;
//import org.springframework.web.context.request.RequestAttributes;
//import org.springframework.web.context.request.RequestContextHolder;
//import org.springframework.web.context.request.ServletRequestAttributes;
//
//import javax.servlet.http.HttpServletRequest;
//import javax.validation.ConstraintViolationException;
//import java.util.Objects;
//
//@Aspect
//@Component
//public class CommonAspect implements Ordered {
//
//    @Pointcut( "execution(* com.scpyun.platform.jilinsscgsdp.service.impl..*.*(..))" )
//    public void exceptionProccesser() {}
//
//
//    @Around("exceptionProccesser()")
//    public Object doAround(ProceedingJoinPoint proceedingJoinPoint) {
//        Throwable exception=null;
//        Object result=null;
//        String requestId = UUIDUtil.getUUID();
//        long startTime = System.currentTimeMillis();
//        try {
//            RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
//            if (null == requestAttributes){
//                return proceedingJoinPoint.proceed();
//            }
//            HttpServletRequest servletRequest = ((ServletRequestAttributes) Objects.requireNonNull(RequestContextHolder.getRequestAttributes())).getRequest();
////            UnifyLogger.getLog().info("requestID："+requestId+"，startTime："+ startTime+"，requestURL："+servletRequest.getRequestURI()+"，param："+ RequestParamUtil.getBody(servletRequest));
//            result = proceedingJoinPoint.proceed();
//            long endTime = System.currentTimeMillis();
//            UnifyLogger.getLog().info("requestID："+requestId+"，endTime："+ endTime +"，time consuming："+ (endTime-startTime) + "ms");
//        } catch (Throwable throwable) {
//            exception = throwable;
//            UnifyLogger.getLog().error("requestID："+requestId+"----------"+exception.getMessage(), exception);
//            if (exception instanceof CustomException == false && exception instanceof ConstraintViolationException == false){
//                throw new CustomException("操作失败。");
//            }
//
//            if (exception instanceof ConstraintViolationException && StringUtils.isNotEmpty(exception.getMessage())){
//                String[] split = exception.getMessage().split(",");
//                StringBuilder builder = new StringBuilder();
//                for (String s : split) {
//                    builder.append(s.split(":")[1]).append(",");
//                }
//                throw new CustomException(builder.toString());
//            }
//
//            throw new CustomException(StringUtils.isEmpty(exception.getMessage()) ? "操作失败" : exception.getMessage());
//        }
//        return result;
//    }
//
//
//    @Override
//    public int getOrder() {
//        return 1;
//    }
//}
