package com.scpyun.platform.jilinsscgsdp.pojo;


import com.scpyun.base.core.utils.SameTypeFlatTreeBuilder;

import java.util.ArrayList;
import java.util.List;

/**
 * 区域实体类（仅保留树形结构构建核心字段）
 */
public class Area {

    private static final long serialVersionUID = 1L;

    // 仅保留构建树形结构必需的核心字段
    private String id;         // 节点编号（主键，层级关联核心）
    private String parentId;   // 父级编号（构建层级关系必需）
    private String name;       // 区域名称（生成虚拟节点名称基础）
    private String type;       // 区域类型（数据库数字，平级同type关键）
    private Integer sort;      // 排序字段（控制节点显示顺序）

    // 无参构造器（MyBatis 映射必需）
    public Area() {
    }

    // 核心字段构造器（快速创建实体）
    public Area(String id, String parentId, String name, String type, Integer sort) {
        this.id = id;
        this.parentId = parentId;
        this.name = name;
        this.type = type;
        this.sort = sort;
    }

    // 核心字段的 getter 和 setter
    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getParentId() {
        return parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Integer getSort() {
        return sort;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }



}