package com.scpyun.platform.jilinsscgsdp.service.impl;


import com.alibaba.excel.EasyExcel;
import com.scpyun.base.core.annotation.Api;
import com.scpyun.base.core.annotation.ApiOperation;
import com.scpyun.base.core.exception.CustomException;
import com.scpyun.base.db.service.CommonService;
import com.scpyun.platform.jilinsscgsdp.bean.entity.eventCategoryStatistics;
import com.scpyun.platform.jilinsscgsdp.bean.entity.eventResolveStatistics;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;
import org.springframework.validation.annotation.Validated;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.*;


@Api("事件统计")
@Service("EventStatisticsServiceImpl")
@Validated
public class EventStatisticsServiceImpl {

    @Autowired
    CommonService commonService;
    private final String namespace = "com.scpyun.platform.standard.jilinsscgsdp.EventStatistics.";

    @ApiOperation(value = "重点行业领域矛盾纠纷情况统计表", desc = "重点行业领域矛盾纠纷情况统计表")
    public List<eventCategoryStatistics> eventCategoryStatisticsServiceImpl(eventCategoryStatistics eventCategoryStatistics){
        return commonService.findList(namespace + "eventCategoryStatisticsServiceImpl", eventCategoryStatistics);
    }

    @ApiOperation(value = "重点行业领域矛盾纠纷情况统计表-导出")
    public void eventCategoryStatisticsExport(HttpServletResponse response,eventCategoryStatistics eventCategoryStatistics) throws IOException {
        List<eventCategoryStatistics> eventCategoryStatisticsExport = commonService.findList(namespace + "eventCategoryStatisticsServiceImpl", eventCategoryStatistics);
        if(eventCategoryStatisticsExport==null || eventCategoryStatisticsExport.size()==0){
            throw new CustomException("暂无数据！");
        }

        // web环境下导出设置响应头
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setCharacterEncoding("utf-8");
        String fileName = URLEncoder.encode("重点行业领域矛盾纠纷情况统计表", "UTF-8").replaceAll("\\+", "%20");
        response.setHeader("Content-disposition", "attachment;filename*=utf-8''" + fileName + ".xlsx");

        String filePath = "zhongdianhangye.xlsx";
        Resource resource = new ClassPathResource(filePath);
        InputStream is = resource.getInputStream();

        EasyExcel.write(response.getOutputStream()).withTemplate(is).sheet().doFill(eventCategoryStatisticsExport);
    }

    @ApiOperation(value = "矛盾纠纷排查化解情况统计表", desc = "矛盾纠纷排查化解情况统计表")
    public List<eventResolveStatistics> eventResolveStatisticsServiceImpl(eventResolveStatistics eventResolveStatistics){
        return commonService.findList(namespace + "eventResolveStatisticsServiceImpl", eventResolveStatistics);
    }

    @ApiOperation(value = "矛盾纠纷排查化解情况统计表-导出")
    public void eventResolveStatisticsExport(HttpServletResponse response,eventResolveStatistics eventResolveStatistics) throws IOException {
        List<eventResolveStatistics> eventResolveStatisticsExport = commonService.findList(namespace + "eventResolveStatisticsServiceImpl", eventResolveStatistics);
        if(eventResolveStatisticsExport==null || eventResolveStatisticsExport.size()==0){
            throw new CustomException("暂无数据！");
        }

        // web环境下导出设置响应头
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setCharacterEncoding("utf-8");
        String fileName = URLEncoder.encode("矛盾纠纷排查化解情况统计表", "UTF-8").replaceAll("\\+", "%20");
        response.setHeader("Content-disposition", "attachment;filename*=utf-8''" + fileName + ".xlsx");

        String filePath = "maodunjiufen.xlsx";
        Resource resource = new ClassPathResource(filePath);
        InputStream is = resource.getInputStream();

        EasyExcel.write(response.getOutputStream()).withTemplate(is).sheet().doFill(eventResolveStatisticsExport);
    }

}