package com.scpyun.platform.jilinsscgsdp.check;

import java.util.Map;

import com.scpyun.base.core.exception.CustomException;
import com.scpyun.base.core.utils.StringUtils;

import cn.hutool.core.util.IdcardUtil;

/**
 * @Author liu
 * @Date 2024/7/31 10:52
 * @PackageName:com.scpyun.platform.jilinsscgsdp.check
 * @ClassName: GridUser
 * @Version 1.0
 */
public class GridUserCheckUtils {
    /**
     * 网格人员添加校验必填
     * @param map
     */
    public static void gridUserCheck(Map<String, Object> map) {
        if (!IdcardUtil.isValidCard(StringUtils.toStr(map.get("cardno")))){
            throw new CustomException("证件号码错误！");
        }else {
        	map.put("sex", IdcardUtil.getGenderByIdCard(map.get("cardno").toString())==1?"1":"2");
        }
        if ("1".equals(map.get("is_kgh"))){
            if (StringUtils.isEmpty(map.get("garden_id"))) {
                throw new CustomException("所属网格不能为空！");
            }
            if (StringUtils.isEmpty(map.get("building_id"))) {
                throw new CustomException("所属楼宇不能为空！");
            }
            if (StringUtils.isEmpty(map.get("unit_id"))) {
                throw new CustomException("所属单元不能为空！");
            }
            if (StringUtils.isEmpty(map.get("floor_id"))) {
                throw new CustomException("所属楼层不能为空！");
            }
            if (StringUtils.isEmpty(map.get("doorplate_id"))) {
                throw new CustomException("所属户室不能为空！");
            }
        }else {
        	map.put("garden_id", null);
        }
    }
}
