package com.scpyun.platform.jilinsscgsdp.enums;

/**
 * @Author liu
 * @Date 2025/9/26 13:47
 * @PackageName:com.scpyun.platform.jilinsscgsdp.enums
 * @ClassName: ScoreCategoryEnum
 * @Description: TODO
 * @Version 1.0
 */
public class ScoreCategoryEnum {
    public enum ScoreCategory {
        A("A",80, 99999),    // 80分及以上
        B("B",60, 79),     // 60-79分
        C("C",0, 59);      // 59分及以下

        private final String type;
        private final int min;
        private final int max;

        ScoreCategory(String type, int min, int max) {
            this.min = min;
            this.max = max;
            this.type = type;
        }

        public static String fromScore(int score) {
            for (ScoreCategory category : values()) {
                if (score >= category.min && score <= category.max) {
                    return category.type;
                }
            }
            throw new IllegalArgumentException("无效分数: " + score);
        }
    }
}
