package com.scpyun.platform.jilinsscgsdp.service.impl;

import java.util.Map;
import java.util.regex.Pattern;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.scpyun.base.core.annotation.Api;
import com.scpyun.base.core.annotation.ApiOperation;
import com.scpyun.base.core.exception.CustomException;
import com.scpyun.base.core.utils.StringUtils;
import com.scpyun.base.db.service.CommonService;

import cn.hutool.core.util.IdcardUtil;

/**
 * @description: 户主信息
 * @author: dushilong
 * @date: 2024-06-04 13:49
 */
@Api("户主信息")
@Service("doorplateOwnerService")
public class DoorplateOwnerServiceImpl {
    @Autowired
    CommonService commonService;
    private final String nameSpace = "com.scpyun.platform.standard.jilinsscgsdp.doorplateOwner.";
    public static final String mobile_exp = "^((13[0-9])|(14[5,7,9])|(15[0-3,5-9])|(166)|(17[0-9])|(18[0-9])|(19[1,8,9]))\\d{8}$";
    public static final String tel_yqh_exp = "^[0][1-9]{2,3}-[0-9]{5,10}$";
    public static final String tel_wqh_exp = "^[1-9]{1}[0-9]{5,8}$";

    @ApiOperation(value = "查询户主信息", desc = "查询户主信息")
    public Map<String,Object> getDoorplateOwnerInfo(Map<String, Object> map) {
        if(StringUtils.isEmpty(map.get("id"))){
            throw new CustomException("缺少参数！id");
        }

        return commonService.getObject(nameSpace + "getDoorplateOwnerInfo",map);
    }

    @ApiOperation(value = "修改户主信息",desc = "修改户主信息")
    public String updateDoorplateOwnerInfo(Map<String, Object> map){
        if(StringUtils.isEmpty(map.get("id"))){
            throw new CustomException("缺少参数！id");
        }
        if(StringUtils.isNotEmpty(map.get("owner_cardno"))){
        	if (!IdcardUtil.isValidCard(StringUtils.toString(map.get("owner_cardno")))) {
                throw new CustomException("身份证号不合法！");
            }
        }
        if(StringUtils.isNotEmpty(map.get("owner_phone"))){
            String mobile = StringUtils.toString(map.get("owner_phone"));
            if (!Pattern.compile(mobile_exp).matcher(mobile).matches() && !Pattern.compile(tel_wqh_exp).matcher(mobile).matches() && !Pattern.compile(tel_yqh_exp).matcher(mobile).matches()) {
                throw new CustomException("电话号码不合法！");
            }
        }
        if (commonService.update(nameSpace + "updateDoorplateOwnerInfo",map)!= 1){
            throw new CustomException("修改失败！");
        }
        return "success";
    }

}
