//
// Source code recreated from a .class file by IntelliJ IDEA
// (powered by FernFlower decompiler)
//

package com.scpyun.platform.jilinsscgsdp.utils;

import com.scpyun.base.core.exception.CustomException;
import com.scpyun.base.core.utils.SpringContextHolder;
import com.scpyun.base.core.utils.StringUtils;
import org.springframework.data.redis.core.RedisTemplate;
import redis.clients.jedis.exceptions.JedisException;

import java.util.Map;
import java.util.concurrent.TimeUnit;
/**
 *
 * @Title:  RedisTemplateUtils
 * @Package RedisTemplateUtils.java
 * @Description: copy By scp-grid
 * @author:  guojiucoder
 * @date:   2024/7/31 14:25
 * @version V1.0.0
 *
 */
public class RedisTemplateUtils {
    private static RedisConfig redisConfig = null;

    public RedisTemplateUtils() {
    }

    public static String hget(String key, String field, String redisPoolKey) {
        return StringUtils.toStr(getRedisTemplate(redisPoolKey).opsForHash().get(key, field));
    }

    public static Map<String, String> getMap(String key, String redisPoolKey) {
        RedisTemplate<String, Object> rt = getRedisTemplate(redisPoolKey);
        if (!rt.hasKey(key)) {
            return null;
        } else {
            Map value = rt.opsForHash().entries(key);
            return value != null ? value : value;
        }
    }

    public static void hset(String key, String field, String value, String redisPoolKey) {
        getRedisTemplate(redisPoolKey).opsForHash().put(key, field, value);
    }

    public static void setMap(String key, Map<String, String> params, int cacheSeconds, String redisPoolKey) {
        RedisTemplate<String, Object> redisTemplate = getRedisTemplate(redisPoolKey);
        redisTemplate.opsForHash().putAll(key, params);
        if (cacheSeconds != 0) {
            redisTemplate.expire(key, (long)cacheSeconds, TimeUnit.SECONDS);
        }

    }

    public static void del(String key, String redisPoolKey) {
        RedisTemplate<String, Object> redisTemplate = getRedisTemplate(redisPoolKey);
        redisTemplate.delete(key);
    }

    public static void set(String key, String value, int cacheSeconds, String redisPoolKey) {
        RedisTemplate<String, Object> redisTemplate = getRedisTemplate(redisPoolKey);
        redisTemplate.opsForValue().set(key, value);
        if (cacheSeconds != 0) {
            redisTemplate.expire(key, (long)cacheSeconds, TimeUnit.SECONDS);
        }

    }

    public static String get(String key, String redisPoolKey) {
        return StringUtils.toStr(getRedisTemplate(redisPoolKey).opsForValue().get(key));
    }

    public static RedisTemplate<String, Object> getRedisTemplate(String redisPoolKey) throws JedisException {
        if (StringUtils.isEmpty(redisPoolKey)) {
            throw new CustomException("参数错误");
        } else {
            try {
                if (redisConfig == null) {
                    redisConfig = (RedisConfig)SpringContextHolder.getBean("redisConfig");
                }

                RedisConfig var10000 = redisConfig;
                return (RedisTemplate)RedisConfig.redisTemplateMap.get(redisPoolKey);
            } catch (Exception var2) {
                throw new CustomException("缓存无法连接", var2);
            }
        }
    }

    private static int redisCount() {
        if (redisConfig == null) {
            redisConfig = (RedisConfig)SpringContextHolder.getBean("redisConfig");
        }

        return redisConfig.redisCount;
    }
}
