package com.scpyun.platform.jilinsscgsdp.service.impl;

import com.scpyun.base.bean.Page;
import com.scpyun.base.core.annotation.Api;
import com.scpyun.base.core.annotation.ApiOperation;
import com.scpyun.base.core.exception.CustomException;
import com.scpyun.base.db.service.CommonService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

@Api("请假类型管理")
@Service("keyDmLeaveType")
public class KeyDmLeaveTypeServiceImpl {
    @Autowired
    private CommonService commonService;

    private static final String SUCCESS = "success";
    private final String namespace = "com.scpyun.platform.standard.jilinsscgsdp.keyDmLeaveType.";

    @ApiOperation(value = "查询请假类型列表", desc = "分页查询请假类型")
    public Page<Map<String, Object>> selectList(Map<String, Object> map) {
        if (map == null) {
            map = new HashMap<>();
        }
        return commonService.findPage(namespace + "selectList", map);
    }

    @ApiOperation(value = "保存请假类型", desc = "新增或修改请假类型")
    public String save(Map<String, Object> map) {
        if (map == null) {
            throw new CustomException("参数不能为空");
        }
        Object id = map.get("id");
        if (id == null || String.valueOf(id).trim().isEmpty()) {
            // 新增
            if (commonService.insert(namespace + "insert", map) != 1) {
                throw new CustomException("保存失败");
            }
        } else {
            // 修改
            int affected = commonService.update(namespace + "update", map);
            if (affected < 0) {
                throw new CustomException("保存失败");
            }
        }
        return SUCCESS;
    }

    @ApiOperation(value = "删除请假类型", desc = "逻辑删除请假类型")
    public String delete(Map<String, Object> map) {
        if (map == null || map.get("id") == null) {
            throw new CustomException("参数不能为空");
        }
        int affected = commonService.update(namespace + "delete", map);
        if (affected < 0) {
            throw new CustomException("删除失败");
        }
        return SUCCESS;
    }
}

