package com.scpyun.platform.jilinsscgsdp.service.impl;


import com.alibaba.excel.EasyExcel;
import com.scpyun.base.bean.User;
import com.scpyun.base.core.annotation.Api;
import com.scpyun.base.core.annotation.ApiOperation;
import com.scpyun.base.core.exception.CustomException;
import com.scpyun.base.db.service.CommonService;
import com.scpyun.platform.jilinsscgsdp.bean.vo.SocialSecurityVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;


@Api("社会治安管理")
@Service("SocialSecurityServiceImpl")
public class SocialSecurityServiceImpl {

    @Autowired
    CommonService commonService;
    private final String nameSpace = "com.scpyun.platform.standard.jilinsscgsdp.SocialSecurity.";

    @ApiOperation(value = "添加", desc = "添加")
    public void insertSocialSecurity(SocialSecurityVo socialSecurityVo) {
        SocialSecurityVo info = commonService.getObject(nameSpace + "checkHasExist", socialSecurityVo);
        if(info!=null){
            throw new CustomException(socialSecurityVo.getYear()+"年，该数据栏已存在，不可重复添加，请在列表对该数据栏进行修改操作！");
        }
        commonService.insert(nameSpace+"insertSocialSecurity",socialSecurityVo);
    }

    @ApiOperation(value = "修改", desc = "修改")
    public void updateSocialSecurity(SocialSecurityVo socialSecurityVo) {
        commonService.update(nameSpace+"updateSocialSecurity",socialSecurityVo);
    }

    @ApiOperation(value = "列表", desc = "列表")
    public List<SocialSecurityVo> selectSocialSecurityPageList(SocialSecurityVo socialSecurityVo) {
        User _user = socialSecurityVo.get_user();
        if(_user.getCompany_grade().equals("2")){// 省级账号
            return commonService.findList(nameSpace + "selectAllSocialSecurityPageList", socialSecurityVo);
        }else{
            return commonService.findList(nameSpace + "selectSocialSecurityPageList", socialSecurityVo);
        }
        /*Page<SocialSecurityVo> selectSocialSecurityPageList = commonService.findPage(nameSpace + "selectSocialSecurityPageList", page);
        return selectSocialSecurityPageList;*/
    }

    @ApiOperation(value = "详情")
    public SocialSecurityVo selectSocialSecurityInfo(SocialSecurityVo socialSecurityVo) {
        return commonService.getObject(nameSpace+"selectSocialSecurityInfo",socialSecurityVo);
    }

    @ApiOperation(value = "数据导出")
    public void selectSocialSecurityListExport(SocialSecurityVo socialSecurityVo, HttpServletResponse response) throws IOException {
        List<SocialSecurityVo> list=new ArrayList<>();
        User _user = socialSecurityVo.get_user();
        if(_user.getCompany_grade().equals("2")){// 省级账号
            list=commonService.findList(nameSpace + "selectAllSocialSecurityPageList", socialSecurityVo);
        }else{
            list=commonService.findList(nameSpace + "selectSocialSecurityPageList", socialSecurityVo);
        }
        String exportfileName="社会治安管理";
        String exportfilePath="shehuizhian.xlsx";

        // web环境下导出设置响应头
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setCharacterEncoding("utf-8");
        String fileName = URLEncoder.encode(exportfileName, "UTF-8").replaceAll("\\+", "%20");
        response.setHeader("Content-disposition", "attachment;filename*=utf-8''" + fileName + ".xlsx");

        String filePath = exportfilePath;
        Resource resource = new ClassPathResource(filePath);
        InputStream is = resource.getInputStream();

        EasyExcel.write(response.getOutputStream()).withTemplate(is).sheet().doFill(list);
    }

    @ApiOperation(value = "社会治安首页统计", desc = "社会治安首页统计")
    public Map<String,Object> socialSecurityStatistics(Map<String,Object> map) {
        return commonService.getObject(nameSpace+"socialSecurityStatistics",map);
    }




}