package com.scpyun.platform.jilinsscgsdp.bean.vo.task;

import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Update;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.Pattern;

/**
 * @Author liu
 * @Date 2025/7/28 16:27
 * @PackageName:com.scpyun.platform.jilinexchange.bean.vo
 * @ClassName: ReqResidentialVo
 * @Description: TODO
 * @Version 1.0
 */
public class ReqResidentialVo extends ReqBaseVo{
    @NotEmpty(message = "id不可为空", groups = {Insert.class, Update.class, Delete.class})
    @Length(min = 1, max = 200, message = "id数据长度范围1到200", groups = {Insert.class, Update.class, Delete.class})
    private String id;
    @NotEmpty(message = "小区名称不可为空")
    @Length(min = 1, max = 40, message = "小区名称数据长度范围1到40", groups = {Insert.class, Update.class})
    private String name;
    @NotEmpty(message = "详细地址不可为空")
    @Length(min = 1, max = 255, message = "详细地址数据长度范围1到200", groups = {Insert.class, Update.class})
    private String address;
    private String measure;
    private String grade;
    private String cscMapjson;
    @NotEmpty(message = "市编码不可为空")
    @Pattern(regexp = "^\\d{12}$", message = "市编码格式异常", groups = {Insert.class, Update.class})
    private String cityCode;

    /**
     * 区编码
     */
    @NotEmpty(message = "区编码不可为空")
    @Pattern(regexp = "^\\d{12}$", message = "区编码格式异常", groups = {Insert.class, Update.class})
    private String areaCode;

    /**
     * 街道编码
     */
    @NotEmpty(message = "街道不可为空")
    @Pattern(regexp = "^\\d{12}$", message = "街道编码格式异常", groups = {Insert.class, Update.class})
    private String streetCode;

    /**
     * 社区编码
     */
    @NotEmpty(message = "社区不可为空")
    @Pattern(regexp = "^\\d{12}$", message = "社区编码格式异常", groups = {Insert.class, Update.class})
    private String communityCode;

    /**
     * 网格ID
     */
    @NotEmpty(message = "网格ID不可为空")
    @Length(min = 1, max = 40, message = "网格ID数据长度范围1到40", groups = {Insert.class, Update.class})
    private String gardenId;
    @NotEmpty(message = "appid不可为空")
    @Length(min = 1, max = 36, message = "appid数据长度范围1到36", groups = {Insert.class, Update.class, Delete.class})
    private String appid;
    private String szdwbb;
    private String szdzbbb;
    private String type;
    private String cscMapjsonHt;
    private String inType;

    private Integer intId;

    public Integer getIntId() {
        return intId;
    }

    public void setIntId(Integer intId) {
        this.intId = intId;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getMeasure() {
        return measure;
    }

    public void setMeasure(String measure) {
        this.measure = measure;
    }

    public String getGrade() {
        return grade;
    }

    public void setGrade(String grade) {
        this.grade = grade;
    }

    public String getCscMapjson() {
        return cscMapjson;
    }

    public void setCscMapjson(String cscMapjson) {
        this.cscMapjson = cscMapjson;
    }

    public String getCityCode() {
        return cityCode;
    }

    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }

    public String getAreaCode() {
        return areaCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    public String getStreetCode() {
        return streetCode;
    }

    public void setStreetCode(String streetCode) {
        this.streetCode = streetCode;
    }

    public String getCommunityCode() {
        return communityCode;
    }

    public void setCommunityCode(String communityCode) {
        this.communityCode = communityCode;
    }

    public String getGardenId() {
        return gardenId;
    }

    public void setGardenId(String gardenId) {
        this.gardenId = gardenId;
    }

    public String getAppid() {
        return appid;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public String getSzdwbb() {
        return szdwbb;
    }

    public void setSzdwbb(String szdwbb) {
        this.szdwbb = szdwbb;
    }

    public String getSzdzbbb() {
        return szdzbbb;
    }

    public void setSzdzbbb(String szdzbbb) {
        this.szdzbbb = szdzbbb;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getCscMapjsonHt() {
        return cscMapjsonHt;
    }

    public void setCscMapjsonHt(String cscMapjsonHt) {
        this.cscMapjsonHt = cscMapjsonHt;
    }

    public String getInType() {
        return inType;
    }

    public void setInType(String inType) {
        this.inType = inType;
    }
}
