package com.scpyun.platform.jilinsscgsdp.service.impl;

import com.scpyun.base.bean.Page;
import com.scpyun.base.core.annotation.Api;
import com.scpyun.base.core.annotation.ApiOperation;
import com.scpyun.base.core.exception.CustomException;
import com.scpyun.base.db.service.CommonService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Map;

/**
 * @Author liu
 * @Date 2025/9/26 15:38
 * @PackageName:com.scpyun.platform.jilinsscgsdp.service.impl
 * @ClassName: KeyPersonVisitServiceImpl
 * @Description: TODO
 * @Version 1.0
 */
@Api("重度人员回访")
@Service("keyPersonVisit")
public class KeyPersonVisitServiceImpl {
    @Autowired
    CommonService commonService;

    private final String SUCCESS = "success";

    private String namespace = "com.scpyun.platform.standard.jilinsscgsdp.keyPersonVisit.";

    @ApiOperation(value = "回访设置管理",desc = "回访设置管理")
    public String saveKeyPersonVisit(Map<String, Object> map){
        // 字段校验：起止天数为正整数且起始<=结束
        Object startObj = map.get("visit_start_day");
        Object endObj = map.get("visit_end_day");
        if (startObj == null || endObj == null) {
            throw new CustomException("请填写起止天数");
        }
        int s, e;
        try {
            s = Integer.parseInt(String.valueOf(startObj));
            e = Integer.parseInt(String.valueOf(endObj));
        } catch (Exception ex) {
            throw new CustomException("天数需为正整数");
        }
        if (s <= 0 || e <= 0) {
            throw new CustomException("天数需为正整数");
        }
        if (s > e) {
            throw new CustomException("起始天数不能大于结束天数");
        }
        // 必填：临期预警天为正整数
        Object overdueObj = map.get("overdue_warning_day");
        if (overdueObj == null || String.valueOf(overdueObj).trim().length() == 0) {
            throw new CustomException("请输入临期预警天");
        }
        try {
            int overdue = Integer.parseInt(String.valueOf(overdueObj));
            if (overdue <= 0) {
                throw new CustomException("临期预警天需为正整数");
            }
        } catch (Exception ex) {
            throw new CustomException("临期预警天需为正整数");
        }
        // 必填：部门类型
        Object officeTypeObj = map.get("sys_type_office_value");
        if (officeTypeObj == null || String.valueOf(officeTypeObj).trim().length() == 0) {
            throw new CustomException("请选择部门类型");
        }
        // 如果保存时状态为启用，需要先停用同一部门、同一类别、同一风险等级的其他启用记录
        Object statusObj = map.get("status");
        if ("1".equals(String.valueOf(statusObj))) {
            commonService.update(namespace + "disableOtherActives", map);
        }
        // 区分新增与修改：有id则更新，无id则新增
        Object idObj = map.get("id");
        if (idObj == null || String.valueOf(idObj).trim().length() == 0) {
            if (commonService.insert(namespace + "saveKeyPersonVisit", map) != 1) {
                throw new CustomException("添加失败");
            }
        } else {
            if (commonService.update(namespace + "updateKeyPersonVisit", map) != 1) {
                throw new CustomException("修改失败");
            }
        }
        return SUCCESS;
    }

    @ApiOperation(value = "删除回访设置",desc = "删除回访设置")
    public String deletePersonVisit(Map<String, Object> map){
        if (commonService.insert(namespace + "deletePersonVisit", map) != 1) {
            throw new CustomException("删除失败");
        }
        return SUCCESS;
    }

    @ApiOperation(value = "回访设置列表",desc = "回访设置列表")
    public Page<Map<String, Object>> findPersonVisitList(Page<Map<String, Object>> page){
        // 兼容前端传参形如 { params: {...filters}, pageNo, pageSize }
        // 有些场景 Page.params 里会再包一层 params，需要拍平
        Map<String, Object> p = page.getParams();
        if (p != null) {
            Object innerParams = p.get("params");
            if (innerParams instanceof Map) {
                @SuppressWarnings("unchecked")
                Map<String, Object> inner = (Map<String, Object>) innerParams;
                Map<String, Object> merged = new java.util.HashMap<>(p);
                merged.remove("params");
                merged.putAll(inner);
                page.setParams(merged);
            }
        }
        return commonService.findPage(namespace + "findPersonVisitList", page);
    }

    @ApiOperation(value = "回访单人详情",desc = "回访单人详情")
    public Map<String, Object> getPersonVisitRecord(Map<String, Object> map){
        Map<String, Object> recordMap = commonService.getObject(namespace + "getPersonVisitRecord",map);
        recordMap.put("rating_type",commonService.getObject(namespace +"getRatingSummary",map));
        recordMap.put("VisitRecordList",commonService.findList(namespace + "selectPersonVisitRecordList",map));
        return recordMap;
    }

    @ApiOperation(value = "添加回访",desc = "添加回访")
    public String insertPersonVisitRecord(Map<String, Object> map){
        if (commonService.update(namespace + "updatePersonVisitHistory",map) < 1){
            throw new CustomException("修改历史失败");
        }
        if (commonService.insert(namespace + "insertPersonVisitRecord",map) != 1){
            throw new CustomException("添加失败");
        }
        return SUCCESS;
    }

    @ApiOperation(value = "更新回访设置状态",desc = "启用/停用回访设置")
    public String updatePersonVisitStatus(Map<String, Object> map){
        // 当启用时，先将同分类同风险的其他记录置为停用
        if ("1".equals(String.valueOf(map.get("status")))){
            commonService.update(namespace + "disableOtherActives", map);
        }
        if (commonService.update(namespace + "updatePersonVisitStatus", map) != 1){
            throw new CustomException("更新状态失败");
        }
        return SUCCESS;
    }
}
