package com.scpyun.platform.jilinsscgsdp.service.impl;

import java.util.Date;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.google.common.collect.Maps;
import com.scpyun.base.bean.Page;
import com.scpyun.base.core.annotation.Api;
import com.scpyun.base.core.annotation.ApiOperation;
import com.scpyun.base.core.exception.CustomException;
import com.scpyun.base.core.utils.StringUtils;
import com.scpyun.base.core.utils.UUIDUtil;
import com.scpyun.base.db.service.CommonService;
import com.scpyun.platform.jilinsscgsdp.bean.bo.UserInfoBo;


@Api("党群服务")
@Service("partyAMassService")
public class PartyAMassServiceImpl {

    private String name_Space = "com.scpyun.platform.standard.dq.partyandmassservice.";
    private String nameSpace_gridLevel = "com.scpyun.platform.standard.jilinsscgsdp.gridLevel.";
    @Autowired
    CommonService commonService;


    @ApiOperation(value = "添加党组织信息")
    public String addPartOrgInfo(Map<String, Object> map) {
        String garden_id = map.get("garden_id").toString();
        Map<String,Object> param = Maps.newHashMap();
        param.put("id",garden_id);
        Map<String, Object> resultMap = commonService.getObject(nameSpace_gridLevel+"getGridGardenById", param);
        
        if (StringUtils.isEmpty(map.get("org_code"))) {
            throw new CustomException("缺少党组织编码！");
        }
        if (StringUtils.isEmpty(map.get("org_name"))) {
            throw new CustomException("缺少党组织名称！");
        }
        if (StringUtils.isEmpty(map.get("csc_mapjson_ht"))) {
            throw new CustomException("缺少党组织定位！");
        }
        int count = commonService.getObject(name_Space + "findOrgByCodeCount", map);
        if (count > 0) {
            throw new CustomException("党支部编码重复，请勿使用重复的编码");
        }
        UserInfoBo userInfo = UserInfoBo.getUserInfo(map);
        map.put("create_time", new Date());
        map.put("create_by", userInfo.getLoginName());
        map.put("id", UUIDUtil.getUUID());
        map.put("org_name", StringUtils.toString(map.get("org_name")).trim());
        map.put("org_code", StringUtils.toString(map.get("org_code")).trim());
        map.put("city_id",resultMap.get("city_id"));
        map.put("area_id",resultMap.get("area_id"));
        map.put("street_id",resultMap.get("street_id"));
        map.put("community_id",resultMap.get("community_id"));
        
        if (commonService.insert(name_Space + "insertSelective", map) == 0) {
            throw new CustomException("添加党组织信息失败");
        }
        return "SUCCESS";
    }

    @ApiOperation(value = "修改党组织信息")
    public String updatePartOrgInfo(Map<String, Object> map) {
    	if (StringUtils.isEmpty(map.get("id"))) {
            throw new CustomException("缺少主键！");
        }
        if (StringUtils.isEmpty(map.get("org_code"))) {
            throw new CustomException("缺少党组织编码！");
        }
        if (StringUtils.isEmpty(map.get("org_name"))) {
            throw new CustomException("缺少党组织名称！");
        }
        if (StringUtils.isEmpty(map.get("csc_mapjson_ht"))) {
            throw new CustomException("缺少党组织定位！");
        }
        int count = commonService.getObject(name_Space + "findOrgByCodeCount", map);
        if (count > 0) {
            throw new CustomException("党支部编码重复，请勿使用重复的编码");
        }
        UserInfoBo userInfo = UserInfoBo.getUserInfo(map);
        map.put("update_time", new Date());
        map.put("update_by", userInfo.getLoginName());

        if (commonService.update(name_Space + "updateByPrimaryKeySelective", map) == 0) {
            throw new CustomException("修改党组织信息失败");
        }

        return "SUCCESS";
    }

    @ApiOperation(value = "查询党组织信息列表")
    public Page findPartOrgInfoList(Page page) {
        return commonService.findPage(name_Space + "findPartOrgInfoList", page);
    }

    @ApiOperation(value = "删除党组织信息")
    public String deletePartOrgInfo(Map<String, Object> map) {
        if (commonService.delete(name_Space + "deletePartOrgInfo", map) == 0) {
            throw new CustomException("删除党组织信息失败");
        }
        return "SUCCESS";
    }

}