package com.scpyun.platform.jilinsscgsdp.bean.vo.task;

import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Update;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.Pattern;
import java.util.Date;

/**
 * @Author liu
 * @Date 2024/10/11 14:18
 * @PackageName:com.scpyun.platform.jilinexchange.bean.vo
 * @ClassName: ReqUserVo
 * @Description: TODO
 * @Version 1.0
 */
public class ReqUserVo extends ReqBaseVo{
    /**
     * 主键
     */
    @NotEmpty(message = "id不可为空",groups = {Insert.class,Update.class,Delete.class})
    @Length(min=1, max=200,message = "id数据长度范围1到200",groups = {Insert.class,Update.class,Delete.class})
    private String id;

    /**
     * 是否常住，0：常住，1：流动
     */
    @Pattern(regexp = "^[0-1]$", message = "是否常住字典值不合法",groups = {Insert.class,Update.class})
    private String userType;

    /**
     * 是否户籍，0：是户籍，1：非户 籍
     */
    @Pattern(regexp = "^[0-1]$", message = "户籍字典值不合法",groups = {Insert.class,Update.class})
    private String hujiType;
    
    /**
     * 是否空挂户   0:是，1:否
     */
//    @NotEmpty(message = "是否空挂户不可为空",groups = {Insert.class,Update.class})
    @Pattern(regexp = "^[0-1]$", message = "是否空挂户字典值不合法",groups = {Insert.class,Update.class})
    private String isKgh;
    
    /**
     * 与户主关系 0:户主 1:配偶 2:子女3:父母 4:岳父岳母或公婆 5:祖父母 6:媳婿 7:孙子女 8:兄弟姐妹 9:外孙子女 10:租户 11:其他
     */
//    @Pattern(regexp = "^[0-11]$", message = "与户主关系字典值不合法",groups = {Insert.class,Update.class})
    private String relation;
    
    /**
     * 是否居住，0：居住，1：非居住
     */
//    @NotEmpty(message = "是否居住不可为空",groups = {Insert.class,Update.class})
    @Pattern(regexp = "^[0-1]$", message = "是否居住字典值不合法",groups = {Insert.class,Update.class})
    private String juzhuType;

    /**
     * 居住情况 1:自住 2:租住 3:借住 4: 其他
     */
    @Pattern(regexp = "^[1-4]$", message = "居住情况字典值不合法",groups = {Insert.class,Update.class})
    private String livingCondition;

    /**
     * 姓名
     */
    @NotEmpty(message = "姓名不可为空")
    @Length(min=1, max=40,message = "姓名数据长度范围1到40",groups = {Update.class,Delete.class})
    private String userName;

    /**
     * 证件号类别 证件类型 证件类别 1:身份证 2:护照 3:台湾居民来往大陆通行证 4: 港澳居民来往内地通行证 5:外国 人永久居留身份证 6:台湾居民居 住证 7:港澳居民居住证
     */
    @NotEmpty(message = "证件号类别不可为空")
    @Pattern(regexp = "^[1-7]$", message = "证件号类别字典值不合法",groups = {Insert.class,Update.class})
    private String cardType;

    /**
     * 证件号
     */
    @NotEmpty(message = "证件号不可为空")
    @Length(min=1, max=40,message = "证件号数据长度范围1到40",groups = {Update.class,Delete.class})
    private String cardno;

    /**
     * 联系方式
     */
    @NotEmpty(message = "联系方式不可为空")
    @Length(min=1, max=40,message = "联系方式数据长度范围1到40",groups = {Update.class,Delete.class})
    private String tel;

    /**
     * 民族
     */
    private String folk;

    /**
     * 性别
     */
    @NotEmpty(message = "性别不可为空")
    @Pattern(regexp = "^[1-2]$", message = "性别字典值不合法",groups = {Insert.class,Update.class})
    private String sex;

    /**
     * 政治面貌
     * 1:群众 2:共产党员 3:共产主义青年团团员 4:国民党革命委员会会员 5:民主同盟盟员 6:民主建国会会员 7:民主促进会会员 8:农工民主党党员 9:致公党党员 10:九三学社社员 11:台湾民主自治同盟盟员 12:无党派民主人士
     */
    @Pattern(regexp = "^[1-12]$", message = "政治面貌字典值不合法",groups = {Insert.class,Update.class})
    private String politicalOutlook;

    /**
     * 市编码
     */
    @NotEmpty(message = "市编码不可为空")
    @Pattern(regexp = "^\\d{12}$", message = "市编码格式异常",groups = {Insert.class,Update.class})
    private String cityCode;

    /**
     * 区编码
     */
    @NotEmpty(message = "区编码不可为空")
    @Pattern(regexp = "^\\d{12}$", message = "区编码格式异常",groups = {Insert.class,Update.class})
    private String areaCode;

    /**
     * 街道编码
     */
    @NotEmpty(message = "街道编码不可为空")
    @Pattern(regexp = "^\\d{12}$", message = "街道编码格式异常",groups = {Insert.class,Update.class})
    private String streetCode;

    /**
     * 社区编码
     */
    @NotEmpty(message = "社区编码不可为空")
    @Pattern(regexp = "^\\d{12}$", message = "社区编码格式异常",groups = {Insert.class,Update.class})
    private String communityCode;

    /**
     * 网格id
     */
    @NotEmpty(message = "网格id不可为空")
    @Length(min=1, max=36,message = "网格ID数据长度范围1到36",groups = {Insert.class,Update.class})
    private String gardenId;

    /**
     * 楼id
     */
    @NotEmpty(message = "楼id不可为空")
    @Length(min=1, max=36,message = "楼ID数据长度范围1到36",groups = {Insert.class,Update.class})
    private String buildingId;

    /**
     * 单元id
     */
    @NotEmpty(message = "单元id不可为空")
    @Length(min=1, max=36,message = "单元ID数据长度范围1到36",groups = {Insert.class,Update.class})
    private String unitId;

    /**
     * 层id
     */
    @NotEmpty(message = "层id不可为空")
    @Length(min=1, max=36,message = "层ID数据长度范围1到36",groups = {Insert.class,Update.class})
    private String doorplateId;

    /**
     * 户id
     */
    @NotEmpty(message = "户id不可为空")
    @Length(min=1, max=36,message = "户ID数据长度范围1到36",groups = {Insert.class,Update.class})
    private String floorId;

    /**
     * 户籍地址
     */
    @Length(max=100,message = "户籍地址数据长度上限100",groups = {Insert.class,Update.class})
    private String hjAddress;

    /**
     * 现居住地址
     */
    @Length(max=100,message = "现居住地址数据长度上限100",groups = {Insert.class,Update.class})
    private String nowAddress;
    
    /**
     * 备注
     */
    @Length(max=200,message = "备注数据长度上限200",groups = {Insert.class,Update.class})
    private String remarks;

    /**
     * appid
     */
    @NotEmpty(message = "appid不可为空")
    @Length(min=1, max=36,message = "appid数据长度范围1到36",groups = {Insert.class,Update.class})
    private String appid;

    /**
     * 地市对接id
     */
    private String dockingId;

    /**
     * 添加状态
     */
    private String type;

    /**
     * 操作状态 1成功 2失败
     */
    private String operateType;
    
    private String createBy;
    
    private Date createTime;
    
    private String updateBy;
    
    private Date updateTime;

    private Integer intId;

    public Integer getIntId() {
        return intId;
    }

    public void setIntId(Integer intId) {
        this.intId = intId;
    }
    public String getCreateBy() {
		return createBy;
	}

	public void setCreateBy(String createBy) {
		this.createBy = createBy;
	}

	public Date getCreateTime() {
		return createTime;
	}

	public void setCreateTime(Date createTime) {
		this.createTime = createTime;
	}

	public String getUpdateBy() {
		return updateBy;
	}

	public void setUpdateBy(String updateBy) {
		this.updateBy = updateBy;
	}

	public Date getUpdateTime() {
		return updateTime;
	}

	public void setUpdateTime(Date updateTime) {
		this.updateTime = updateTime;
	}

	public String getNowAddress() {
		return nowAddress;
	}

	public void setNowAddress(String nowAddress) {
		this.nowAddress = nowAddress;
	}

	public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getUserType() {
        return userType;
    }

    public void setUserType(String userType) {
        this.userType = userType;
    }

    public String getHujiType() {
        return hujiType;
    }

    public void setHujiType(String hujiType) {
        this.hujiType = hujiType;
    }

    public String getRelation() {
        return relation;
    }

    public void setRelation(String relation) {
        this.relation = relation;
    }

    public String getLivingCondition() {
        return livingCondition;
    }

    public void setLivingCondition(String livingCondition) {
        this.livingCondition = livingCondition;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getCardType() {
        return cardType;
    }

    public void setCardType(String cardType) {
        this.cardType = cardType;
    }

    public String getCardno() {
        return cardno;
    }

    public void setCardno(String cardno) {
        this.cardno = cardno;
    }

    public String getTel() {
        return tel;
    }

    public void setTel(String tel) {
        this.tel = tel;
    }

    public String getFolk() {
        return folk;
    }

    public void setFolk(String folk) {
        this.folk = folk;
    }

    public String getSex() {
        return sex;
    }

    public void setSex(String sex) {
        this.sex = sex;
    }

    public String getPoliticalOutlook() {
        return politicalOutlook;
    }

    public void setPoliticalOutlook(String politicalOutlook) {
        this.politicalOutlook = politicalOutlook;
    }

    public String getCityCode() {
        return cityCode;
    }

    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }

    public String getAreaCode() {
        return areaCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    public String getStreetCode() {
        return streetCode;
    }

    public void setStreetCode(String streetCode) {
        this.streetCode = streetCode;
    }

    public String getCommunityCode() {
        return communityCode;
    }

    public void setCommunityCode(String communityCode) {
        this.communityCode = communityCode;
    }

    public String getGardenId() {
        return gardenId;
    }

    public void setGardenId(String gardenId) {
        this.gardenId = gardenId;
    }

    public String getBuildingId() {
        return buildingId;
    }

    public void setBuildingId(String buildingId) {
        this.buildingId = buildingId;
    }

    public String getUnitId() {
        return unitId;
    }

    public void setUnitId(String unitId) {
        this.unitId = unitId;
    }

    public String getDoorplateId() {
        return doorplateId;
    }

    public void setDoorplateId(String doorplateId) {
        this.doorplateId = doorplateId;
    }

    public String getFloorId() {
        return floorId;
    }

    public void setFloorId(String floorId) {
        this.floorId = floorId;
    }

    public String getHjAddress() {
        return hjAddress;
    }

    public void setHjAddress(String hjAddress) {
        this.hjAddress = hjAddress;
    }

    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public String getAppid() {
        return appid;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public String getDockingId() {
        return dockingId;
    }

    public void setDockingId(String dockingId) {
        this.dockingId = dockingId;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getOperateType() {
        return operateType;
    }

    public void setOperateType(String operateType) {
        this.operateType = operateType;
    }

	public String getIsKgh() {
		return isKgh;
	}

	public void setIsKgh(String isKgh) {
		this.isKgh = isKgh;
	}

	public String getJuzhuType() {
		return juzhuType;
	}

	public void setJuzhuType(String juzhuType) {
		this.juzhuType = juzhuType;
	}
    
}
