package com.scpyun.platform.jilinsscgsdp.service.impl;

import com.scpyun.base.core.annotation.Api;
import com.scpyun.base.core.annotation.ApiOperation;
import com.scpyun.base.core.exception.CustomException;
import com.scpyun.base.core.utils.StringUtils;
import com.scpyun.base.db.service.CommonService;
import com.scpyun.platform.jilinsscgsdp.constant.NotesConstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * @Author liu
 * @Date 2025/11/26 13:01
 * @PackageName:com.scpyun.platform.jilinsscgsdp.service.impl
 * @ClassName: ConstructionSelectionServiceImpl
 * @Description: TODO
 * @Version 1.0
 */
@Api("综治中心规范化建设运行情况")
@Service("constructionSelection")
public class ConstructionSelectionServiceImpl {
    @Autowired
    CommonService commonService;

    private String nameSpace = "com.scpyun.platform.standard.jilinsscgsdp.constructionSelection.";

    @ApiOperation(value = "添加综治中心规范化建设运行情况", desc = "添加综治中心规范化建设运行情况")
    public String insertComprehensiveGovernance(Map<String, Object> map) {
        Map<String, Object> officeMap = commonService.getObject(nameSpace + "selectOfficeGradeParent", map);
        Map<String, Object> user = (Map<String, Object>) map.get("_user");
        if ("3".equals(StringUtils.toStr(user.get("company_grade")))) {
            map.put("city_id", officeMap.get("area_id"));
            map.put("city_name", officeMap.get("area_name"));
            map.put("area_id", officeMap.get("area_id"));
            map.put("area_name", officeMap.get("area_name"));
            map.put("grade","2");
            Integer count = commonService.getObject(nameSpace + "getCountComprehensiveGovernanceCity", map);
            if (count > 0) {
                throw new CustomException("只可以添加一条数据！");
            }
        } else {
            map.put("grade","3");
            map.putAll(officeMap);
            Integer count = commonService.getObject(nameSpace + "getCountComprehensiveGovernance", map);
            if (count > 0) {
                throw new CustomException("只可以添加一条数据！");
            }
        }
        if (commonService.insert(nameSpace + "insertComprehensiveGovernance", map) != 1) {
            throw new CustomException("添加失败！");
        }
        return NotesConstant.SAVE_SUCCESS;
    }

    @ApiOperation(value = "修改综治中心规范化建设运行情况", desc = "修改综治中心规范化建设运行情况")
    public String updateComprehensiveGovernance(Map<String, Object> map) {
        if (commonService.update(nameSpace + "updateComprehensiveGovernance", map) != 1) {
            throw new CustomException("修改失败！");
        }
        return NotesConstant.SAVE_SUCCESS;
    }

    @ApiOperation(value = "查询综治中心规范化建设运行情况", desc = "查询综治中心规范化建设运行情况")
    public List<Map<String, Object>> selectComprehensiveGovernanceList(Map<String, Object> map) {
        Map<String, Object> officeMap = commonService.getObject(nameSpace + "selectOfficeGradeParent", map);
        Map<String, Object> user = (Map<String, Object>) map.get("_user");
        if ("3".equals(StringUtils.toStr(user.get("company_grade")))) {
            map.put("city_id", officeMap.get("area_id"));
            map.put("city_name", officeMap.get("area_name"));
        } else {
            map.putAll(officeMap);
        }
        return commonService.findList(nameSpace + "selectComprehensiveGovernanceList", map);
    }

    @ApiOperation(value = "查询综治中心规范化建设运行情况统计", desc = "查询综治中心规范化建设运行情况统计")
    public List<Map<String, Object>> selectComprehensiveGovernanceCountList(Map<String, Object> map) {
        /*Map<String, Object> user = (Map<String, Object>) map.get("_user");
        if ("3".equals(StringUtils.toStr(user.get("company_grade")))) {
            Map<String, Object> officeMap = commonService.getObject(nameSpace + "selectOfficeGradeParent", map);
            map.put("city_id", officeMap.get("area_id"));
        }*/
        return commonService.findList(nameSpace + "selectComprehensiveGovernanceCountList", map);
    }

    @ApiOperation(value = "查询综治中心规范化建设运行情况详情", desc = "查询综治中心规范化建设运行情况详情")
    public Map<String, Object> getComprehensiveGovernance(Map<String, Object> map) {
        return commonService.getObject(nameSpace + "getComprehensiveGovernance", map);
    }
}
