package com.scpyun.platform.jilinsscgsdp.service.impl;

import com.scpyun.base.bean.Page;
import com.scpyun.base.core.annotation.Api;
import com.scpyun.base.core.annotation.ApiOperation;
import com.scpyun.base.core.exception.CustomException;
import com.scpyun.base.core.utils.UUIDUtil;
import com.scpyun.base.db.service.CommonService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.support.ExcelTypeEnum;
import com.scpyun.platform.jilinsscgsdp.utils.MaterialFileListener;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.web.multipart.MultipartFile;
import javax.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.List;
import java.io.IOException;

@Api("办公用品管理")
@Service("keyDmMaterial")
public class KeyDmMaterialServiceImpl {
    @Autowired
    private CommonService commonService;

    private static final String SUCCESS = "success";
    private final String namespace = "com.scpyun.platform.standard.jilinsscgsdp.keyDmMaterial.";

    @ApiOperation(value = "查询办公用品列表", desc = "分页查询办公用品")
    public Page<Map<String, Object>> selectList(Page<Map<String, Object>> map) {
        if (map == null) {
            map = new Page<>();
        }
        return commonService.findPage(namespace + "selectList", map);
    }

    @ApiOperation(value = "保存办公用品", desc = "新增或修改办公用品")
    public String save(Map<String, Object> map) {
        if (map == null) {
            throw new CustomException("参数不能为空");
        }
        Object id = map.get("id");
        if (id == null || String.valueOf(id).trim().isEmpty()) {
            // 新增
            map.put("id", UUIDUtil.getUUID());
            if (commonService.insert(namespace + "insert", map) != 1) {
                throw new CustomException("保存失败");
            }
        } else {
            // 修改
            int affected = commonService.update(namespace + "update", map);
            if (affected < 0) {
                throw new CustomException("保存失败");
            }
        }
        return SUCCESS;
    }

    @ApiOperation(value = "删除办公用品", desc = "逻辑删除办公用品")
    public String delete(Map<String, Object> map) {
        if (map == null || map.get("id") == null) {
            throw new CustomException("参数不能为空");
        }
        int affected = commonService.update(namespace + "delete", map);
        if (affected < 0) {
            throw new CustomException("删除失败");
        }
        return SUCCESS;
    }

    @ApiOperation(value = "导入物料", desc = "解析 Excel 导入物料信息")
    public Map<String, Object> importExcel(Map<String, Object> map, MultipartFile file) {
        Map<String, Object> result = new HashMap<>();
        try {
            MaterialFileListener listener = new MaterialFileListener(commonService, namespace, map);
            EasyExcel.read(file.getInputStream(), com.scpyun.platform.jilinsscgsdp.bean.entity.MaterialImp.class, listener).sheet().headRowNumber(1).doRead();
            result = listener.getResult();
        } catch (IOException e) {
            throw new CustomException("导入失败");
        }
        return result;
    }

    @ApiOperation(value = "导入模板下载", desc = "下载物料导入模板")
    public void templateDownload(Map<String, Object> map, HttpServletResponse response) {
        response.setContentType("application/application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setCharacterEncoding("utf-8");
        try {
            String fileName = URLEncoder.encode("物料导入模板", "UTF-8").replaceAll("\\+", "%20");
            response.setHeader("Content-disposition", "attachment;filename*=utf-8''" + fileName + ".xlsx");
            response.setHeader("filename", fileName + ".xlsx");
            response.setHeader("Access-Control-Expose-Headers", "filename,Content-Disposition");

            String tpl = "keyMaterialImp.xlsx";
            Resource resource = new ClassPathResource(tpl);
            InputStream is = resource.getInputStream();
            ExcelWriter excelWriter = EasyExcel.write(response.getOutputStream()).withTemplate(is).excelType(ExcelTypeEnum.XLSX).build();
            excelWriter.finish();
        } catch (Exception e) {
            throw new CustomException("模板下载失败");
        }
    }
}

