package com.scpyun.platform.jilinsscgsdp.task.impl;

import com.scpyun.base.core.utils.SpringContextHolder;
import com.scpyun.base.core.utils.StringUtils;
import com.scpyun.base.core.utils.UnifyLogger;
import com.scpyun.base.db.service.CommonService;
import com.scpyun.platform.jilinsscgsdp.bean.entity.task.JlEvent;
import com.scpyun.platform.jilinsscgsdp.bean.entity.task.JlEventFLowLog;
import com.scpyun.platform.jilinsscgsdp.bean.entity.task.JlEventUser;
import com.scpyun.platform.jilinsscgsdp.bean.vo.ReqEventInsertVo;
import com.scpyun.platform.jilinsscgsdp.bean.vo.ReqEventUserInsertVo;
import com.scpyun.platform.jilinsscgsdp.bean.vo.task.ReqTaskVo;
import com.scpyun.platform.jilinsscgsdp.constant.task.Constant;
import com.scpyun.platform.jilinsscgsdp.constant.task.NumberConstant;
import com.scpyun.platform.jilinsscgsdp.service.impl.EventServiceImpl;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.springframework.beans.BeanUtils;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.concurrent.TimeUnit;

/**
 * @Author liu
 * @Date 2024/6/5 15:05
 * @PackageName:com.scpyun.platform.jilinsscgsdp.task.impl
 * @ClassName: AutoSynchronizeDataTask
 * @Description: TODO
 * @Version 1.0
 */
@Component
public class EventTask {

    CommonService commonService = SpringContextHolder.getBean(CommonService.class);
    RedissonClient redissonClient = SpringContextHolder.getBean(RedissonClient.class);
    private final String nameSpace = "com.scpyun.platform.standard.jilinsscgsdp.eventTask.";

    EventServiceImpl eventService = SpringContextHolder.getBean(EventServiceImpl.class);

    @Scheduled(cron = "0 */5 * * * ?")
    public void eventTask() {
        RLock rLock = redissonClient.getLock("jilinexchange:eventTask");
        ReqTaskVo task = new ReqTaskVo();
        try {
            if (rLock.tryLock(0, TimeUnit.SECONDS)) {
                List<JlEvent> eventList = commonService.findList(nameSpace + "selectEventTaskList", null);
                for (JlEvent event : eventList) {
                    try {
                        task.setOperateType(NumberConstant.ONE_STRING);
                        switch (Constant.TypeEnum.getType(event.getType())) {
                            case INSERT:
                                commonService.insert(nameSpace + "insertEventTask", event);
                                // 重点事
                                ReqEventInsertVo vo = new ReqEventInsertVo();
                                BeanUtils.copyProperties(event, vo);
                                eventService.recordEventTrigger(vo);
                                break;
                            case UPDATE:
                                commonService.update(nameSpace + "updateEventTask", event);
                                break;
                            case DELETE:
                                String eventId = commonService.getObject(nameSpace + "getNonePostEventId", event);
                                commonService.update(nameSpace + "deleteEvent", event);
                                if (StringUtils.isNotEmpty(eventId)) {
                                    commonService.delete(nameSpace + "deleteEventFlow", eventId);
                                    commonService.delete(nameSpace + "deleteEventCount", eventId);
                                    commonService.delete(nameSpace + "deleteEventFlowCount", eventId);
                                }
                                break;
                            default:
                                throw new Exception("type 异常！");
                        }
                    } catch (Exception e) {
                        UnifyLogger.parent(UnifyLogger.getTrace(e), UnifyLogger.Level.INFO);
                        task.setOperateType(NumberConstant.TWO_STRING);
                    } finally {
                        task.setIntId(event.getIntId());
                        task.setAppid(event.getAppid());
                        task.setDockingId(event.getDockingId());
                        commonService.update(nameSpace + "updateOperateTypeEvent", task);
                    }
                }
            }
        } catch (Exception e) {
            UnifyLogger.parent(UnifyLogger.getTrace(e), UnifyLogger.Level.INFO);
        } finally {
            if (rLock.isHeldByCurrentThread()) {
                rLock.unlock();
            }
        }
    }

    @Scheduled(cron = "0 */5 * * * ?")
    public void eventFlowLogTask() {
        RLock rLock = redissonClient.getLock("jilinexchange:eventFlowLogTask");
        ReqTaskVo task = new ReqTaskVo();
        try {
            if (rLock.tryLock(0, TimeUnit.SECONDS)) {
                List<JlEventFLowLog> eventFlowLogList = commonService.findList(nameSpace + "selectEventFlowLogTaskList", null);
                for (JlEventFLowLog eventFlowLog : eventFlowLogList) {
                    try {
                        task.setOperateType(NumberConstant.ONE_STRING);
                        switch (Constant.TypeEnum.getType(eventFlowLog.getType())) {
                            case INSERT:
                                commonService.insert(nameSpace + "insertEventFlowLogTask", eventFlowLog);
                                break;
                            case UPDATE:
                                commonService.update(nameSpace + "updateEventFlowLogTask", eventFlowLog);
                                break;
                            case DELETE:
                                commonService.update(nameSpace + "deleteEventFlowLog", eventFlowLog);
                            default:
                                throw new Exception("type 异常！");
                        }
                    } catch (Exception e) {
                        UnifyLogger.parent(UnifyLogger.getTrace(e), UnifyLogger.Level.INFO);
                        task.setOperateType(NumberConstant.TWO_STRING);
                    } finally {
                        task.setIntId(eventFlowLog.getIntId());
                        task.setAppid(eventFlowLog.getAppid());
                        task.setDockingId(eventFlowLog.getDockingId());
                        commonService.update(nameSpace + "updateOperateTypeEventFlowLog", task);
                    }
                }
            }

        } catch (Exception e) {
            UnifyLogger.parent(UnifyLogger.getTrace(e), UnifyLogger.Level.INFO);
        } finally {
            if (rLock.isHeldByCurrentThread()) {
                rLock.unlock();
            }
        }
    }

    @Scheduled(cron = "0 */5 * * * ?")
    public void eventUserTask() {
        RLock rLock = redissonClient.getLock("jilinexchange:eventUserTask");
        ReqTaskVo task = new ReqTaskVo();
        try {
            if (rLock.tryLock(0, TimeUnit.SECONDS)) {
                List<JlEventUser> eventUserList = commonService.findList(nameSpace + "selectEventUserTaskList", null);
                for (JlEventUser eventUser : eventUserList) {
                    try {
                        task.setOperateType(NumberConstant.ONE_STRING);
                        switch (Constant.TypeEnum.getType(eventUser.getType())) {
                            case INSERT:
                                commonService.insert(nameSpace + "insertEventUserTask", eventUser);
                                ReqEventUserInsertVo eventUserInsertVo = new ReqEventUserInsertVo();
                                BeanUtils.copyProperties(eventUser, eventUserInsertVo);
                                eventService.recordTriggerEvent(eventUserInsertVo);
                                break;
                            case UPDATE:
                                commonService.update(nameSpace + "updateEventUserTask", eventUser);
                                break;
                            case DELETE:
                                commonService.delete(nameSpace + "deleteEventUser", eventUser);
                                break;
                            default:
                                throw new Exception("type 异常！");
                        }
                    } catch (Exception e) {
                        UnifyLogger.parent(UnifyLogger.getTrace(e), UnifyLogger.Level.INFO);
                        task.setOperateType(NumberConstant.TWO_STRING);
                    } finally {
                        task.setIntId(eventUser.getIntId());
                        task.setAppid(eventUser.getAppid());
                        task.setDockingId(eventUser.getDockingId());
                        commonService.update(nameSpace + "updateOperateTypeEventUser", task);
                    }
                }
            }
        } catch (Exception e) {
            UnifyLogger.parent(UnifyLogger.getTrace(e), UnifyLogger.Level.INFO);
        } finally {
            if (rLock.isHeldByCurrentThread()) {
                rLock.unlock();
            }
        }
    }
}
