package com.scpyun.platform.jilinsscgsdp.service.impl;


import com.scpyun.base.core.annotation.Api;
import com.scpyun.base.core.annotation.ApiOperation;
import com.scpyun.base.core.exception.CustomException;
import com.scpyun.base.core.utils.StringUtils;
import com.scpyun.base.core.utils.UUIDUtil;
import com.scpyun.base.db.service.CommonService;
import com.scpyun.platform.jilinsscgsdp.bean.entity.EventCategory;
import com.scpyun.platform.jilinsscgsdp.bean.entity.EventCategoryOther;
import com.scpyun.platform.jilinsscgsdp.bean.entity.RiskFactor;
import org.aspectj.weaver.ast.Var;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Api("纠纷类型管理")
@Service("EventCategoryServiceImpl")
public class EventCategoryServiceImpl {

    @Autowired
    CommonService commonService;

    private final String nameSpace = "com.scpyun.platform.standard.jilinsscgsdp.EventCategoryDao.";

    @ApiOperation(value = "纠纷类型列表")
    public List<EventCategory> selectEventCategoryList(EventCategory eventCategory) {
        // 单次查询所有子类别，包括一级和多级
        List<EventCategory> allCategories = commonService.findList(nameSpace + "selectEventCategoryList", eventCategory);
        if (allCategories == null || allCategories.isEmpty()) {
            return Collections.emptyList();
        }

        // 使用一个Map，key为parentId，value为该parentId的所有子分类列表
        Map<String, List<EventCategory>> parentIdMap = allCategories.stream()
                .collect(Collectors.groupingBy(EventCategory::getParent_id));

        // 找出顶级(即parentId=0的)分类
        List<EventCategory> rootCategories = parentIdMap.getOrDefault("0", new ArrayList<>());

        // 递归组装树结构
        rootCategories.forEach(category -> buildTree(category, parentIdMap));

        return rootCategories;
    }

    /**
     * 递归组装子节点
     */
    private void buildTree(EventCategory category, Map<String, List<EventCategory>> parentIdMap) {
        List<EventCategory> children = parentIdMap.getOrDefault(category.getId(), new ArrayList<>());
        category.setChild(children);
        if (!children.isEmpty()) {
            children.forEach(child -> buildTree(child, parentIdMap));
        }
    }

    @ApiOperation(value = "添加纠纷类型")
    public void insertEventCategory(EventCategory eventCategory) {
        commonService.insert(nameSpace + "insertEventCategory", eventCategory);
    }

    @ApiOperation(value = "修改纠纷类型")
    public void updateEventCategory(EventCategory eventCategory) {
        commonService.update(nameSpace + "updateEventCategory", eventCategory);
    }


    @ApiOperation(value = "手动填报纠纷类型列表")
    public List<EventCategoryOther> selectEventCategoryOtherList(EventCategoryOther eventCategoryOther) {
        return commonService.findList(nameSpace + "selectEventCategoryOtherList", eventCategoryOther);
    }

    @ApiOperation(value = "删除/修改手动填报纠纷类型")
    public void updateEventCategoryOther(EventCategoryOther eventCategoryOther) {
        commonService.update(nameSpace + "updateEventCategoryOther", eventCategoryOther);
    }


}
