package com.scpyun.platform.jilinsscgsdp.task.impl;

import cn.hutool.core.map.MapUtil;
import com.scpyun.base.core.utils.UnifyLogger;
import com.scpyun.base.db.service.CommonService;
import com.scpyun.platform.jilinsscgsdp.bean.bo.task.ExecutorUserBo;
import com.scpyun.platform.jilinsscgsdp.bean.vo.task.*;
import com.scpyun.platform.jilinsscgsdp.constant.task.Constant;
import com.scpyun.platform.jilinsscgsdp.constant.task.Constant.TypeEnum;
import com.scpyun.platform.jilinsscgsdp.constant.task.NumberConstant;
import com.scpyun.platform.jilinsscgsdp.utils.LatitudeLongitudeUtils;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;


@Component
public class GardenTask {

	@Autowired
	private CommonService commonService;

	@Autowired
	private RedissonClient redissonClient;

    private static final Logger log = LoggerFactory.getLogger(GardenTask.class);

    private final String nameSpace = "com.scpyun.platform.standard.jilinsscgsdp.gardenTask.";

	@Scheduled(cron = "0 */10 * * * ?")
	public void officeDataExecutor() {
		RLock rLock = redissonClient.getLock("jilinexchange:officeDataExecutor");
		try {
			if(rLock.tryLock(0, TimeUnit.SECONDS)){
				List<ReqGardenVo> dataList = commonService.findList(nameSpace + "selectGardenOfficeTaskList", MapUtil.empty());
				for(ReqGardenVo vo:dataList) {
					vo.setOperateType(Constant.OPERATE_TYPE_SUCCESS);
					vo.setCscMapjson(LatitudeLongitudeUtils.latitudeLongitudeFist(vo.getCscMapjsonHt()));
//				vo.setCscMapjsonHt(LatitudeLongitudeUtils.latitudeLongitude(vo.getCscMapjsonHt()));
					try {
						int insert = commonService.update(nameSpace + "updateOfficeCscMapjsonHt", vo);
						if(insert!=1){
							throw new Exception("数据新增异常");
						}
					} catch (Exception e) {
						UnifyLogger.parent(UnifyLogger.getTrace(e), UnifyLogger.Level.INFO);
						vo.setOperateType(Constant.OPERATE_TYPE_FAIL);
					} finally {
						commonService.update(nameSpace + "updateGardenPostResult", vo);
					}
				}
			}
		} catch (Exception e) {
			UnifyLogger.parent(UnifyLogger.getTrace(e), UnifyLogger.Level.INFO);
		} finally {
			if (rLock.isHeldByCurrentThread()) {
				rLock.unlock();
			}
		}
	}

    @Scheduled(cron = "0 */10 * * * ?")
    public void gardenDataExecutor() {
        RLock rLock = redissonClient.getLock("jilinexchange:gardenDataExecutor");
        try {
			if( rLock.tryLock(0, TimeUnit.SECONDS)){
				List<ReqGardenVo> dataList = commonService.findList(nameSpace + "selectGardenTaskList", MapUtil.empty());
				for(ReqGardenVo vo:dataList) {
					vo.setOperateType(Constant.OPERATE_TYPE_SUCCESS);
					vo.setCscMapjson(LatitudeLongitudeUtils.latitudeLongitudeFist(vo.getCscMapjsonHt()));
//				vo.setCscMapjsonHt(LatitudeLongitudeUtils.latitudeLongitude(vo.getCscMapjsonHt()));
					try {
						switch (TypeEnum.getType(vo.getType())) {
							case INSERT:
								int insert = commonService.insert(nameSpace + "insertGarden", vo);
								if(insert!=1){
									throw new Exception("数据新增异常");
								}
								break;
							case UPDATE:
								int update = commonService.update(nameSpace + "updateGarden", vo);
								if(update!=1){
									throw new Exception("数据未命中，更新异常");
								}
								break;
							case DELETE:
								int delete = commonService.delete(nameSpace + "deleteGarden", vo);
								if(delete!=1){
									throw new Exception("数据未命中，删除异常");
								}
								break;
							default:
								throw new Exception("type 异常！");
						}
					} catch (Exception e) {
						UnifyLogger.parent(UnifyLogger.getTrace(e), UnifyLogger.Level.INFO);
						vo.setOperateType(Constant.OPERATE_TYPE_FAIL);
					} finally {
						commonService.update(nameSpace + "updateGardenPostResult", vo);
					}
				}
			}
		} catch (Exception e) {
            UnifyLogger.parent(UnifyLogger.getTrace(e), UnifyLogger.Level.INFO);
		} finally {
			if (rLock.isHeldByCurrentThread()) {
				rLock.unlock();
			}
		}
    }

	@Scheduled(cron = "0 */10 * * * ?")
	public void residentialDataExecutor() {
		RLock rLock = redissonClient.getLock("jilinexchange:residentialDataExecutor");
		try {
			if(rLock.tryLock(0, TimeUnit.SECONDS)){
				List<ReqGardenVo> dataList = commonService.findList(nameSpace + "selectResidentialTaskList", MapUtil.empty());
				for(ReqGardenVo vo:dataList) {
					vo.setOperateType(Constant.OPERATE_TYPE_SUCCESS);
					vo.setCscMapjsonHt(LatitudeLongitudeUtils.latitudeLongitude(vo.getCscMapjsonHt()));
					try {
						switch (TypeEnum.getType(vo.getType())) {
							case INSERT:
								int insert = commonService.insert(nameSpace + "insertResidentialTask", vo);
								if(insert!=1){
									throw new Exception("数据新增异常");
								}
								break;
							case UPDATE:
								int update = commonService.update(nameSpace + "updateResidentialTask", vo);
								if(update!=1){
									throw new Exception("数据未命中，更新异常");
								}
								break;
							case DELETE:
								int delete = commonService.delete(nameSpace + "deleteResidentialTask", vo);
								if(delete!=1){
									throw new Exception("数据未命中，删除异常");
								}
								break;
							default:
								throw new Exception("type 异常！");
						}
					} catch (Exception e) {
						UnifyLogger.parent(UnifyLogger.getTrace(e), UnifyLogger.Level.INFO);
						vo.setOperateType(Constant.OPERATE_TYPE_FAIL);
					} finally {
						commonService.update(nameSpace + "updateResidentialPostResult", vo);
					}
				}
			}
		} catch (Exception e) {
			UnifyLogger.parent(UnifyLogger.getTrace(e), UnifyLogger.Level.INFO);
		} finally {
			if (rLock.isHeldByCurrentThread()) {
				rLock.unlock();
			}
		}
	}

    @Scheduled(cron = "0 */10 * * * ?")
    public void buildingDataExecutor() {
    	RLock rLock = redissonClient.getLock("jilinexchange:buildingDataExecutor");
        try {
			if(rLock.tryLock(0, TimeUnit.SECONDS)){
				List<ReqBuildingVo> dataList = commonService.findList(nameSpace + "selectBuildingTaskList", MapUtil.empty());
				for(ReqBuildingVo vo:dataList) {
					vo.setOperateType(Constant.OPERATE_TYPE_SUCCESS);
					try {
						switch (TypeEnum.getType(vo.getType())) {
							case INSERT:
								int insert = commonService.insert(nameSpace + "insertBuilding", vo);
								if(insert!=1){
									throw new Exception("数据新增异常");
								}
								break;
							case UPDATE:
								int update = commonService.update(nameSpace + "updateBuilding", vo);
								if(update!=1){
									throw new Exception("数据未命中，更新异常");
								}
								break;
							case DELETE:
								int delete = commonService.delete(nameSpace + "deleteBuilding", vo);
								if(delete!=1){
									throw new Exception("数据未命中，删除异常");
								}
								break;
							default:
								throw new Exception("type 异常！");
						}
					} catch (Exception e) {
						UnifyLogger.parent(UnifyLogger.getTrace(e), UnifyLogger.Level.INFO);
						vo.setOperateType(Constant.OPERATE_TYPE_FAIL);
					} finally {
						commonService.update(nameSpace + "updateBuildingPostResult", vo);
					}
				}
			}
        } catch (Exception e) {
            UnifyLogger.parent(UnifyLogger.getTrace(e), UnifyLogger.Level.INFO);
		} finally {
			if (rLock.isHeldByCurrentThread()) {
				rLock.unlock();
			}
		}
    }

    @Scheduled(cron = "0 */10 * * * ?")
    public void unitDataExecutor() {
    	RLock rLock = redissonClient.getLock("jilinexchange:unitDataExecutor");

        try {
			if(rLock.tryLock(0, TimeUnit.SECONDS)){
				List<ReqUnitVo> dataList = commonService.findList(nameSpace + "selectUnitTaskList", MapUtil.empty());
				for(ReqUnitVo vo:dataList) {
					vo.setOperateType(Constant.OPERATE_TYPE_SUCCESS);
					try {
						switch (TypeEnum.getType(vo.getType())) {
							case INSERT:
								int insert = commonService.insert(nameSpace + "insertUnit", vo);
								if(insert!=1){
									throw new Exception("数据新增异常");
								}
								break;
							case UPDATE:
								int update = commonService.update(nameSpace + "updateUnit", vo);
								if(update!=1){
									throw new Exception("数据未命中，更新异常");
								}
								break;
							case DELETE:
								int delete = commonService.delete(nameSpace + "deleteUnit", vo);
								if(delete!=1){
									throw new Exception("数据未命中，删除异常");
								}
								break;
							default:
								throw new Exception("type 异常！");
						}
					} catch (Exception e) {
						UnifyLogger.parent(UnifyLogger.getTrace(e), UnifyLogger.Level.INFO);
						vo.setOperateType(Constant.OPERATE_TYPE_FAIL);
					} finally {
						commonService.update(nameSpace + "updateUnitPostResult", vo);
					}
				}
			}
        } catch (Exception e) {
            UnifyLogger.parent(UnifyLogger.getTrace(e), UnifyLogger.Level.INFO);
		} finally {
			if (rLock.isHeldByCurrentThread()) {
				rLock.unlock();
			}
		}
    }

    @Scheduled(cron = "0 */10 * * * ?")
    public void floorDataExecutor() {
    	RLock rLock = redissonClient.getLock("jilinexchange:floorDataExecutor");
        try {
			if(rLock.tryLock(0, TimeUnit.SECONDS)){
				List<ReqFloorVo> dataList = commonService.findList(nameSpace + "selectFloorTaskList", MapUtil.empty());
				for(ReqFloorVo vo:dataList) {
					vo.setOperateType(Constant.OPERATE_TYPE_SUCCESS);
					try {
						switch (TypeEnum.getType(vo.getType())) {
							case INSERT:
								int insert = commonService.insert(nameSpace + "insertFloor", vo);
								if(insert!=1){
									throw new Exception("数据新增异常");
								}
								break;
							case UPDATE:
								int update = commonService.update(nameSpace + "updateFloor", vo);
								if(update!=1){
									throw new Exception("数据未命中，更新异常");
								}
								break;
							case DELETE:
								int delete = commonService.delete(nameSpace + "deleteFloor", vo);
								if(delete!=1){
									throw new Exception("数据未命中，删除异常");
								}
								break;
							default:
								throw new Exception("type 异常！");
						}
					} catch (Exception e) {
						UnifyLogger.parent(UnifyLogger.getTrace(e), UnifyLogger.Level.INFO);
						vo.setOperateType(Constant.OPERATE_TYPE_FAIL);
					} finally {
						commonService.update(nameSpace + "updateFloorPostResult", vo);
					}
				}
			}
        } catch (Exception e) {
            UnifyLogger.parent(UnifyLogger.getTrace(e), UnifyLogger.Level.INFO);
		} finally {
			if (rLock.isHeldByCurrentThread()) {
				rLock.unlock();
			}
		}
    }

    @Scheduled(cron = "0 */10 * * * ?")
    public void doorplateDataExecutor() {
    	RLock rLock = redissonClient.getLock("jilinexchange:doorplateDataExecutor");
        try {
			if(rLock.tryLock(0, TimeUnit.SECONDS)){
				List<ReqDoorplateVo> dataList = commonService.findList(nameSpace + "selectDoorplateTaskList", MapUtil.empty());
				for(ReqDoorplateVo vo:dataList) {
					vo.setOperateType(Constant.OPERATE_TYPE_SUCCESS);
					try {
						switch (TypeEnum.getType(vo.getType())) {
							case INSERT:
								int insert = commonService.insert(nameSpace + "insertDoorplate", vo);
								if(insert!=1){
									throw new Exception("数据新增异常");
								}
								break;
							case UPDATE:
								int update = commonService.update(nameSpace + "updateDoorplate", vo);
								if(update!=1){
									throw new Exception("数据未命中，更新异常");
								}
								break;
							case DELETE:
								int delete = commonService.delete(nameSpace + "deleteDoorplate", vo);
								if(delete!=1){
									throw new Exception("数据未命中，删除异常");
								}
								break;
							default:
								throw new Exception("type 异常！");
						}
					} catch (Exception e) {
						UnifyLogger.parent(UnifyLogger.getTrace(e), UnifyLogger.Level.INFO);
						vo.setOperateType(Constant.OPERATE_TYPE_FAIL);
					} finally {
						commonService.update(nameSpace + "updateDoorplatePostResult", vo);
					}
				}
			}
        } catch (Exception e) {
            UnifyLogger.parent(UnifyLogger.getTrace(e), UnifyLogger.Level.INFO);
		} finally {
			if (rLock.isHeldByCurrentThread()) {
				rLock.unlock();
			}
		}
    }

    @Scheduled(cron = "0 */10 * * * ?")
    public void gardenUserDataExecutor() {
    	RLock rLock = redissonClient.getLock("jilinexchange:gardenUserDataExecutor");
        try {
			if(rLock.tryLock(0, TimeUnit.SECONDS)){
				List<ReqGardenUserVo> dataList = commonService.findList(nameSpace + "selectGardenUserTaskList", MapUtil.empty());
				for(ReqGardenUserVo vo:dataList) {
					vo.setOperateType(Constant.OPERATE_TYPE_SUCCESS);
					try {
						switch (TypeEnum.getType(vo.getType())) {
							case INSERT:
								int insert = commonService.insert(nameSpace + "insertGardenUser", vo);
								if(insert!=1){
									throw new Exception("数据新增异常");
								}
								break;
							case UPDATE:
								int update = commonService.update(nameSpace + "updateGardenUser", vo);
								if(update!=1){
									throw new Exception("数据未命中，更新异常");
								}
								break;
							case DELETE:
								int delete = commonService.delete(nameSpace + "deleteGardenUser", vo);
								if(delete!=1){
									throw new Exception("数据未命中，删除异常");
								}
								break;
							default:
								throw new Exception("type 异常！");
						}
					} catch (Exception e) {
						UnifyLogger.parent(UnifyLogger.getTrace(e), UnifyLogger.Level.INFO);
						vo.setOperateType(Constant.OPERATE_TYPE_FAIL);
					} finally {
						commonService.update(nameSpace + "updateGardenUserPostResult", vo);
					}
				}
			}
        } catch (Exception e) {
            UnifyLogger.parent(UnifyLogger.getTrace(e), UnifyLogger.Level.INFO);
		} finally {
			if (rLock.isHeldByCurrentThread()) {
				rLock.unlock();
			}
		}
    }

    @Scheduled(cron = "0 */10 * * * ?")
    public void focusGroupDataExecutor() {
    	RLock rLock = redissonClient.getLock("jilinexchange:focusGroupDataExecutor");
        try {
			if(rLock.tryLock(0, TimeUnit.SECONDS)){
				List<ReqFocusGroupVo> dataList = commonService.findList(nameSpace + "selectFocusGroupTaskList", MapUtil.empty());
				for(ReqFocusGroupVo bo:dataList) {
					bo.setOperateType(Constant.OPERATE_TYPE_SUCCESS);
					try {
						switch (TypeEnum.getType(bo.getType())) {
							case INSERT:
								int insert = commonService.insert(nameSpace + "insertFocusGroup", bo);
								if(insert!=1){
									throw new Exception("数据新增异常");
								}
								break;
							case DELETE:
								int delete = commonService.delete(nameSpace + "deleteFocusGroup", bo);
								if(delete!=1){
									throw new Exception("数据未命中，删除异常");
								}
								break;
							default:
								throw new Exception("type 异常！");
						}
					} catch (Exception e) {
						log.error(UnifyLogger.getTrace(e));
						bo.setOperateType(Constant.OPERATE_TYPE_FAIL);
					} finally {
						commonService.update(nameSpace + "updateFocusGroupPostResult", bo);
					}
				}
			}
        } catch (Exception e) {
            UnifyLogger.parent(UnifyLogger.getTrace(e), UnifyLogger.Level.INFO);
		} finally {
			if (rLock.isHeldByCurrentThread()) {
				rLock.unlock();
			}
		}
    }

    @Scheduled(cron = "0 */10 * * * ?")
    public void peopleDataExecutor() {
    	RLock rLock = redissonClient.getLock("jilinexchange:peopleDataExecutor");

        try {
//    		DataSourceSwitcher.setMaster();
//    		DataSourceSwitcher.setShardingSphere("ShardingDataSource");
			if(rLock.tryLock(0, TimeUnit.SECONDS)){
				List<ExecutorUserBo> dataList = commonService.findList(nameSpace + "selectPeopleTaskList", MapUtil.empty());
				for(ExecutorUserBo bo:dataList) {
					bo.setOperateType(Constant.OPERATE_TYPE_SUCCESS);
					try {
						switch (TypeEnum.getType(bo.getType())) {
							case INSERT:
								Map mapCheck = commonService.getObject(nameSpace + "getUserByCardNo", bo.getCardno());
								if(mapCheck!=null) {
									throw new Exception("数据新增异常，人员已存在");
								}
								int insert = commonService.insert(nameSpace + "insertPeople", bo);
								if(insert!=1){
									throw new Exception("数据新增异常");
								}
								break;
							case UPDATE:
								int update = commonService.update(nameSpace + "updatePeople", bo);
								if(update!=1){
									throw new Exception("数据未命中，更新异常");
								}
								break;
							case DELETE:
								int delete = commonService.delete(nameSpace + "deletePeople", bo);
								if(delete!=1){
									throw new Exception("数据未命中，删除异常");
								}
								break;
							default:
								throw new Exception("type 异常！");
						}
					} catch (Exception e) {
						UnifyLogger.parent(UnifyLogger.getTrace(e), UnifyLogger.Level.INFO);
						bo.setOperateType(Constant.OPERATE_TYPE_FAIL);
					} finally {
						commonService.update(nameSpace + "updatePeoplePostResult", bo);
					}
				}
			}
        } catch (Exception e) {
            UnifyLogger.parent(UnifyLogger.getTrace(e), UnifyLogger.Level.INFO);
		} finally {
			if (rLock.isHeldByCurrentThread()) {
				rLock.unlock();
			}
		}
    }
}
