package com.scpyun.platform.jilinsscgsdp.service.impl;

import com.scpyun.base.bean.Page;
import com.scpyun.base.core.annotation.Api;
import com.scpyun.base.core.annotation.ApiOperation;
import com.scpyun.base.core.exception.CustomException;
import com.scpyun.base.db.service.CommonService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Api("日常请假管理")
@Service("keyDmLeave")
public class KeyDmLeaveServiceImpl {
    @Autowired
    private CommonService commonService;

    private static final String SUCCESS = "success";
    private final String namespace = "com.scpyun.platform.standard.jilinsscgsdp.keyDmLeave.";

    @ApiOperation(value = "分页查询请假申请列表", desc = "分页查询")
    public Page<Map<String, Object>> selectList(Map<String, Object> map) {
        if (map == null) map = new HashMap<>();
        return commonService.findPage(namespace + "selectList", map);
    }

    @ApiOperation(value = "待审核列表", desc = "查询待审核数据")
    public Page<Map<String, Object>> selectPendingList(Map<String, Object> map) {
        if (map == null) map = new HashMap<>();
        return commonService.findPage(namespace + "selectPendingList", map);
    }

    @ApiOperation(value = "保存请假申请", desc = "新增或修改，请假单保存")
    public String save(Map<String, Object> map) {
        if (map == null) throw new CustomException("参数不能为空");
        Object id = map.get("id");
        if (id == null || String.valueOf(id).trim().isEmpty()) {
            if (commonService.insert(namespace + "insert", map) != 1) throw new CustomException("保存失败");
        } else {
            int aff = commonService.update(namespace + "update", map);
            if (aff < 0) throw new CustomException("保存失败");
        }
        return SUCCESS;
    }

    @ApiOperation(value = "提交请假申请", desc = "提交进入审批流程")
    public String submit(Map<String, Object> map) {
        if (map == null || map.get("id") == null) throw new CustomException("参数缺失");
        int aff = commonService.update(namespace + "submit", map);
        if (aff < 0) throw new CustomException("提交失败");
        return SUCCESS;
    }

    @ApiOperation(value = "撤回请假申请", desc = "撤回未完成审批的申请")
    public String revoke(Map<String, Object> map) {
        if (map == null || map.get("id") == null) throw new CustomException("参数缺失");
        int aff = commonService.update(namespace + "revoke", map);
        if (aff < 0) throw new CustomException("撤回失败");
        return SUCCESS;
    }

    @ApiOperation(value = "审批通过", desc = "审批操作-通过")
    public String approve(Map<String, Object> map) {
        if (map == null || map.get("id") == null) throw new CustomException("参数缺失");
        int aff = commonService.update(namespace + "approve", map);
        if (aff < 0) throw new CustomException("审批失败");
        return SUCCESS;
    }

    @ApiOperation(value = "审批驳回", desc = "审批操作-驳回")
    public String reject(Map<String, Object> map) {
        if (map == null || map.get("id") == null) throw new CustomException("参数缺失");
        int aff = commonService.update(namespace + "reject", map);
        if (aff < 0) throw new CustomException("驳回失败");
        return SUCCESS;
    }

    @ApiOperation(value = "获取请假详情（含审批记录）", desc = "获取详情")
    public Map<String, Object> getById(Map<String, Object> map) {
        if (map == null || map.get("id") == null) throw new CustomException("参数缺失");
        Map<String, Object> ret = new HashMap<>();
        Map<String, Object> app = commonService.getObject(namespace + "getById", map);
        ret.putAll(app == null ? new HashMap<>() : app);
        List<Map<String, Object>> approvals = commonService.findList(namespace + "selectApprovalRecords", map);
        ret.put("approvals", approvals == null ? new java.util.ArrayList<>() : approvals);
        return ret;
    }

    @ApiOperation(value = "审批历史查询", desc = "查询审批历史")
    public Page<Map<String, Object>> selectApprovalHistory(Map<String, Object> map) {
        if (map == null) map = new HashMap<>();
        return commonService.findPage(namespace + "selectApprovalHistory", map);
    }

    @ApiOperation(value = "请假统计", desc = "按人员统计已通过请假天数")
    public List<Map<String, Object>> selectStats(Map<String, Object> map) {
        if (map == null) map = new HashMap<>();
        return commonService.findList(namespace + "selectStats", map);
    }
}


