package com.scpyun.platform.jilinsscgsdp.enums;

import com.scpyun.base.core.exception.CustomException;

public enum UserGradeEnum {
	PROVINCE("2","省级"),
	CITY("3","市级"),
	AREA("4","区县级"),
	STREET("5","街道乡镇级"),
	COMMUNITY("6","社区村屯级");
	
	private UserGradeEnum(String grade, String chnDesc) {
		this.grade = grade;
		this.chnDesc = chnDesc;
	}
	private String grade;
	private String chnDesc;
	public String getGrade() {
		return grade;
	}
	public void setGrade(String grade) {
		this.grade = grade;
	}
	public String getChnDesc() {
		return chnDesc;
	}
	public void setChnDesc(String chnDesc) {
		this.chnDesc = chnDesc;
	}
	
	public static String getChnDesc(String grade) {
		for(UserGradeEnum gradeEnum:UserGradeEnum.values()) {
			if(grade.equals(gradeEnum.getGrade())) {
				return gradeEnum.getChnDesc();
			}
		}
		return null;
	}
	
	public static boolean checkUserPermission(String garde,UserGradeEnum gradeEnum) {
		if(!garde.equals(gradeEnum.getGrade())) {
			throw new CustomException("当前用户属"+UserGradeEnum.getChnDesc(garde)+"级，不具备数据操作权限！");
		}else {
			return true;
		}
	}
}
