package com.scpyun.platform.jilinsscgsdp.task.impl;

import com.scpyun.base.core.exception.CustomException;
import com.scpyun.base.core.utils.SpringContextHolder;
import com.scpyun.base.core.utils.UnifyLogger;
import com.scpyun.base.db.service.CommonService;
//import net.javacrumbs.shedlock.core.SchedulerLock;
import com.scpyun.platform.jilinsscgsdp.bean.vo.ReqWarningTaskVo;
import com.scpyun.platform.jilinsscgsdp.constant.NumberConstant;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

/**
 * @Author liu
 * @Date 2024/6/5 15:05
 * @PackageName:com.scpyun.platform.jilinsscgsdp.task.impl
 * @ClassName: AutoSynchronizeDataTask
 * @Description: TODO
 * @Version 1.0
 */
@Component
public class AutoWarningTask {
    CommonService commonService = SpringContextHolder.getBean(CommonService.class);
    RedissonClient redissonClient = SpringContextHolder.getBean(RedissonClient.class);
    private final String nameSpace = "com.scpyun.platform.standard.jilinsscgsdp.event.";
    private final String nameSpaceFlow = "com.scpyun.platform.standard.jilinsscgsdp.eventflow.";
    private final String nameSpaceWaiting = "com.scpyun.platform.standard.jilinsscgsdp.eventwaiting.";

//    private final String KEY = "synchronizationForUserinfo";

    @Scheduled(cron = "0 0 */1 * * ?")
//    @SchedulerLock(name = KEY, lockAtMostForString = "PT60M", lockAtLeastForString = "PT60S")
    public void synchronizationForUserinfo() {
        RLock rLock = redissonClient.getLock("jilinexchange:synchronizationForUserinfo");
//        rLock.lock(NumberConstant.R_LOCK, TimeUnit.SECONDS);
        try {
            if (rLock.tryLock(60, TimeUnit.SECONDS)) {
                //预警
                UnifyLogger.parent("预警定时任务启动----------------");
                List<ReqWarningTaskVo> warningList = commonService.findList(nameSpace + "selectWarningList", null);
                UnifyLogger.parent("需要预警数量=====" + warningList.size());
                for (ReqWarningTaskVo warning : warningList) {
                    List<ReqWarningTaskVo> flowLogList = commonService.findList(nameSpaceFlow + "selectIdByEventIdList", warning);
                    for (ReqWarningTaskVo flow : flowLogList) {
                        UnifyLogger.parent("预警机构id=====" + flow.getDeptId());
                        flow.setIsEarlyWarning(NumberConstant.THREE_STRING);
                        flow.setContent("事件编号为：" + warning.getEventCode() + "还有两天即将告警，请尽快处理！！！");
//                    flow.put("is_early_warning", 3);
//                    flow.put("content", "事件编号为：" + warning.get("event_code") + "还有两天即将告警，请尽快处理！！！");
                        if (commonService.update(nameSpaceFlow + "updateEarlyEndTime", flow) != 1) {
                            throw new CustomException("修改失败！");
                        }
                        if (commonService.insert(nameSpaceWaiting + "insertEventWaitingDealNotice", flow) != 1) {
                            throw new CustomException("添加失败！");
                        }
                    }
                    warning.setIsEarlyWarning(NumberConstant.THREE_STRING);
                    if (commonService.update(nameSpace + "updateEarlyWarning", warning) != 1) {
                        throw new CustomException("修改失败！");
                    }
                }
                //告警
                UnifyLogger.parent("预警定时任务启动----------------");
                List<ReqWarningTaskVo> alarmList = commonService.findList(nameSpace + "selectAlarmList", null);
                UnifyLogger.parent("需要预警数量=====" + warningList.size());
                for (ReqWarningTaskVo alarm : alarmList) {
                    List<ReqWarningTaskVo> flowLogList = commonService.findList(nameSpaceFlow + "selectIdByEventIdList", alarm);
                    for (ReqWarningTaskVo flow : flowLogList) {
                        UnifyLogger.parent("预警机构id=====" + flow.getDeptId());
                        flow.setIsEarlyWarning(NumberConstant.FOUR_STRING);
                        flow.setContent("事件编号为：" + alarm.getEventCode() + "已经告警，请尽快处理！！！");
                        if (commonService.update(nameSpaceFlow + "updateEarlyEndTime", flow) != 1) {
                            throw new CustomException("修改失败！");
                        }
                        if (commonService.insert(nameSpaceWaiting + "insertEventWaitingDealNotice", flow) != 1) {
                            throw new CustomException("添加失败！");
                        }
                    }
                    alarm.setIsEarlyWarning(NumberConstant.FOUR_STRING);
                    if (commonService.update(nameSpace + "updateEarlyWarning", alarm) != 1) {
                        throw new CustomException("修改失败！");
                    }
                }
            }
        } catch (Exception e) {
            UnifyLogger.parent(UnifyLogger.getTrace(e), UnifyLogger.Level.INFO);
        } finally {
            rLock.unlock();
        }
    }
}
