package com.scpyun.platform.jilinsscgsdp.task.impl;

import com.scpyun.base.core.annotation.ApiOperation;
import com.scpyun.base.core.exception.CustomException;
import com.scpyun.base.core.utils.JedisUtils;
import com.scpyun.base.core.utils.SpringContextHolder;
import com.scpyun.base.core.utils.UnifyLogger;
import com.scpyun.base.db.service.CommonService;
import com.scpyun.platform.jilinsscgsdp.service.impl.FocusAreasServiceImpl;
import com.scpyun.platform.jilinsscgsdp.service.impl.GridUserImportServiceImpl;
import lombok.Setter;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;

//@Service("girdUserImprotJobTask")
@Component
@Slf4j
public class GirdUserImprotJobTask {

    RedissonClient redissonClient = SpringContextHolder.getBean(RedissonClient.class);

    GridUserImportServiceImpl gridUserImportService = SpringContextHolder.getBean(GridUserImportServiceImpl.class);

    private final String nameSpace = "com.scpyun.platform.standard.jilinsscgsdp.JiLinImportUser.";

    CommonService commonService = SpringContextHolder.getBean(CommonService.class);

    @Scheduled(cron = "*/10 * * * * ?")
//    @ApiOperation(value = "execl任务测试", desc = "execl任务测试" ,nologin = true)
    public void girdUserImprotJob() {
        RLock rLock = redissonClient.getLock("zfw:GirdUserImprotJobTask");
        HashMap<String, Object> map = null;
        try {
            String stopFlag = JedisUtils.get("zfw:girdUserImportJobTask:stop");
            if(StringUtils.isEmpty(stopFlag)) {
                if (rLock.tryLock(10,10, TimeUnit.SECONDS)) {
                    map = commonService.getObject(nameSpace + "findFirstOne", null);
                    if (!CollectionUtils.isEmpty(map)) {
                        HashMap<String, Object> updateMap = new HashMap<>();
                        updateMap.put("id", map.get("id"));
                        updateMap.put("jobStatus", 1);
                        updateMap.put("dealResultmessage", "您导入的数据正在处理中，请稍后");
                        updateMap.put("dealTime", new Date());
                        updateMap.put("updateTime", new Date());
                        commonService.update(nameSpace + "updateFileTask", updateMap);
                        HashMap<String, Integer> countHashMap = gridUserImportService.GirdUserImprotJobTask(map);
                        HashMap<String, Object> endupdateMap = new HashMap<>();
                        endupdateMap.put("id", map.get("id"));
                        endupdateMap.put("jobStatus", 2);
                        Integer fullCount = countHashMap.get("fullCount");
                        Integer succCount = countHashMap.get("succCount");
                        int count = succCount + fullCount;
                        if (fullCount.compareTo(count) == 0) {
                            endupdateMap.put("dealResult", 0);
                            endupdateMap.put("dealResultMessage", "您共导入" + count + "条数据 成功：" + succCount + "条，失败：" + fullCount + "条");
                        } else if (fullCount.compareTo(0) == 0) {
                            endupdateMap.put("dealResult", 1);
                            endupdateMap.put("dealResultMessage", "您共导入" + count + "条数据 成功：" + succCount + "条，失败：" + fullCount + "条");
                        } else {
                            endupdateMap.put("dealResult", 2);
                            endupdateMap.put("dealResultMessage", "您共导入" + count + "条数据 成功：" + succCount + "条，失败：" + fullCount + "条");
                        }
                        endupdateMap.put("update_time", new Date());
                        commonService.update(nameSpace + "updateFileTask", endupdateMap);

                    } else {
                        log.info("人员导入定时任务未有需要处理的点");
                    }
                } else {
                    log.info("人员导入定时任务正在处理。。。");
                }
            }else {
                log.info("人员导入定时任务当前已被锁定。。。");
            }
        } catch (Exception e) {
            UnifyLogger.parent(UnifyLogger.getTrace(e), UnifyLogger.Level.INFO);
            HashMap<String, Object> updateMap = new HashMap<>();
            updateMap.put("id", map.get("id"));
            updateMap.put("orginalObsDownloadFailReason", e.toString());
            updateMap.put("jobStatus", 2);
            updateMap.put("dealResult", 3);
            updateMap.put("updateTime", new Date());
            if (e instanceof CustomException) {
                updateMap.put("dealResultMessage", "您导入的数据失败:" + e.getMessage());
            } else {
                updateMap.put("dealResultMessage", "您导入的数据失败");
            }
            commonService.update(nameSpace + "updateFileTask", updateMap);
        } finally {
            if (rLock.isHeldByCurrentThread()) {
                rLock.unlock();
            }else {
                UnifyLogger.parent("不是当前前程锁不允许释放锁", UnifyLogger.Level.INFO);
            }
        }
    }

    public static void main(String[] args) {

    }
}
