package com.scpyun.platform.jilinsscgsdp.task.impl;

import com.scpyun.base.core.exception.CustomException;
import com.scpyun.base.core.utils.SpringContextHolder;
import com.scpyun.base.core.utils.UnifyLogger;
import com.scpyun.base.db.service.CommonService;
import com.scpyun.platform.jilinsscgsdp.constant.NotesConstant;
import com.scpyun.platform.jilinsscgsdp.constant.NumberConstant;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

/**
 * @Author liu
 * @Date 2024/12/10 10:20
 * @PackageName:com.scpyun.platform.jilinsscgsdp.task.impl
 * @ClassName: officeTask
 * @Description: TODO
 * @Version 1.0
 */
@Component
public class OfficeTask {
    private final String nameSpace = "com.scpyun.platform.standard.jilinsscgsdp.sys.";
    CommonService commonService = SpringContextHolder.getBean(CommonService.class);
    RedissonClient redissonClient = SpringContextHolder.getBean(RedissonClient.class);

    @Scheduled(cron = "0 0 */1 * * ?")
    public void synchronizationForOfficeInfo() {
        RLock rLock = redissonClient.getLock("jilinexchange:eventTask");
        //        rLock.lock(NumberConstant.R_LOCK, TimeUnit.SECONDS);
        try {
            if (rLock.tryLock(60, TimeUnit.SECONDS)) {
                List<Map<String, Object>> areaList = commonService.findList(nameSpace + "selectAreaOfficeList", null);
                for (Map<String, Object> area : areaList) {
                    area.put("sys_area", "JL");
                    area.put("company_code", commonService.getObject(nameSpace + "getOfficeCode", area));
                    UnifyLogger.parent("area====" + area, UnifyLogger.Level.INFO);
                    if (commonService.insert(nameSpace + "saveOfficeTask", area) != NumberConstant.ONE_INT) {
                        throw new CustomException(NotesConstant.INSERT_EXCEPTION);
                    }
                }
            }
        } catch (Exception e) {
            UnifyLogger.parent(UnifyLogger.getTrace(e), UnifyLogger.Level.INFO);
        } finally {
            rLock.unlock();
        }
    }
}
