package com.scpyun.platform.jilinsscgsdp.utils;

import com.alibaba.fastjson.JSONArray;
import com.scpyun.base.core.utils.StringUtils;
import com.scpyun.platform.jilinsscgsdp.pojo.Point;

import java.awt.geom.Point2D;
import java.util.List;

/**
 * @version V1.0.0
 * @Title: GridPointUtil
 * @Package GridPointUtil.java
 * @Description: copy By scp-grid
 * @author: guojiucoder
 * @date: 2024/7/31 14:10
 */
public class GridPointUtil {
    public boolean disposeMapJson(String newMapJson, String oldMapJson) {
        boolean result = false;
        // 处理旧的网格信息
        JSONArray oldJsonArray = JSONArray.parseArray(oldMapJson);
        Point[] ps = new Point[oldJsonArray.size()];
        for (int i = 0; i < oldJsonArray.size(); i++) {
            String x = StringUtils.toString(oldJsonArray.get(i));
            JSONArray oldJsonArray1 = JSONArray.parseArray(x);
            ps[i] = new Point(StringUtils.toDouble(oldJsonArray1.get(0)), StringUtils.toDouble(oldJsonArray1.get(1)));
        }
        // 处理新的网格信息
        JSONArray newJsonArray = JSONArray.parseArray(newMapJson);
        for (int i = 0; i < newJsonArray.size(); i++) {
            String x = StringUtils.toString(newJsonArray.get(i));
            JSONArray newJsonArray1 = JSONArray.parseArray(x);
            if (isPtInPoly(StringUtils.toDouble(newJsonArray1.get(0)), StringUtils.toDouble(newJsonArray1.get(1)), ps)) {
                result = true;
            }
        }
        return result;
    }

    /**
     * @param ALon
     * @param ALat
     * @param ps
     * @return true  在范围
     * false 不在范围
     */
    public static boolean isPtInPoly(double ALon, double ALat, Point[] ps) {
        int iSum, iCount, iIndex;
        double dLon1 = 0, dLon2 = 0, dLat1 = 0, dLat2 = 0, dLon;
        if (ps.length < 3) {
            return false;
        }
        iSum = 0;
        iCount = ps.length;
        for (iIndex = 0; iIndex < iCount; iIndex++) {
            if (iIndex == iCount - 1) {
                dLon1 = ps[iIndex].getX();
                dLat1 = ps[iIndex].getY();
                dLon2 = ps[0].getX();
                dLat2 = ps[0].getY();
            } else {
                dLon1 = ps[iIndex].getX();
                dLat1 = ps[iIndex].getY();
                dLon2 = ps[iIndex + 1].getX();
                dLat2 = ps[iIndex + 1].getY();
            }
            // 以下语句判断A点是否在边的两端点的水平平行线之间，在则可能有交点，开始判断交点是否在左射线上
            if (((ALat >= dLat1) && (ALat < dLat2)) || ((ALat >= dLat2) && (ALat < dLat1))) {
                if (Math.abs(dLat1 - dLat2) > 0) {
                    // 得到 A点向左射线与边的交点的x坐标：
                    dLon = dLon1 - ((dLon1 - dLon2) * (dLat1 - ALat)) / (dLat1 - dLat2);
                    // 如果交点在A点左侧（说明是做射线与 边的交点），则射线与边的全部交点数加一：
                    if (dLon < ALon) {
                        iSum++;
                    }
                }
            }
        }
        if ((iSum % 2) != 0) {
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        List<Point2D.Double> residentialList = MapLngLatUtil.MapJSONToPointDouble(StringUtils.toString("[[123.381693,41.672474],[123.393778,41.668178],[123.396525,41.673384],[123.385985,41.678032]]"));
        List<Point2D.Double> gardenList = MapLngLatUtil.MapJSONToPointDouble(StringUtils.toString("[[123.385985,41.677875],[123.396697,41.67342],[123.398733,41.678314],[123.38856,41.681574]]"));
        boolean result = PolygonUtil.isPolygonInPolygon(gardenList, residentialList);
        System.out.println(result);
        GridPointUtil a = new GridPointUtil();
        System.out.println(a.disposeMapJson("[[123.381693,41.672474],[123.393778,41.668178],[123.396525,41.673384],[123.385985,41.678032]]", "[[123.385985,41.677875],[123.396697,41.67342],[123.398733,41.678314],[123.38856,41.681574]]"));

    }
}
