package com.scpyun.platform.jilinsscgsdp.check;

import cn.hutool.core.util.IdcardUtil;
import com.scpyun.base.core.exception.CustomException;
import com.scpyun.base.core.utils.StringUtils;

import java.util.Map;

/**
 * @Author liu
 * @Date 2024/5/31 14:42
 * @PackageName:com.scpyun.platform.jilinsscgsdp.utils
 * @ClassName: EventCheckUtils
 * @Description: TODO
 * @Version 1.0
 */
public class EventUserCheckUtils {

    /**
     * 添加当时人校验参数
     *
     * @param map
     */
    public static void eventUserCheck(Map<String, Object> map) {
        if (StringUtils.isEmpty(map.get("event_id"))) {
            throw new CustomException("事件ID不可为空！");
        }
        if (StringUtils.isEmpty(map.get("event_user_type"))) {
            throw new CustomException("当事人类型不可为空！");
        }
        if (!StringUtils.toStr(map.get("event_user_type")).equals("4")) {
            if (!StringUtils.isEmpty(map.get("event_cardno"))) {
                if (!IdcardUtil.isValidCard(StringUtils.toStr(map.get("event_cardno")))) {
                    throw new CustomException("证件号码错误！");
                }
            }
        }
        if (StringUtils.isEmpty(map.get("event_user_name"))) {
            throw new CustomException("当事人姓名不可为空！");
        }
        if (StringUtils.isEmpty(map.get("event_tel"))) {
            throw new CustomException("联系电话不可为空！");
        }
        //证件校验后续需要补充
    }
}
