define(['./utils/loader', './route'], function (loader, routeUse) {

  var extend = {};
  extend.enviro = 'dev';
  let pathBase = "";
  if (window.location.pathname.indexOf('/scpcw/') > 0) {
    pathBase = window.location.pathname.substring(0, window.location.pathname.indexOf('/scpcw/'))
  }
  // 路由数据处理
  function deaRoute (routes){
    const arr = routes.map(v => {
      if (v.component) {
        v.component = loader(pathBase + v.component)
      }
      if (v.children) {
        v.children.map(m=> {
          if (m.component) {
            m.component = loader(pathBase + m.component)
          }
          return m
        })
      }
      return v
    })
    return arr
  }
  const routes = deaRoute(routeUse.routes)
  extend.document = routeUse.title
  // 路由文件，申明路由，哪些页面的。
  extend.router = {
    routes: routes,
    dynamicBasePath: '/'
  }

  extend.require = {
    config:{
      urlArgs: 'v=' + (new Date()).getTime(),
      paths: {
        'iview': '../libs/vue-iview/iview.min',
        'hd-plugin-gather': 'http://base.tripln.com/hd-plugin-gather/hd-plugin-gather.umd.min',
        'scpcw-chart-plugin':'http://base.tripln.com/scpcw-chart-plugin/scpcw-chart-plugin.umd.min',
        'scpcw-pc-plugin': 'http://base.tripln.com/scpcw-pc-plugin/scpcw-pc-plugin.umd.min',
        'scpcw-pc-base': 'http://base.tripln.com/scpcw-base-pc/scpcw-pc-base.umd.min'
      },
      shim: {
        'iview': ['vue'],
      }
    },
    require_param1:['vue','iview','scpcw-chart-plugin','scpcw-pc-plugin','scpcw-pc-base','hd-plugin-gather','css!http://base.tripln.com/hd-plugin-gather/hd-plugin-gather.css', 'css!http://base.tripln.com/scpcw-chart-plugin/scpcw-chart-plugin.css','css!http://base.tripln.com/scpcw-pc-plugin/scpcw-pc-plugin.css', 'css!http://base.tripln.com/scpcw-base-pc/scpcw-pc-base.css'],
    require_param2:function(Vue, iview, scpcwChartPlugin, scpcwPcPlugin, syscomponent, scpcwPcBase, hdPluginGather){
      Vue.use(iview);
      Vue.use(hdPluginGather.default);
      Vue.use(scpcwChartPlugin.default);
      Vue.use(scpcwPcPlugin.default);
      // 新版sc系统配置（本行注释禁止删除或修改，否则会导致新版sc配置失效）
      Vue.use(scpcwPcBase.default, { themeConfig: routeUse.themeConfig });
    }
  };

  return extend

})