package com.scpyun.platform.jilinsscgsdp.bean.vo.task;

import com.scpyun.platform.jilinsscgsdp.annotation.IdCard;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Update;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.Pattern;

/**
 * @Author liu
 * @Date 2024/10/11 14:18
 * @PackageName:com.scpyun.platform.jilinexchange.bean.vo
 * @ClassName: ReqGardenUserVo
 * @Description: TODO
 * @Version 1.0
 */
public class ReqGardenUserVo extends ReqBaseVo{
    /**
     * 主键
     */
    @NotEmpty(message = "id不可为空",groups = {Insert.class,Update.class,Delete.class})
    @Length(min=1, max=200,message = "id数据长度范围1到200",groups = {Insert.class,Update.class,Delete.class})
    private String id;

    /**
     * 网格员名称
     */
    @NotEmpty(message = "网格员名称不可为空")
    @Length(min=1, max=40,message = "网格员名称数据长度范围1到40",groups = {Insert.class,Update.class})
    private String name;

    /**
     * 市编码
     */
    @NotEmpty(message = "市编码不可为空")
    @Pattern(regexp = "^\\d{12}$", message = "市编码格式异常",groups = {Insert.class,Update.class})
    private String cityCode;

    /**
     * 区编码
     */
    @NotEmpty(message = "区编码不可为空")
    @Pattern(regexp = "^\\d{12}$", message = "区编码格式异常",groups = {Insert.class,Update.class})
    private String areaCode;

    /**
     * 街道编码
     */
    @NotEmpty(message = "街道编码不可为空")
    @Pattern(regexp = "^\\d{12}$", message = "街道编码格式异常",groups = {Insert.class,Update.class})
    private String streetCode;

    /**
     * 社区编码
     */
    @NotEmpty(message = "社区编码不可为空")
    @Pattern(regexp = "^\\d{12}$", message = "社区编码格式异常",groups = {Insert.class,Update.class})
    private String communityCode;

    /**
     * 网格id
     */
    @NotEmpty(message = "网格id不可为空")
    @Length(min=1, max=40,message = "网格ID数据长度范围1到40",groups = {Insert.class,Update.class})
    private String gardenId;

    /**
     * 联系电话
     */
    @NotEmpty(message = "联系电话不可为空")
    @Length(min=1, max=36,message = "联系电话数据长度范围1到36",groups = {Insert.class,Update.class})
    private String tel;

    /**
     * 身份证号
     */
    @NotEmpty(message = "证件号不可为空")
    @IdCard
    private String cardno;
    
    /**
     * 部门id
     */
    private String companyId;
    
    /**
     * 职责id
     */
    private String dutyId;

    /**
     * 职责
     */
    private String responsibility;

    /**
     * 备注
     */
    @Length(max=200,message = "备注数据长度最大200",groups = {Insert.class,Update.class})
    private String remark;

    /**
     * appid
     */
    @NotEmpty(message = "appid不可为空")
    @Length(min=1, max=36,message = "appid数据长度范围1到36",groups = {Insert.class,Update.class})
    private String appid;

    /**
     * 地市对接id
     */
    private String dockingId;

    /**
     * 添加状态
     */
    private String type;

    /**
     * 操作状态 1成功 2失败
     */
    private String operateType;
    

    public String getCompanyId() {
		return companyId;
	}

	public void setCompanyId(String companyId) {
		this.companyId = companyId;
	}

	public String getDutyId() {
		return dutyId;
	}

	public void setDutyId(String dutyId) {
		this.dutyId = dutyId;
	}

	public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCityCode() {
        return cityCode;
    }

    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }

    public String getAreaCode() {
        return areaCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    public String getStreetCode() {
        return streetCode;
    }

    public void setStreetCode(String streetCode) {
        this.streetCode = streetCode;
    }

    public String getCommunityCode() {
        return communityCode;
    }

    public void setCommunityCode(String communityCode) {
        this.communityCode = communityCode;
    }

    public String getGardenId() {
        return gardenId;
    }

    public void setGardenId(String gardenId) {
        this.gardenId = gardenId;
    }

    public String getTel() {
        return tel;
    }

    public void setTel(String tel) {
        this.tel = tel;
    }

    public String getCardno() {
        return cardno;
    }

    public void setCardno(String cardno) {
        this.cardno = cardno;
    }

    public String getResponsibility() {
        return responsibility;
    }

    public void setResponsibility(String responsibility) {
        this.responsibility = responsibility;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getAppid() {
        return appid;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public String getDockingId() {
        return dockingId;
    }

    public void setDockingId(String dockingId) {
        this.dockingId = dockingId;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getOperateType() {
        return operateType;
    }

    public void setOperateType(String operateType) {
        this.operateType = operateType;
    }
}
