package com.scpyun.platform.jilinsscgsdp.task.impl;

import com.scpyun.base.core.utils.SpringContextHolder;
import com.scpyun.base.core.utils.StringUtils;
import com.scpyun.base.core.utils.UnifyLogger;
import com.scpyun.base.db.service.CommonService;
import com.scpyun.platform.jilinsscgsdp.bean.vo.ReqWarningTaskVo;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

/**
 * @Author liu
 * @Date 2024/6/5 15:05
 * @PackageName:com.scpyun.platform.jilinsscgsdp.task.impl
 * @ClassName: AutoSynchronizeDataTask
 * @Description: TODO
 * @Version 1.0
 */
@Component
public class AutoWarningTask {
    CommonService commonService = SpringContextHolder.getBean(CommonService.class);
    RedissonClient redissonClient = SpringContextHolder.getBean(RedissonClient.class);
    private final String nameSpace = "com.scpyun.platform.standard.jilinsscgsdp.event.";
    private final String nameSpaceFlow = "com.scpyun.platform.standard.jilinsscgsdp.eventflow.";
    private final String nameSpaceWaiting = "com.scpyun.platform.standard.jilinsscgsdp.eventwaiting.";

    @Scheduled(cron = "0 0 */1 * * ?")
    public void synchronizationForUserinfo() {
        RLock rLock = redissonClient.getLock("jilinexchange:synchronizationForUserinfo");
        try {
            if (rLock.tryLock(0, TimeUnit.SECONDS)) {
                //预警
                List<ReqWarningTaskVo> warningList = commonService.findList(nameSpace + "selectWarningList", null);
                for (ReqWarningTaskVo warning : warningList) {
                    ReqWarningTaskVo overdue = commonService.getObject(nameSpace + "getOverdueWarning", warning);
                    warning.setYellowWarnDays(overdue.getYellowWarnDays());
                    warning.setRedWarnDays(overdue.getRedWarnDays());
                    Map<String, Object> getWaningAlarmTime = commonService.getObject(nameSpace + "getWaningAlarmTime", warning);
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                    Date early_warning_time = sdf.parse(StringUtils.toStr(getWaningAlarmTime.get("early_warning_time")));
                    Date alarm_time = sdf.parse(StringUtils.toStr(getWaningAlarmTime.get("alarm_time")));
                    Date date = new Date(System.currentTimeMillis());
                    if (date.after(alarm_time)) {
                        warning.setIsEarlyWarning("4");
                        warning.setType("1");
                    } else if (date.after(early_warning_time)) {
                        warning.setIsEarlyWarning("3");
                        warning.setType("1");
                    } else {
                        warning.setIsEarlyWarning("1");
                    }
                    commonService.update(nameSpace + "updateEarlyWarning", warning);
                }
            }
        } catch (Exception e) {
            UnifyLogger.parent(UnifyLogger.getTrace(e), UnifyLogger.Level.INFO);
        } finally {
            if (rLock.isHeldByCurrentThread()) {
                rLock.unlock();
            }
        }
    }
}
