package com.scpyun.platform.jilinsscgsdp.service.impl;


import com.scpyun.base.core.annotation.Api;
import com.scpyun.base.core.annotation.ApiOperation;
import com.scpyun.base.core.exception.CustomException;
import com.scpyun.base.core.utils.DataSourceSwitcher;
import com.scpyun.base.core.utils.StringUtils;
import com.scpyun.base.core.utils.UnifyLogger;
import com.scpyun.base.db.service.CommonService;
import com.scpyun.platform.jilinsscgsdp.annotation.systemOperateLog;
import com.scpyun.platform.jilinsscgsdp.pojo.OperateType;
import com.scpyun.platform.jilinsscgsdp.utils.GridMapParamsUtil;
import com.scpyun.platform.jilinsscgsdp.utils.GridPointUtil;
import com.scpyun.platform.jilinsscgsdp.utils.MapLngLatUtil;
import com.scpyun.platform.jilinsscgsdp.utils.PolygonUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.awt.geom.Point2D;
import java.util.*;

/**
 * @version V1.0.0
 * @Title: CreateGridServiceImpl
 * @Package CreateGridServiceImpl.java
 * @Description: copy By scp-grid
 * @author: guojiucoder
 * @date: 2024/7/31 14:09
 */
@Api("创建网格")
@Service("createGridService")
public class CreateGridServiceImpl {
    @Autowired
    CommonService commonService;
    @Autowired
    SysOfficeLevelServiceImpl sysOfficeLevelService;

    private final String nameSpace_for_residential = "com.scpyun.platform.standard.jilinsscgsdp.gridResidential.";
    private final String nameSpace_Switch = "com.scpyun.platform.standard.jilinsscgsdp.gridSwitch.";
    private final String nameSpace_office="com.scpyun.platform.standard.jilinsscgsdp.sysOfficeinfo.";
    private String nameSpace = "com.scpyun.platform.standard.jilinsscgsdp.gridQy.";

    @SuppressWarnings("all")
    public Map<String, Object> disposeGridScope(Map<String, Object> map, List<Map<String, Object>> list) {
        // 查询当前社区所画网格
//        List<Map<String, Object>> list = commonService.findList(nameSpace + "findResidentialList", map);
        if (list.size() > 0) {
            for (Map<String, Object> aMap : list) {
                GridPointUtil gridPointUtil = new GridPointUtil();
                Boolean result = gridPointUtil.disposeMapJson(StringUtils.toString(map.get("csc_mapjson")), StringUtils.toString(aMap.get("csc_mapjson")));
                if (result) {
                    throw new CustomException("当前所画小区范围，已经与本社区=====" + aMap.get("name") + "=====所重合！请重新绘画小区范围！");
                }
            }
        }
        return map;
    }

    @ApiOperation(value = "批量生成层和户", desc = "批量生成层和户")
    @systemOperateLog(operateType = OperateType.BATCH, desc = "批量生成层和户")
    public String createFloorNew(Map<String, Object> map) {
       // this.createGridSwitch(map);
        if (StringUtils.isEmpty(map.get("floorNum"))) {
            throw new CustomException("缺少参数！");
        }
        if (StringUtils.isEmpty(map.get("doorplateNum"))) {
            throw new CustomException("缺少参数！");
        }
        String unit_id = StringUtils.toString(map.get("unit_id"));
        int floorNum = 0;
        int doorplateNum = 0;
        try {
            floorNum = StringUtils.toInteger(map.get("floorNum"));
            doorplateNum = StringUtils.toInteger(map.get("doorplateNum"));
        } catch (Exception e) {
            throw new CustomException("请检查所填，层数，户数是否正确");
        }
        Map<String, Object> resultMap = commonService.getObject(nameSpace_for_residential + "findUnitById", map);
        if (resultMap == null) {
            throw new CustomException("新增层信息失败，未查询到上级信息！");
        }
        map.put("area_id", resultMap.get("area_id"));
        map.put("street_id", resultMap.get("street_id"));
        map.put("community_id", resultMap.get("community_id"));
        map.put("residential_id", resultMap.get("residential_id"));
        map.put("city_id", resultMap.get("city_id"));
        map.put("garden_id", resultMap.get("garden_id"));
        map.put("building_id", resultMap.get("building_id"));
      //  this.QYResidential(StringUtils.toString(resultMap.get("residential_id")));
        //this.QYGarden(StringUtils.toString(resultMap.get("garden_id")));
        //this.QYBuilding(StringUtils.toString(resultMap.get("building_id")));
        List<String> batchList = new ArrayList<>();
        for (int i = 1; i <= floorNum; i++) {
            map.put("grade", "9");
            map.put("name", i);
            map.put("sort", i);
            map.put("id", UUID.randomUUID().toString());
            commonService.insert(nameSpace_for_residential + "insertGridFloorNew", map);
            String floor_id = StringUtils.toString(map.get("id"));
            for (int j = 1; j <= doorplateNum; j++) {
                map.put("grade", "10");
                map.put("name", j);
                map.put("sort", j);
                map.put("floor_id", floor_id);
                String id = UUID.randomUUID().toString();
                map.put("id", id);
                batchList.add(id);
                commonService.insert(nameSpace_for_residential + "insertGridDoorplateNew", map);
            }
        }
        return "success";
    }

    @ApiOperation(value = "绘制1112范围", desc = "绘制范围")
    public String changeCommunityRange(Map<String, Object> map) {
        if (StringUtils.isEmpty(map.get("company_scope"))) {
            throw new CustomException("缺少参数！");
        }
        /*Map<String, Object> _userMap = (Map<String, Object>) map.get("_user");
            List<Point2D.Double> communityPointList = MapLngLatUtil.MapJSONToPointDouble(StringUtils.toString(map.get("company_scope")));
            List<Map<String, Object>> gardenList = commonService.findList(nameSpace_for_residential + "findGardenByCommunityList", map);
            for (Map<String, Object> gardenMap : gardenList) {
                List<Point2D.Double> gardenPointList = MapLngLatUtil.MapJSONToPointDouble((StringUtils.toString(gardenMap.get("csc_mapjson"))));
                boolean result = PolygonUtil.isPolygonInPolygon(gardenPointList, communityPointList);
                if (!result) {
                    throw new CustomException("当前选择社区不能完全包含网格，无法保存！");
                }
            }*/
        DataSourceSwitcher.setSharding("sc");
        DataSourceSwitcher.setMaster();
        if (commonService.update(nameSpace_for_residential + "updateCommunityCompanyScope", map) != 1) {
            throw new CustomException("绘制范围失败！");
        }
        return "success";
    }

    @ApiOperation(value = "绘制中心点", desc = "绘制中心点")
    public String changeCommunityCenter(Map<String, Object> map) {
        GridMapParamsUtil.GridMapParamsForString(map);
        DataSourceSwitcher.setSharding("sc");
        DataSourceSwitcher.setMaster();
        if (commonService.update(nameSpace_for_residential + "updateCommunityCscmapjson", map) != 1) {
            throw new CustomException("绘制中心点失败！");
        }
        return "success";
    }

    /**
     * 新版网格功能开关
     */
    public void createGridSwitch(Map<String, Object> map) {
        Map<String, Object> userMap = (Map<String, Object>) map.get("_user");
        if ("1ef0d524-976d-11eb-8fa5-0242ac110002".equals(userMap.get("company_id"))) {
            return;
        }
        String grade = StringUtils.toString(userMap.get("company_grade"));
        Map<String, Object> params = new HashMap<>();
        if ("2".equals(grade)) {
            String id = StringUtils.toString(userMap.get("company_id"));
            params.put("company_id", id);
        }
        if ("3".equals(grade)) {
            String id = StringUtils.toString(userMap.get("company_id"));
            params.put("company_id", id);
        }
        if ("4".equals(grade)) {
            String parent_ids = StringUtils.toString(userMap.get("parent_ids"));
            String x[] = parent_ids.split(",");
            String id = x[3];
            params.put("company_id", id);
        }
        if ("5".equals(grade)) {
            String parent_ids = StringUtils.toString(userMap.get("parent_ids"));
            String x[] = parent_ids.split(",");
            String id = x[3];
            params.put("company_id", id);
        }
        Map<String, Object> result = commonService.getObject(nameSpace_Switch + "getSwitchForCompanyID", params);
        if (result == null) {
            throw new CustomException(2222, "未查询到数据，功能暂停使用！");
        }
        String is_create = StringUtils.toString(result.get("is_create"));
        if ("0".equals(is_create)) {
            throw new CustomException(3333, "功能暂停使用！");
        }
    }

    public void updateGridSwitch(Map<String, Object> map) {
        Map<String, Object> userMap = (Map<String, Object>) map.get("_user");
        if ("1ef0d524-976d-11eb-8fa5-0242ac110002".equals(userMap.get("company_id"))) {
            return;
        }
        String grade = StringUtils.toString(userMap.get("company_grade"));
        Map<String, Object> params = new HashMap<>();
        if ("2".equals(grade)) {
            String id = StringUtils.toString(userMap.get("company_id"));
            params.put("company_id", id);
        }
        if ("3".equals(grade)) {
            String id = StringUtils.toString(userMap.get("company_id"));
            params.put("company_id", id);
        }
        if ("4".equals(grade)) {
            String parent_ids = StringUtils.toString(userMap.get("parent_ids"));
            String x[] = parent_ids.split(",");
            String id = x[3];
            params.put("company_id", id);
        }
        if ("5".equals(grade)) {
            String parent_ids = StringUtils.toString(userMap.get("parent_ids"));
            String x[] = parent_ids.split(",");
            String id = x[3];
            params.put("company_id", id);
        }
        /*Map<String, Object> result = commonService.getObject(nameSpace_Switch + "getSwitchForCompanyID", params);
        if (result == null) {
            throw new CustomException(2222, "未查询到数据，功能暂停使用！");
        }
        String is_update = StringUtils.toString(result.get("is_update"));
        if ("0".equals(is_update)) {
            throw new CustomException(3333, "功能暂停使用！");
        }*/
    }

    @ApiOperation(value = "修改层",desc = "修改层")
    public String updateFloor(Map<String, Object> map){
        if (commonService.update(nameSpace + "updateFloor",map) != 1){
            throw new CustomException("修改失败！");
        }
        Integer count = commonService.getObject(nameSpace + "getFloorNameCount",map);
        if (count > 1){
            throw new CustomException("层名称重复！");
        }
        return "success";
    }

    @ApiOperation(value = "单独生成层和户", desc = "单独生成层和户")
    @systemOperateLog(operateType = OperateType.INSERT, desc = "单独生成层和户")
    public String createFloorDoorplateNew(Map<String, Object> map) {
       // this.createGridSwitch(map);
        if ("floor".equals(map.get("type"))) {

            // 添加一层
            Map<String, Object> resultMap = commonService.getObject(nameSpace_for_residential + "findUnitById", map);
            map.put("area_id", resultMap.get("area_id"));
            map.put("street_id", resultMap.get("street_id"));
            map.put("city_id", resultMap.get("city_id"));
            map.put("community_id", resultMap.get("community_id"));
            map.put("residential_id", resultMap.get("residential_id"));
            map.put("garden_id", resultMap.get("garden_id"));
            map.put("building_id", resultMap.get("building_id"));
            map.put("id", UUID.randomUUID().toString());
            Integer count = commonService.getObject(nameSpace + "getFloorNameCount",map);
            if (count > 0){
                throw new CustomException("层名称重复！");
            }
//            this.QYResidential(StringUtils.toString(resultMap.get("residential_id")));
//            this.QYGarden(StringUtils.toString(resultMap.get("garden_id")));
//            this.QYBuilding(StringUtils.toString(resultMap.get("building_id")));
            if (commonService.insert(nameSpace_for_residential + "insertGridFloorNew", map) != 1) {
                throw new CustomException("新增层失败！");
            }
            this.updateFloorSort(map);
        } else if ("doorplate".equals(map.get("type"))) {
            // 添加一户
            Map<String, Object> resultMap = commonService.getObject(nameSpace_for_residential + "findFloorById", map);
            map.put("area_id", resultMap.get("area_id"));
            map.put("street_id", resultMap.get("street_id"));
            map.put("community_id", resultMap.get("community_id"));
            map.put("city_id", resultMap.get("city_id"));
            map.put("residential_id", resultMap.get("residential_id"));
            map.put("garden_id", resultMap.get("garden_id"));
            map.put("building_id", resultMap.get("building_id"));
            map.put("unit_id", resultMap.get("unit_id"));
            map.put("id", UUID.randomUUID().toString());
            Integer count = commonService.getObject(nameSpace + "getDoorplateNameCount",map);
            if (count > 0){
                throw new CustomException("户名称重复！");
            }
//            this.QYResidential(StringUtils.toString(resultMap.get("residential_id")));
//            this.QYGarden(StringUtils.toString(resultMap.get("garden_id")));
//            this.QYBuilding(StringUtils.toString(resultMap.get("building_id")));
            if (commonService.insert(nameSpace_for_residential + "insertGridDoorplateNew", map) != 1) {
                throw new CustomException("新增户失败！");
            }
        }
        return "success";
    }

    @ApiOperation(value = "查询社区编码", desc = "查询社区编码")
    public Map<String, Object> getCommunityAreaCode(Map<String, Object> map) {
        DataSourceSwitcher.setSharding("csc");
        DataSourceSwitcher.setSlave();
        return commonService.getObject(nameSpace_for_residential + "getCommunityAreaCode", map);
    }

    @ApiOperation(value = "小区编码", desc = "小区编码")
    @systemOperateLog(operateType = OperateType.UPDATE, desc = "小区编码")
    public String updateQHCodeForResidential(Map<String, Object> map) {
        if (StringUtils.isEmpty(map.get("community_qh_code"))) {
            throw new CustomException("缺少参数1！");
        }
        if (StringUtils.isEmpty(map.get("last_qh_code"))) {
            throw new CustomException("缺少参数2！");
        }
        String community_qh_code = StringUtils.toString(map.get("community_qh_code"));
        String last_qh_code = StringUtils.toString(map.get("last_qh_code")).trim();
        Map<String, Object> _user = (Map<String, Object>) map.get("_user");
        String level = StringUtils.toString(_user.get("level"));
        String community_type = "";
        if ("40".equals(level)) {
            community_type = "1";
        }
        if ("45".equals(level)) {
            community_type = "2";
        }
        if (last_qh_code.length() != 2) {
            throw new CustomException("编码不符合规则！");
        }
        if (!org.apache.commons.lang3.StringUtils.isNumeric(last_qh_code)) {
            throw new CustomException("编码需为纯数字！");
        }
        map.put("result_code", community_qh_code + community_type + last_qh_code);
        if (commonService.update(nameSpace_for_residential + "updateResidentialQHCode", map) != 1) {
            throw new CustomException("编码保存失败！");
        }
        if (!StringUtils.isEmpty(map.get("old_qh_code"))) {
            // 修改下级
            commonService.update(nameSpace_for_residential + "updateGardenQHCodePL", map);
        }
        return "success";
    }

    @ApiOperation(value = "查询小区编码", desc = "查询小区编码")
    public Map<String, Object> getCommunityResidentialCode(Map<String, Object> map) {
        if (StringUtils.isEmpty(map.get("residential_id"))) {
            throw new CustomException("缺少参数！");
        }
        Map<String, Object> retMap = commonService.getObject(nameSpace_for_residential + "getCommunityResidentialCode", map);
        if (retMap == null) {
            throw new CustomException("查询失败！请先编写小区编码！");
        }
        return retMap;
    }

    @ApiOperation(value = "网格编码", desc = "网格编码")
    @systemOperateLog(operateType = OperateType.UPDATE, desc = "网格编码")
    public String updateQHCodeForGarden(Map<String, Object> map) {
        if (StringUtils.isEmpty(map.get("residential_qh_code"))) {
            throw new CustomException("缺少参数1！");
        }
        if (StringUtils.isEmpty(map.get("last_garden_qh_code"))) {
            throw new CustomException("缺少参数2！");
        }
        String residential_qh_code = StringUtils.toString(map.get("residential_qh_code"));
        String last_garden_qh_code = StringUtils.toString(map.get("last_garden_qh_code")).trim();
        if (last_garden_qh_code.length() != 2) {
            throw new CustomException("编码不符合规则！");
        }
        if (!org.apache.commons.lang3.StringUtils.isNumeric(last_garden_qh_code)) {
            throw new CustomException("编码需为纯数字！");
        }
        map.put("result_code", residential_qh_code + last_garden_qh_code);
        if (commonService.update(nameSpace_for_residential + "updateGardenQHCode", map) != 1) {
            throw new CustomException("编码保存失败！");
        }
        return "success";
    }

    @ApiOperation(value = "创建网格", desc = "创建网格")
    @systemOperateLog(operateType = OperateType.SAVE, desc = "创建网格层级")
    public String createGridLevel(Map<String, Object> map) {
        Map<String, Object> _userMap = (Map<String, Object>) map.get("_user");
        if (!("4".equals(_userMap.get("company_grade")) || "5".equals(_userMap.get("company_grade")) || "6".equals(_userMap.get("company_grade")))) {
            throw new CustomException("当前帐号等级，不允许此操作！");
        }

        if (StringUtils.isEmpty(map.get("grade"))) {
            throw new CustomException("缺少参数:grade！");
        }
        if (StringUtils.isEmpty(map.get("name"))) {
            throw new CustomException("缺少参数:名称");
        }
        String grade = StringUtils.toString(map.get("grade"));
        switch (grade) {
            case "6.5":
                GridMapParamsUtil.GridMapParamsForArray(map);
                UnifyLogger.parent("createGridLevel===" + map,UnifyLogger.Level.INFO);
                if(StringUtils.isEmpty(map.get("address"))){
                    throw new CustomException("缺少参数:详细地址！");
                }
                if(map.get("id") != null && !"".equals(map.get("id"))) {
                    this.updateGridSwitch(map);
                    map.put("operateType","UPDATE");
                    //修改
                    if(commonService.update(nameSpace_for_residential + "createGridResidential",map) != 1){
                        throw new CustomException("修改小区信息失败");
                    }
                    Integer cunt = commonService.getObject(nameSpace + "getResidentialNameCount",map);
                    if (cunt > 1){
                        throw new CustomException("小区名称重复");
                    }
                }else {
                    Integer cunt = commonService.getObject(nameSpace + "getResidentialNameCount",map);
                    if (cunt > 0){
                        throw new CustomException("小区名称重复");
                    }
//                    this.createGridSwitch(map);
                    String parent_ids = StringUtils.toString(_userMap.get("parent_ids"));
                    String x[] = parent_ids.split(",");
                    map.put("city_id", x[x.length - 3]);
                    map.put("area_id", x[x.length-2]);
                    map.put("street_id", x[x.length-1]);
                    map.put("community_id",_userMap.get("company_id"));
                    map.put("id",UUID.randomUUID().toString());
                    map.put("operateType","INSERT");
                    if(commonService.insert(nameSpace_for_residential + "createGridResidential",map) != 1){
                        throw new CustomException("创建小区失败！");
                    }
                }
                break;
            case "7":
                GridMapParamsUtil.GridMapParamsForArray(map);
                Map<String, Object> communityMap = commonService.getObject(nameSpace_office+"getCommunityByID", map);
                if ("HT".equals(map.get("mapType"))) {
                    List<Map<String, Object>> gardenList = commonService.findList(nameSpace_for_residential + "findGardenByCommunityList", map);
                }
                if (map.get("id") != null && !"".equals(map.get("id"))) {
                    /*
                     //开关控制是否可编辑权限 此功能废弃
                    this.updateGridSwitch(map);*/
                    map.put("operateType", "UPDATE");
                    //修改
                    if (commonService.update(nameSpace_for_residential + "updateGridGardenNew", map) != 1) {
                        throw new CustomException("修改网格信息失败");
                    }
                    Integer cunt = commonService.getObject(nameSpace + "getGardenNameCount",map);
                    if (cunt > 1){
                        throw new CustomException("网格名称重复");
                    }
                } else {
                    /* //开关控制是否可编辑权限 此功能废弃
                    this.createGridSwitch(map);*/
                    Integer cunt = commonService.getObject(nameSpace + "getGardenNameCount",map);
                    if (cunt > 0){
                        throw new CustomException("网格名称重复");
                    }
                    String parent_ids = StringUtils.toString(_userMap.get("parent_ids"));
                    String x[] = parent_ids.split(",");
                    map.put("city_id", x[x.length - 3]);
                    map.put("area_id", x[x.length - 2]);
                    map.put("street_id", x[x.length - 1]);
                    map.put("community_id", _userMap.get("company_id"));
                    map.put("id", UUID.randomUUID().toString());
                    map.put("operateType", "INSERT");
                    if (commonService.insert(nameSpace_for_residential + "insertGridGardenNew", map) != 1) {
                        throw new CustomException("创建网格失败！");
                    }
                }
                break;
            case "8":
                GridMapParamsUtil.GridMapParamsForString(map);
                /*if (StringUtils.isEmpty(map.get("brand"))) {
                    throw new CustomException("缺少参数:brand！");
                }*/
                if (StringUtils.isEmpty(map.get("residential_id"))) {
                    throw new CustomException("缺少参数:residential_id！");
                }
                Map<String, Object> GardenMap = commonService.getObject(nameSpace_for_residential + "getResidentialByResidentialID", map);
                if (map.get("id") != null && !"".equals(map.get("id"))) {
                  //  this.updateGridSwitch(map);
                    map.put("operateType", "UPDATE");
//                    sysOfficeLevelService.disposeBuildingScope(map);
                    if (commonService.update(nameSpace_for_residential + "updateGridBuildingNew", map) != 1) {
                        throw new CustomException("修改楼信息失败");
                    }
                    Integer cunt = commonService.getObject(nameSpace + "getBuildingNameCount",map);
                    if (cunt > 1){
                        throw new CustomException("楼名称重复");
                    }
                } else {
                    Integer cunt = commonService.getObject(nameSpace + "getBuildingNameCount",map);
                    if (cunt > 0){
                        throw new CustomException("楼名称重复");
                    }
                //    this.createGridSwitch(map);
                    map.put("area_id", GardenMap.get("area_id"));
                    map.put("street_id", GardenMap.get("street_id"));
                    map.put("community_id", GardenMap.get("community_id"));
                    map.put("residential_id",GardenMap.get("id"));
                    map.put("garden_id",GardenMap.get("garden_id"));
                    map.put("city_id", GardenMap.get("city_id"));
                    map.put("id", UUID.randomUUID().toString());
                    map.put("operateType", "INSERT");
                    // 有迁移申请时，无法新建
                  //  this.QYResidential(StringUtils.toString(GardenMap.get("residential_id")));
                  //  this.QYGarden(StringUtils.toString(map.get("garden_id")));
//                    sysOfficeLevelService.disposeBuildingScope(map);
                    if (commonService.insert(nameSpace_for_residential + "insertGridBuildingNew", map) != 1) {
                        throw new CustomException("创建楼失败！");
                    }
                }
                break;
            case "9":
                Map<String, Object> BuildingMap = commonService.getObject(nameSpace_for_residential + "getBuildingByID", map);
                if (map.get("id") != null && !"".equals(map.get("id"))) {
                 //   this.updateGridSwitch(map);
                    map.put("operateType", "UPDATE");
                    if (commonService.update(nameSpace_for_residential + "updateGridUnitNew", map) != 1) {
                        throw new CustomException("修改单元信息失败");
                    }
                    Integer cunt = commonService.getObject(nameSpace + "getUnitNameCount",map);
                    if (cunt > 1){
                        throw new CustomException("单元名称重复");
                    }
                } else {
                    Integer cunt = commonService.getObject(nameSpace + "getUnitNameCount",map);
                    if (cunt > 0){
                        throw new CustomException("单元名称重复");
                    }
                   // this.createGridSwitch(map);
                    map.put("area_id", BuildingMap.get("area_id"));
                    map.put("street_id", BuildingMap.get("street_id"));
                    map.put("community_id", BuildingMap.get("community_id"));
                    map.put("residential_id",BuildingMap.get("residential_id"));
                    map.put("city_id", BuildingMap.get("city_id"));
                    map.put("garden_id", BuildingMap.get("garden_id"));
                    map.put("id", UUID.randomUUID().toString());
                    map.put("operateType", "INSERT");
                    // 有迁移申请时，无法新建
                  //  this.QYResidential(StringUtils.toString(BuildingMap.get("residential_id")));
                    //this.QYGarden(StringUtils.toString(BuildingMap.get("garden_id")));
                    //this.QYBuilding(StringUtils.toString(map.get("building_id")));
                    if (commonService.insert(nameSpace_for_residential + "insertGridUnitNew", map) != 1) {
                        throw new CustomException("创建单元失败！");
                    }
                }
                break;
            default:

        }
        return "success";
    }

    public void QYGarden(String garden_id) {
        if (StringUtils.isEmpty(garden_id)) {
            throw new CustomException("QYResidential缺少参数！garden_id");
        }
        Map<String, Object> map = commonService.getObject(nameSpace + "getJudgeGardenForQYID", garden_id);
        if (map != null) {
            throw new CustomException("存在数据情况迁移情况，无法操作-2！");
        }
    }

    public void QYBuilding(String building_id) {
        if (StringUtils.isEmpty(building_id)) {
            throw new CustomException("QYResidential缺少参数！building_id");
        }
        Map<String, Object> map = commonService.getObject(nameSpace + "getJudgeBuildingForQYID", building_id);
        if (map != null) {
            throw new CustomException("存在数据情况迁移情况，无法操作-3！");
        }
    }


    public void updateFloorSort(Map<String, Object> map) {
        if (StringUtils.isEmpty(map.get("unit_id"))) {
            throw new CustomException("缺少参数！");
        }
        commonService.update(nameSpace_for_residential + "updateFLoorSort", map);
    }
}
