package com.scpyun.platform.jilinsscgsdp.bean.vo.task;


import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Update;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.Pattern;

public class ReqHomicideCaseVo extends ReqBaseVo {

    /**
     * 主键ID
     */
    @NotEmpty(message = "主键ID不可为空", groups = {Insert.class, Update.class})
    private String id;

    /**
     * 市编码
     */
    @NotEmpty(message = "市编码不可为空", groups = {Insert.class, Update.class})
    @Pattern(regexp = "^\\d{12}$", message = "所属市编码格式异常", groups = {Insert.class, Update.class})
    private String cityCode;

    /**
     * 区编码
     */
    @NotEmpty(message = "区编码不可为空", groups = {Insert.class, Update.class})
    @Pattern(regexp = "^\\d{12}$", message = "所属区编码格式异常", groups = {Insert.class, Update.class})
    private String areaCode;

    /**
     * 街道编码
     */
    @NotEmpty(message = "街道编码不可为空", groups = {Insert.class, Update.class})
    @Pattern(regexp = "^\\d{12}$", message = "街道编码格式异常", groups = {Insert.class, Update.class})
    private String streetCode;

    /**
     * 社区编码
     */
    @NotEmpty(message = "社区编码不可为空", groups = {Insert.class, Update.class})
    @Pattern(regexp = "^\\d{12}$", message = "社区编码格式异常", groups = {Insert.class, Update.class})
    private String communityCode;

    /**
     * 案发时间
     */
    @NotEmpty(message = "案发时间不可为空", groups = {Insert.class, Update.class})
    private String incidentTime;

    /**
     * 地市对接id
     */
    private String dockingId;

    /**
     * appid
     */
    @NotEmpty(message = "appid不可为空", groups = {Insert.class, Update.class})
    private String appid;

    /**
     * 添加状态
     */
    private String type;

    /**
     * 操作状态 1成功 2失败
     */
    private String operateType;

    /**
     * 地区类别 1:城市(区) 2:农村
     */
    @NotEmpty(message = "地区类别不可为空", groups = {Insert.class, Update.class})
    @Pattern(regexp = "^[1-2]$", message = "地区类别值必须为1-2", groups = {Insert.class, Update.class})
    private String areaType;

    /**
     * 案发原因 1:婚恋家庭 2:邻里纠纷 3:土地及资源权属纠纷 4:侵权相关纠纷 5:城乡建设发展纠纷 6:物权相关纠纷 7:合同及相关纠纷 8:劳动人事争议 9:涉法涉诉纠纷 10:其他
     */
//    @NotEmpty(message = "案发原因不可为空", groups = {Insert.class, Update.class})
//    @Pattern(regexp = "^[0-9]|10$", message = "案发原因值必须为1-10", groups = {Insert.class, Update.class})
    private String caseReason;

    /**
     * 涉案人数
     */
    @NotEmpty(message = "涉案人数不可为空", groups = {Insert.class, Update.class})
    @Length(max = 2, message = "涉案人数字符长度不可超过2", groups = {Insert.class, Update.class})
    private String involvedNumber;

   /**
     * 简要案情
     */
    @NotEmpty(message = "简要案情不可为空", groups = {Insert.class, Update.class})
    private String caseDescription;
    @NotEmpty(message = "死亡人数不可为空", groups = {Insert.class, Update.class})
    @Length(max = 4, message = "死亡人数字符长度不可超过4", groups = {Insert.class, Update.class})
    private String deadNumber;
    @NotEmpty(message = "案发原因不可为空", groups = {Insert.class, Update.class})
    @Length(max = 2, message = "案发原因字符长度不可超过2", groups = {Insert.class, Update.class})
    private String reasonIncident;
    @NotEmpty(message = "属于类别不可为空", groups = {Insert.class, Update.class})
    @Length(max = 2, message = "属于类别字符长度不可超过2", groups = {Insert.class, Update.class})
    private String deadType;

    public String getDeadNumber() {
        return deadNumber;
    }

    public void setDeadNumber(String deadNumber) {
        this.deadNumber = deadNumber;
    }

    public String getReasonIncident() {
        return reasonIncident;
    }

    public void setReasonIncident(String reasonIncident) {
        this.reasonIncident = reasonIncident;
    }

    public String getDeadType() {
        return deadType;
    }

    public void setDeadType(String deadType) {
        this.deadType = deadType;
    }

    public String getCaseDescription() {
        return caseDescription;
    }

    public void setCaseDescription(String caseDescription) {
        this.caseDescription = caseDescription;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getOperateType() {
        return operateType;
    }

    public void setOperateType(String operateType) {
        this.operateType = operateType;
    }

    public String getAppid() {
        return appid;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public String getDockingId() {
        return dockingId;
    }

    public void setDockingId(String dockingId) {
        this.dockingId = dockingId;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getIncidentTime() {
        return incidentTime;
    }

    public void setIncidentTime(String incidentTime) {
        this.incidentTime = incidentTime;
    }

    public String getCaseReason() {
        return caseReason;
    }

    public void setCaseReason(String caseReason) {
        this.caseReason = caseReason;
    }

    public String getAreaType() {
        return areaType;
    }

    public void setAreaType(String areaType) {
        this.areaType = areaType;
    }

    public String getInvolvedNumber() {
        return involvedNumber;
    }

    public void setInvolvedNumber(String involvedNumber) {
        this.involvedNumber = involvedNumber;
    }

    public String getCityCode() {
        return cityCode;
    }

    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }

    public String getAreaCode() {
        return areaCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    public String getStreetCode() {
        return streetCode;
    }

    public void setStreetCode(String streetCode) {
        this.streetCode = streetCode;
    }

    public String getCommunityCode() {
        return communityCode;
    }

    public void setCommunityCode(String communityCode) {
        this.communityCode = communityCode;
    }
}
